/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.meta.impl;

import to.etc.domui.util.IValueAccessor;
import to.etc.domui.util.InstanceRefresher;

public class SubAccessor<B, V>
implements IValueAccessor<V> {
    private IValueAccessor<B> m_rootAccessor;
    private IValueAccessor<V> m_valueAccessor;

    public SubAccessor(IValueAccessor<B> rootAccessor, IValueAccessor<V> valueAccessor) {
        this.m_rootAccessor = rootAccessor;
        this.m_valueAccessor = valueAccessor;
    }

    @Override
    public V getValue(Object in) throws Exception {
        Object root = this.m_rootAccessor.getValue(in);
        if (root == null) {
            return null;
        }
        InstanceRefresher.refresh(in);
        return (V)this.m_valueAccessor.getValue(root);
    }

    @Override
    public void setValue(Object target, V value) throws Exception {
        Object root = this.m_rootAccessor.getValue(target);
        if (root == null) {
            throw new IllegalStateException("The value is null: cannot reach a relational object.");
        }
        this.m_valueAccessor.setValue(root, value);
    }

    @Override
    public boolean isReadOnly() {
        return this.m_valueAccessor.isReadOnly();
    }
}

