/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.misc;

import javax.annotation.Nonnull;
import to.etc.domui.component.misc.WindowParameters;
import to.etc.domui.dom.html.ATag;
import to.etc.domui.dom.html.ClickInfo;
import to.etc.domui.dom.html.Page;
import to.etc.domui.dom.html.UrlPage;
import to.etc.domui.state.IPageParameters;
import to.etc.domui.state.MoveMode;
import to.etc.domui.state.PageParameters;
import to.etc.domui.state.UIContext;
import to.etc.domui.util.DomUtil;
import to.etc.util.StringTool;

public class ALink
extends ATag {
    private Class<? extends UrlPage> m_targetClass;
    private String m_targetURL;
    private IPageParameters m_targetParameters;
    private WindowParameters m_newWindowParameters;
    private MoveMode m_moveMode = MoveMode.SUB;
    private String m_imageUrl;

    public ALink() {
    }

    public ALink(Class<? extends UrlPage> targetClass) {
        this(targetClass, null, null, null);
    }

    public ALink(Class<? extends UrlPage> targetClass, MoveMode mode) {
        this(targetClass, null, null, mode);
    }

    public ALink(Class<? extends UrlPage> targetClass, IPageParameters targetParameters) {
        this(targetClass, targetParameters, null, null);
    }

    public ALink(Class<? extends UrlPage> targetClass, IPageParameters targetParameters, MoveMode mode) {
        this(targetClass, targetParameters, null, mode);
    }

    public ALink(Class<? extends UrlPage> targetClass, IPageParameters targetParameters, WindowParameters newWindowParameters) {
        this(targetClass, targetParameters, newWindowParameters, null);
    }

    private ALink(Class<? extends UrlPage> targetClass, IPageParameters targetParameters, WindowParameters newWindowParameters, MoveMode mode) {
        this.setCssClass("ui-alnk");
        this.m_targetClass = targetClass;
        this.m_targetParameters = targetParameters;
        this.m_newWindowParameters = newWindowParameters;
        if (mode != null) {
            this.m_moveMode = mode;
        }
        this.updateLink();
    }

    public ALink(String targetURL, IPageParameters targetParameters, WindowParameters newWindowParameters) {
        this.setCssClass("ui-alnk");
        this.m_targetURL = targetURL;
        this.m_targetParameters = targetParameters;
        this.m_newWindowParameters = newWindowParameters;
        this.updateLink();
    }

    public Class<? extends UrlPage> getTargetClass() {
        return this.m_targetClass;
    }

    public void setTargetClass(Class<? extends UrlPage> targetClass, Object ... parameters) {
        this.m_targetClass = targetClass;
        this.m_targetParameters = parameters == null || parameters.length == 0 ? null : new PageParameters(parameters);
        this.updateLink();
    }

    public IPageParameters getTargetParameters() {
        return this.m_targetParameters;
    }

    public void setTargetParameters(PageParameters targetParameters) {
        if (DomUtil.isEqual((Object)this.m_targetParameters, (Object)targetParameters)) {
            return;
        }
        this.m_targetParameters = targetParameters;
        this.updateLink();
    }

    public WindowParameters getNewWindowParameters() {
        return this.m_newWindowParameters;
    }

    public void setNewWindowParameters(WindowParameters newWindowParameters) {
        if (DomUtil.isEqual((Object)this.m_newWindowParameters, (Object)newWindowParameters)) {
            return;
        }
        this.m_newWindowParameters = newWindowParameters;
        this.updateLink();
    }

    public MoveMode getMoveMode() {
        return this.m_moveMode;
    }

    public void setMoveMode(MoveMode moveMode) {
        this.m_moveMode = moveMode;
    }

    private void updateLink() {
        if (this.m_targetClass != null) {
            this.setHref(DomUtil.createPageURL(this.m_targetClass, this.m_targetParameters));
        } else if (!DomUtil.isBlank(this.m_targetURL)) {
            this.setHref(DomUtil.createPageURL(this.m_targetURL, this.m_targetParameters));
        } else {
            this.setHref(null);
            return;
        }
        if (this.getClicked() == null && this.getNewWindowParameters() != null) {
            StringBuilder sb = new StringBuilder();
            String wid = DomUtil.generateGUID();
            sb.append("return DomUI.openWindow('");
            if (!DomUtil.isBlank(this.m_targetURL)) {
                sb.append(DomUtil.createPageURL(this.m_targetURL, this.m_targetParameters));
            } else {
                sb.append(DomUtil.createPageURL(this.m_targetClass, null));
                sb.append('?');
                StringTool.encodeURLEncoded((Appendable)sb, (String)"$cid");
                sb.append('=');
                sb.append(wid);
                sb.append(".x");
                if (this.m_targetParameters != null) {
                    DomUtil.addUrlParameters(sb, this.m_targetParameters, false);
                }
            }
            sb.append("','");
            sb.append(wid);
            sb.append("','");
            sb.append("resizable=");
            sb.append(this.m_newWindowParameters.isResizable() ? "yes" : "no");
            sb.append(",scrollbars=");
            sb.append(this.m_newWindowParameters.isShowScrollbars() ? "yes" : "no");
            sb.append(",toolbar=");
            sb.append(this.m_newWindowParameters.isShowToolbar() ? "yes" : "no");
            sb.append(",location=");
            sb.append(this.m_newWindowParameters.isShowLocation() ? "yes" : "no");
            sb.append(",directories=");
            sb.append(this.m_newWindowParameters.isShowDirectories() ? "yes" : "no");
            sb.append(",status=");
            sb.append(this.m_newWindowParameters.isShowStatus() ? "yes" : "no");
            sb.append(",menubar=");
            sb.append(this.m_newWindowParameters.isShowMenubar() ? "yes" : "no");
            sb.append(",copyhistory=");
            sb.append(this.m_newWindowParameters.isCopyhistory() ? "yes" : "no");
            if (this.m_newWindowParameters.getWidth() > 0) {
                sb.append(",width=");
                sb.append(this.m_newWindowParameters.getWidth());
            }
            if (this.m_newWindowParameters.getHeight() > 0) {
                sb.append(",height=");
                sb.append(this.m_newWindowParameters.getHeight());
            }
            sb.append("');");
            this.setOnClickJS(sb.toString());
        }
    }

    @Override
    public boolean internalNeedClickHandler() {
        return this.getClicked() != null || this.getNewWindowParameters() == null;
    }

    @Override
    public void internalOnClicked(@Nonnull ClickInfo cli) throws Exception {
        if (this.getClicked() != null) {
            super.internalOnClicked(cli);
            return;
        }
        if (this.m_targetClass == null) {
            return;
        }
        if (this.m_newWindowParameters != null) {
            String open = DomUtil.createOpenWindowJS(this.m_targetClass, this.m_targetParameters, this.m_newWindowParameters);
            this.appendJavascript(open);
            return;
        }
        UIContext.getRequestContext().getWindowSession().internalSetNextPage(this.m_moveMode, this.m_targetClass, null, null, this.m_targetParameters);
    }

    public void setImage(String url) {
        if (DomUtil.isEqual((Object)url, (Object)this.m_imageUrl)) {
            return;
        }
        this.m_imageUrl = url;
        if (this.m_imageUrl != null) {
            this.addCssClass("ui-alnk-i");
        } else {
            this.removeCssClass("ui-alnk-i");
        }
        this.changed();
        this.updateStyle();
    }

    @Override
    public void onAddedToPage(Page p) {
        super.onAddedToPage(p);
        this.updateStyle();
    }

    public void setImage(Class<?> resourceBase, String name) {
        this.setImage(DomUtil.getJavaResourceRURL(resourceBase, name));
    }

    public String getImage() {
        return this.m_imageUrl;
    }

    private void updateStyle() {
        String imageUrl;
        if (this.isAttached() && null != (imageUrl = this.m_imageUrl)) {
            this.setBackgroundImage(this.getThemedResourceRURL(imageUrl));
        }
    }
}

