/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.misc;

import javax.annotation.Nullable;
import to.etc.domui.dom.html.IDisplayControl;
import to.etc.domui.dom.html.IValueChanged;
import to.etc.domui.dom.html.Img;
import to.etc.domui.util.DomUtil;

public class DisplayCheckbox
extends Img
implements IDisplayControl<Boolean> {
    private Boolean m_value;

    public DisplayCheckbox() {
        this.setCssClass("ui-dspcb");
        this.setSrc("THEME/dspcb-off.png");
    }

    @Override
    public Boolean getValue() {
        return this.m_value;
    }

    @Override
    public void setValue(@Nullable Boolean v) {
        if (DomUtil.isEqual((Object)v, (Object)this.m_value)) {
            return;
        }
        this.m_value = v;
        if (v == null) {
            this.setSrc("THEME/dspcb-off.png");
        } else if (v.booleanValue()) {
            this.setSrc("THEME/dspcb-on.png");
        } else {
            this.setSrc("THEME/dspcb-off.png");
        }
    }

    public void setChecked(boolean on) {
        this.setValue(on);
    }

    public boolean isChecked() {
        Boolean value = this.getValue();
        return value != null && value != false;
    }

    @Override
    public Boolean getValueSafe() {
        return this.getValue();
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public void setReadOnly(boolean ro) {
    }

    @Override
    public boolean isDisabled() {
        return false;
    }

    @Override
    public boolean isMandatory() {
        return false;
    }

    @Override
    public void setMandatory(boolean ro) {
    }

    @Override
    public void setDisabled(boolean d) {
    }

    @Override
    public IValueChanged<?> getOnValueChanged() {
        return null;
    }

    @Override
    public void setOnValueChanged(IValueChanged<?> onValueChanged) {
        throw new UnsupportedOperationException("Display control");
    }
}

