/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.misc;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.input.ITypedControl;
import to.etc.domui.component.meta.ClassMetaModel;
import to.etc.domui.component.meta.MetaManager;
import to.etc.domui.component.meta.PropertyMetaModel;
import to.etc.domui.converter.ConverterRegistry;
import to.etc.domui.converter.IConvertable;
import to.etc.domui.converter.IConverter;
import to.etc.domui.dom.html.IDisplayControl;
import to.etc.domui.dom.html.IValueChanged;
import to.etc.domui.dom.html.Span;
import to.etc.domui.util.DomUtil;
import to.etc.domui.util.INodeContentRenderer;
import to.etc.webapp.nls.NlsContext;

public class DisplaySpan<T>
extends Span
implements IDisplayControl<T>,
IConvertable<T>,
ITypedControl<T> {
    @Nonnull
    private Class<T> m_valueClass;
    @Nullable
    private T m_value;
    @Nullable
    private IConverter<T> m_converter;
    @Nullable
    private INodeContentRenderer<T> m_renderer;
    @Nullable
    private String m_emptyString;

    public DisplaySpan(@Nonnull Class<T> valueClass) {
        this(valueClass, null);
    }

    public DisplaySpan(@Nonnull Class<T> valueClass, @Nullable T value) {
        this.m_valueClass = valueClass;
        this.m_value = value;
    }

    public DisplaySpan(@Nonnull T literal) {
        this.m_valueClass = literal.getClass();
        this.m_value = literal;
    }

    @Override
    @Nonnull
    public Class<T> getActualType() {
        return this.m_valueClass;
    }

    @Override
    public void createContent() throws Exception {
        T val = this.getValue();
        if (val == null) {
            this.setString(null);
            return;
        }
        IConverter<T> converter = this.getConverter();
        if (converter != null) {
            String converted = converter.convertObjectToString(NlsContext.getLocale(), val);
            this.setString(converted);
            return;
        }
        INodeContentRenderer<T> renderer = this.getRenderer();
        if (renderer != null) {
            renderer.renderNodeContent(this, this, val, null);
            if (this.getChildCount() == 0 && this.m_emptyString != null) {
                this.add(this.m_emptyString);
            }
            return;
        }
        IConverter<T> c = ConverterRegistry.findConverter(this.getActualType());
        if (c != null) {
            String converted = c.convertObjectToString(NlsContext.getLocale(), val);
            this.setString(converted);
            return;
        }
        ClassMetaModel cmm = MetaManager.findClassMeta(val.getClass());
        if (cmm.getDomainValues() != null) {
            String label = cmm.getDomainLabel(NlsContext.getLocale(), val);
            if (label == null) {
                label = val.toString();
            }
            this.setString(label);
            return;
        }
        INodeContentRenderer<?> ncr = MetaManager.createDefaultComboRenderer(null, cmm);
        ncr.renderNodeContent(this, this, val, null);
        if (this.getChildCount() == 0 && this.m_emptyString != null) {
            this.setText(this.m_emptyString);
        }
    }

    private void setString(@Nullable String v) {
        if (v == null) {
            v = this.m_emptyString;
        }
        if (v != null) {
            this.setText(v);
        } else {
            this.removeAllChildren();
        }
    }

    @Override
    @Nullable
    public IConverter<T> getConverter() {
        return this.m_converter;
    }

    @Override
    public void setConverter(@Nullable IConverter<T> converter) {
        if (this.m_renderer != null && converter != null) {
            throw new IllegalStateException("You cannot both use a renderer AND a converter. Set the renderer to null before setting a converter.");
        }
        this.m_converter = converter;
    }

    @Nullable
    public INodeContentRenderer<T> getRenderer() {
        return this.m_renderer;
    }

    public void setRenderer(@Nullable INodeContentRenderer<T> renderer) {
        if (this.m_renderer == renderer) {
            return;
        }
        if (this.m_converter != null && renderer != null) {
            throw new IllegalStateException("You cannot both use a renderer AND a converter. Set the converter to null before setting a renderer.");
        }
        this.m_renderer = renderer;
        this.forceRebuild();
    }

    @Nullable
    public String getEmptyString() {
        return this.m_emptyString;
    }

    public void setEmptyString(@Nullable String emptyString) {
        this.m_emptyString = emptyString;
    }

    @Override
    @Nullable
    public T getValue() {
        return this.m_value;
    }

    @Override
    public void setValue(@Nullable T v) {
        if (DomUtil.isEqual(this.m_value, v)) {
            return;
        }
        T oldvalue = this.m_value;
        this.m_value = v;
        this.forceRebuild();
    }

    public void defineFrom(@Nonnull PropertyMetaModel<?> pmm) {
        String s = pmm.getDefaultHint();
        if (s != null) {
            this.setTitle(s);
        }
    }

    @Override
    public IValueChanged<?> getOnValueChanged() {
        return null;
    }

    @Override
    public void setOnValueChanged(IValueChanged<?> onValueChanged) {
    }

    @Override
    public T getValueSafe() {
        return this.getValue();
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public void setReadOnly(boolean ro) {
    }

    @Override
    public boolean isDisabled() {
        return false;
    }

    @Override
    public boolean isMandatory() {
        return false;
    }

    @Override
    public void setMandatory(boolean ro) {
    }

    @Override
    public void setDisabled(boolean d) {
    }
}

