/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.misc;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.buttons.LinkButton;
import to.etc.domui.component.misc.MsgBox;
import to.etc.domui.dom.html.Div;
import to.etc.domui.dom.html.IClicked;
import to.etc.domui.dom.html.Img;
import to.etc.domui.dom.html.ImgAlign;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.dom.html.NodeContainer;
import to.etc.domui.dom.html.TBody;
import to.etc.domui.dom.html.TD;
import to.etc.domui.dom.html.TR;
import to.etc.domui.dom.html.UrlPage;
import to.etc.domui.server.DomApplication;
import to.etc.domui.util.DomUtil;
import to.etc.util.FileTool;

public class InternalParentTree
extends Div {
    private static final String PMS = ". Please make sure you use the latest plugin version always.";
    private NodeBase m_touched;
    private Div m_structure;
    private static final String URL = "http://www.domui.org/wiki/bin/view/Documentation/EclipsePlugin";

    public InternalParentTree(NodeBase touched) {
        this.m_touched = touched;
    }

    @Override
    public void createContent() throws Exception {
        Div list;
        this.setCssClass("ui-ipt");
        Div ttl = new Div();
        this.add(ttl);
        ttl.setCssClass("ui-ipt-ttl");
        ttl.add("Development: Parent Structure");
        Img img = new Img("THEME/close.png");
        img.setAlign(ImgAlign.RIGHT);
        ttl.add(img);
        img.setClicked(new IClicked<Img>(){

            @Override
            public void clicked(@Nonnull Img clickednode) throws Exception {
                InternalParentTree.this.remove();
            }
        });
        this.m_structure = list = new Div();
        this.add(list);
        list.setCssClass("ui-ipt-list");
        this.renderStructure(list);
        this.appendCreateJS("$('#" + this.getActualID() + "').draggable({ghosting: false, zIndex:" + 200 + ", handle: '#" + ttl.getActualID() + "'});");
    }

    protected void renderStructure(Div list) {
        TBody b = list.addTable(new String[0]);
        for (NodeBase nb = this.m_touched; nb != null; nb = nb.getParent()) {
            final NodeBase clicked = nb;
            TR row = b.addRow();
            row.setCssClass("ui-ipt-item");
            TD td = b.addCell();
            td.setCellWidth("1%");
            String icon = "";
            String nn = nb.getClass().getName();
            if (nn.startsWith("to.etc.domui.dom.")) {
                icon = "iptHtml.png";
                td.setTitle("HTML Node");
            } else if (nb instanceof UrlPage) {
                icon = "iptPage.png";
                td.setTitle("DomUI Page");
            } else {
                td.setTitle("DomUI Component");
                icon = "iptComponent.png";
            }
            td.add(new Img("THEME/" + icon));
            td = b.addCell();
            td.setCssClass("ui-ipt-btn");
            td.setCellWidth("1%");
            td.setClicked(new IClicked<NodeBase>(){

                @Override
                public void clicked(@Nonnull NodeBase clickednode) throws Exception {
                    InternalParentTree.this.openSource(clicked);
                }
            });
            td.setTitle("Open the component's source code");
            td.add(new Img("THEME/iptSourceCode.png"));
            if (null != nb.getAllocationTracepoint()) {
                td = b.addCell();
                td.setCssClass("ui-ipt-btn");
                td.setCellWidth("1%");
                td.setClicked(new IClicked<NodeBase>(){

                    @Override
                    public void clicked(@Nonnull NodeBase clickednode) throws Exception {
                        InternalParentTree.this.showCreationTrace(clicked, clicked.getAllocationTracepoint());
                    }
                });
                td.setTitle("Open the location where the component was created");
                td.add(new Img("THEME/iptLocation.png"));
            }
            td = b.addCell();
            td.setCellWidth("97%");
            td.add(nn);
            if (!nb.hasParent()) break;
        }
    }

    protected void showCreationTrace(NodeBase clicked, StackTraceElement[] allocationTracepoint) {
        this.m_structure.removeAllChildren();
        Div alt = new Div();
        this.m_structure.add(alt);
        LinkButton lb = new LinkButton("Back to structure", "THEME/btnBack.png", (IClicked<? extends NodeBase>)new IClicked<LinkButton>(){

            @Override
            public void clicked(@Nonnull LinkButton clickednode) throws Exception {
                InternalParentTree.this.m_structure.removeAllChildren();
                InternalParentTree.this.renderStructure(InternalParentTree.this.m_structure);
            }
        });
        alt.add(lb);
        Div stk = new Div();
        this.m_structure.add(stk);
        boolean first = true;
        boolean gotctor = false;
        TBody b = stk.addTable(new String[0]);
        for (StackTraceElement ste : allocationTracepoint) {
            String nn = ste.getClassName();
            if (nn.startsWith("org.apache.tomcat.")) {
                return;
            }
            if (first) {
                if (ste.getMethodName().equals("<init>")) {
                    gotctor = true;
                }
                if (nn.equals(DomUtil.class.getName()) || nn.equals(NodeBase.class.getName()) || nn.equals(NodeContainer.class.getName())) continue;
                first = false;
                if (!gotctor || ste.getMethodName().equals("<init>")) continue;
            }
            first = false;
            TR row = b.addRow();
            row.setCssClass("ui-ipt-item");
            TD td = b.addCell();
            td.setCellWidth("1%");
            String icon = "";
            icon = nn.startsWith("to.etc.domui.dom.") ? "iptHtml.png" : (nn.startsWith("to.etc.domui.") ? "iptComponent.png" : "iptPage.png");
            td.add(new Img("THEME/" + icon));
            td = b.addCell();
            td.setCssClass("ui-ipt-btn");
            td.setCellWidth("1%");
            final StackTraceElement cste = ste;
            td.setClicked(new IClicked<NodeBase>(){

                @Override
                public void clicked(@Nonnull NodeBase clickednode) throws Exception {
                    InternalParentTree.this.openSource(cste);
                }
            });
            td.setTitle("Open the source code at this location");
            td.add(new Img("THEME/iptSourceCode.png"));
            td = b.addCell();
            td.setCellWidth("97%");
            td.add(ste.getClassName() + "#" + ste.getMethodName() + " (" + ste.getLineNumber() + ")");
        }
    }

    @Nonnull
    private String openableClassName(@Nonnull String str) {
        return str.replace('.', '/').replaceAll("\\$.*", "");
    }

    protected void openSource(NodeBase clicked) {
        UrlPage body = this.getPage().getBody();
        this.remove();
        String name = this.openableClassName(clicked.getClass().getName()) + ".java";
        this.openSourceWithWarning(body, name);
    }

    private void openSourceWithWarning(@Nonnull NodeBase body, @Nonnull String name) {
        CommandResponse cr = InternalParentTree.openEclipseSource(name);
        if (cr.getType() == AnswerType.SUCCESS) {
            return;
        }
        String message = InternalParentTree.getResponseMessage(cr);
        MsgBox.message(body, MsgBox.Type.ERROR, message);
    }

    @Nonnull
    public static String getResponseMessage(@Nonnull CommandResponse cr) {
        switch (cr.getType()) {
            default: {
                throw new IllegalStateException("Missing case: " + (Object)((Object)cr.getType()));
            }
            case ERROR: {
                return "Eclipse responded with an error to the 'open file' command: " + cr.getMessage() + PMS;
            }
            case NOCONNECTION: {
                if (InternalParentTree.isOldPortInUse()) {
                    return "It looks like you are using an old version of the DomUI Plugin. Please update using Help -> Check for updates in Eclipse";
                }
                return "It looks like you do not have the DomUI Eclipse plugin installed. Please see http://www.domui.org/wiki/bin/view/Documentation/EclipsePlugin for installation details";
            }
            case SUCCESS: {
                return "";
            }
            case REFUSED: 
        }
        if (InternalParentTree.isOldPortInUse()) {
            return "None of your running Eclipse instances wanted to open the page. It looks like you have at least one Eclipse installation that uses the old version of the plugin, which is not compatible. Please update the DomUI plugin to the latest version using Help -> Check for updates in all your running Eclipses";
        }
        return "An unexpected error has occurred: none of the running Eclipse installations recognized this web application. Please report this as a bug.";
    }

    protected void openSource(StackTraceElement ste) {
        UrlPage body = this.getPage().getBody();
        this.remove();
        String name = this.openableClassName(ste.getClassName()) + ".java";
        name = ste.getLineNumber() <= 0 ? name + "@" + ste.getMethodName() : name + "#" + ste.getLineNumber();
        this.openSourceWithWarning(body, name);
    }

    @Nonnull
    public static CommandResponse openEclipseSource(@Nonnull String name) {
        File root = DomApplication.get().getAppFile("");
        return InternalParentTree.openEclipseSource(root.toString(), name);
    }

    @Nonnull
    public static CommandResponse openEclipseSource(@Nonnull String webappRoot, @Nonnull String name) {
        int nconnects = 0;
        block6: for (int port = 5051; port < 5060; ++port) {
            CommandResponse cr = InternalParentTree.tryPortCommand(port, webappRoot, name);
            switch (cr.getType()) {
                case NOCONNECTION: {
                    continue block6;
                }
                case SUCCESS: {
                    return cr;
                }
                case ERROR: {
                    return cr;
                }
                case REFUSED: {
                    ++nconnects;
                }
            }
        }
        System.out.println("DomUI: cannot connect to Eclipse on localhost ports 5051..5060. See http://www.domui.org/wiki/bin/view/Documentation/EclipsePlugin");
        if (nconnects > 0) {
            return new CommandResponse(AnswerType.REFUSED, null);
        }
        return new CommandResponse(AnswerType.NOCONNECTION, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isOldPortInUse() {
        Socket s = null;
        try {
            s = new Socket("127.0.0.1", 5050);
            boolean bl = true;
            return bl;
        }
        catch (Exception x) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (null != s) {
                    s.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Nonnull
    private static CommandResponse tryPortCommand(int port, @Nonnull String webappRoot, @Nonnull String name) {
        String rest;
        InputStream is;
        OutputStream outputStream;
        Socket s;
        block33: {
            String code;
            block32: {
                block31: {
                    int szrd;
                    s = null;
                    try {
                        s = new Socket("127.0.0.1", port);
                    }
                    catch (Exception x) {
                        System.out.println("DomUI: connect to Eclipse on socket " + port + " failed: " + x);
                        return new CommandResponse(AnswerType.NOCONNECTION, null);
                    }
                    outputStream = null;
                    is = null;
                    outputStream = s.getOutputStream();
                    StringBuilder sb = new StringBuilder();
                    sb.append("SELECT `");
                    sb.append(webappRoot);
                    sb.append("` OPENFILE `");
                    sb.append(name);
                    sb.append('`');
                    outputStream.write(sb.toString().getBytes("UTF-8"));
                    outputStream.write(0);
                    outputStream.flush();
                    is = s.getInputStream();
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    byte[] buffer = new byte[512];
                    while (0 < (szrd = is.read(buffer))) {
                        baos.write(buffer, 0, szrd);
                    }
                    baos.close();
                    String response = new String(baos.toByteArray(), "utf-8");
                    System.out.println("DomUI Eclipse: response=" + response);
                    while (response.length() > 0 && response.charAt(response.length() - 1) == '\n') {
                        response = response.substring(0, response.length() - 1);
                    }
                    int pos = response.indexOf(32);
                    if (pos == -1) {
                        code = response;
                        rest = "";
                    } else {
                        code = response.substring(0, pos).trim();
                        rest = response.substring(pos + 1).trim();
                    }
                    if (!"SELECT-FAILED".equals(code)) break block31;
                    CommandResponse commandResponse = new CommandResponse(AnswerType.REFUSED, rest);
                    FileTool.closeAll((Object[])new Object[]{outputStream, is});
                    try {
                        if (s != null) {
                            s.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return commandResponse;
                }
                if (!"OK".equals(code)) break block32;
                CommandResponse commandResponse = new CommandResponse(AnswerType.SUCCESS, rest);
                FileTool.closeAll((Object[])new Object[]{outputStream, is});
                try {
                    if (s != null) {
                        s.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return commandResponse;
            }
            if (!"ERROR".equals(code)) break block33;
            CommandResponse commandResponse = new CommandResponse(AnswerType.ERROR, rest);
            FileTool.closeAll((Object[])new Object[]{outputStream, is});
            try {
                if (s != null) {
                    s.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return commandResponse;
        }
        CommandResponse commandResponse = new CommandResponse(AnswerType.REFUSED, rest);
        FileTool.closeAll((Object[])new Object[]{outputStream, is});
        try {
            if (s != null) {
                s.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return commandResponse;
        catch (Exception x) {
            CommandResponse commandResponse2;
            try {
                System.out.println("DomUI: eclipse data exchange failed with " + x);
                x.printStackTrace();
                commandResponse2 = new CommandResponse(AnswerType.REFUSED, x.toString());
            }
            catch (Throwable throwable) {
                FileTool.closeAll((Object[])new Object[]{outputStream, is});
                try {
                    if (s != null) {
                        s.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            FileTool.closeAll((Object[])new Object[]{outputStream, is});
            try {
                if (s != null) {
                    s.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return commandResponse2;
        }
    }

    public static class CommandResponse {
        @Nonnull
        private final AnswerType m_type;
        @Nullable
        private final String m_message;

        public CommandResponse(@Nonnull AnswerType type, @Nullable String message) {
            this.m_type = type;
            this.m_message = message;
        }

        @Nullable
        public String getMessage() {
            String message = this.m_message;
            if (null == message) {
                throw new IllegalStateException("Message not defined");
            }
            return message;
        }

        @Nonnull
        public AnswerType getType() {
            return this.m_type;
        }
    }

    public static enum AnswerType {
        NOCONNECTION,
        REFUSED,
        ERROR,
        SUCCESS;

    }
}

