/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.misc;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import to.etc.domui.component.misc.Flare;
import to.etc.domui.dom.errors.MsgType;
import to.etc.domui.dom.errors.UIMessage;
import to.etc.domui.dom.html.Div;
import to.etc.domui.dom.html.Img;
import to.etc.domui.dom.html.ImgAlign;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.dom.html.NodeContainer;

public class MessageFlare
extends Flare {
    private List<NodeBase> m_content = new ArrayList<NodeBase>();
    private MsgType m_type;

    public MessageFlare() {
        this(MsgType.ERROR);
    }

    public MessageFlare(MsgType type) {
        this(type, false);
    }

    public MessageFlare(MsgType type, boolean autoVanish) {
        this.m_type = type;
        this.setAutoVanish(autoVanish);
    }

    private void renderType() {
        switch (this.m_type) {
            case ERROR: {
                this.setCssClass("ui-flare ui-flare-msg ui-flare-error");
                break;
            }
            case INFO: {
                this.setCssClass("ui-flare ui-flare-msg ui-flare-info");
                break;
            }
            case WARNING: {
                this.setCssClass("ui-flare ui-flare-msg ui-flare-warning");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown msg type:" + (Object)((Object)this.m_type));
            }
        }
        Img img = null;
        switch (this.m_type) {
            case ERROR: {
                img = new Img("THEME/mbx-error.png");
                break;
            }
            case INFO: {
                img = new Img("THEME/mbx-info.png");
                break;
            }
            case WARNING: {
                img = new Img("THEME/mbx-warning.png");
                break;
            }
            default: {
                throw new IllegalStateException("Unknown msg type:" + (Object)((Object)this.m_type));
            }
        }
        img.setAlign(ImgAlign.LEFT);
        this.add(img);
    }

    @Override
    public void createContent() throws Exception {
        super.createContent();
        this.renderType();
        Div msgContent = new Div();
        this.add(msgContent);
        for (NodeBase nb : this.m_content) {
            msgContent.add(nb);
        }
    }

    public void addMessage(String message) {
        Div dmsg = new Div();
        this.m_content.add(dmsg);
        dmsg.add(message);
    }

    public void addMessage(@Nonnull String message, @Nonnull MsgType type) {
        this.addMessage(message);
        if (this.m_type == null || type.getOrder() > this.m_type.getOrder()) {
            this.setType(type);
        }
    }

    public void addMessage(UIMessage uim) {
        this.addMessage(uim.getMessage(), uim.getType());
    }

    public void setType(MsgType type) {
        if (this.m_type != type) {
            this.m_type = type;
            if (this.isBuilt()) {
                this.forceRebuild();
            }
        }
    }

    public static MessageFlare display(NodeContainer parent, String message) {
        MessageFlare mf = MessageFlare.get(parent, MessageFlare.class);
        mf.addMessage(message);
        return mf;
    }

    public static MessageFlare display(NodeContainer parent, MsgType type, String message) {
        MessageFlare mf = MessageFlare.get(parent, MessageFlare.class);
        mf.setType(type);
        mf.addMessage(message);
        return mf;
    }

    public static MessageFlare display(NodeContainer parent, UIMessage message) {
        return MessageFlare.display(parent, message.getType(), message.getMessage());
    }
}

