/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.misc;

import javax.annotation.Nonnull;
import to.etc.domui.component.buttons.DefaultButton;
import to.etc.domui.component.buttons.LinkButton;
import to.etc.domui.component.input.Text;
import to.etc.domui.component.layout.IWindowClosed;
import to.etc.domui.component.layout.Window;
import to.etc.domui.component.meta.MetaManager;
import to.etc.domui.component.misc.MsgBoxButton;
import to.etc.domui.dom.css.Overflow;
import to.etc.domui.dom.css.VerticalAlignType;
import to.etc.domui.dom.errors.MsgType;
import to.etc.domui.dom.errors.UIMessage;
import to.etc.domui.dom.html.Button;
import to.etc.domui.dom.html.Div;
import to.etc.domui.dom.html.IClicked;
import to.etc.domui.dom.html.IControl;
import to.etc.domui.dom.html.Img;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.dom.html.NodeContainer;
import to.etc.domui.dom.html.TBody;
import to.etc.domui.dom.html.TD;
import to.etc.domui.dom.html.TR;
import to.etc.domui.dom.html.Table;
import to.etc.domui.dom.html.UrlPage;
import to.etc.domui.trouble.UIMsgException;
import to.etc.domui.trouble.ValidationException;
import to.etc.domui.util.DomUtil;
import to.etc.domui.util.INodeContentRenderer;
import to.etc.domui.util.Msgs;
import to.etc.domui.util.bugs.Bug;

public class MsgBox
extends Window {
    private Img m_theImage = new Img();
    private String m_theText;
    private Div m_theButtons = new Div();
    private static final int WIDTH = 500;
    private static final int HEIGHT = 210;
    private Object m_selectedChoice;
    private IAnswer m_onAnswer;
    private IAnswer2 m_onAnswer2;
    private MsgBoxButton m_closeButtonObject;
    private IInput<?> m_oninput;
    private IControl<?> m_inputControl;
    private INodeContentRenderer<String> m_dataRenderer;
    private NodeContainer m_content;

    protected MsgBox() {
        super(true, false, 500, -1, "");
        this.setErrorFence(null);
        this.m_theButtons.addCssClass("ui-bb-middle");
        this.setOnClose(new IWindowClosed(){

            @Override
            public void closed(@Nonnull String closeReason) throws Exception {
                if (null != MsgBox.this.m_onAnswer) {
                    MsgBox.this.m_selectedChoice = (Object)MsgBox.this.m_closeButtonObject;
                    try {
                        MsgBox.this.m_onAnswer.onAnswer(MsgBox.this.m_closeButtonObject);
                    }
                    catch (ValidationException ex) {
                        MsgBox.this.close();
                        throw ex;
                    }
                }
                if (null != MsgBox.this.m_onAnswer2) {
                    MsgBox.this.m_selectedChoice = (Object)MsgBox.this.m_closeButtonObject;
                    try {
                        MsgBox.this.m_onAnswer2.onAnswer((Object)MsgBox.this.m_closeButtonObject);
                    }
                    catch (ValidationException ex) {
                        MsgBox.this.close();
                        throw ex;
                    }
                }
            }
        });
    }

    public static MsgBox create(NodeBase parent) {
        MsgBox w = new MsgBox();
        UrlPage body = parent.getPage().getBody();
        body.undelegatedAdd(0, w);
        return w;
    }

    protected void setType(Type type) {
        String icon;
        String ttl;
        switch (type) {
            default: {
                throw new IllegalStateException((Object)((Object)type) + " ??");
            }
            case ERROR: {
                ttl = Msgs.BUNDLE.getString("ui.mbx.error");
                icon = "THEME/mbx-error.png";
                break;
            }
            case WARNING: {
                ttl = Msgs.BUNDLE.getString("ui.mbx.warning");
                icon = "THEME/mbx-warning.png";
                break;
            }
            case INFO: {
                ttl = Msgs.BUNDLE.getString("ui.mbx.info");
                icon = "THEME/mbx-info.png";
                break;
            }
            case DIALOG: {
                ttl = Msgs.BUNDLE.getString("ui.mbx.dialog");
                icon = "THEME/mbx-question.png";
                break;
            }
            case INPUT: {
                ttl = Msgs.BUNDLE.getString("ui.mbx.input");
                icon = "THEME/mbx-question.png";
            }
        }
        this.m_theImage.setSrc(icon);
        this.setWindowTitle(ttl);
        this.setTestID("msgBox");
    }

    protected void setMessage(String txt) {
        this.m_theText = txt;
    }

    private void setCloseButton(MsgBoxButton val) {
        this.m_closeButtonObject = val;
    }

    MsgBoxButton getCloseObject() {
        return this.m_closeButtonObject;
    }

    public static void message(NodeBase dad, Type mt, String string) {
        if (mt == Type.DIALOG) {
            throw new IllegalArgumentException("Please use one of the predefined button calls for MsgType.DIALOG type MsgBox!");
        }
        MsgBox box = MsgBox.create(dad);
        box.setType(mt);
        box.setMessage(string);
        box.addButton(MsgBoxButton.CONTINUE);
        box.setCloseButton(MsgBoxButton.CONTINUE);
        box.construct();
    }

    public static void message(NodeBase dad, Type mt, NodeContainer content) {
        if (mt == Type.DIALOG) {
            throw new IllegalArgumentException("Please use one of the predefined button calls for MsgType.DIALOG type MsgBox!");
        }
        MsgBox box = MsgBox.create(dad);
        box.setType(mt);
        box.setContent(content);
        box.addButton(MsgBoxButton.CONTINUE);
        box.setCloseButton(MsgBoxButton.CONTINUE);
        box.construct();
    }

    private void setContent(@Nonnull NodeContainer content) {
        this.m_content = content;
    }

    public static void message(NodeBase dad, String iconSrc, String string) {
        MsgBox.message(dad, iconSrc, string, null);
    }

    public static void message(NodeBase dad, String iconSrc, String string, IAnswer onAnswer) {
        MsgBox box = MsgBox.create(dad);
        box.setType(Type.INFO);
        box.m_theImage.setSrc(iconSrc);
        box.setMessage(string);
        box.addButton(MsgBoxButton.CONTINUE);
        box.setCloseButton(MsgBoxButton.CONTINUE);
        box.setOnAnswer(onAnswer);
        box.construct();
    }

    public static void message(NodeBase dad, String iconSrc, String title, IAnswer onAnswer, INodeContentRenderer<String> msgRenderer) {
        MsgBox box = MsgBox.create(dad);
        box.setType(Type.INFO);
        box.m_theImage.setSrc(iconSrc);
        box.setWindowTitle(title);
        box.addButton(MsgBoxButton.CONTINUE);
        if (onAnswer != null) {
            box.addButton(MsgBoxButton.CANCEL);
            box.setCloseButton(MsgBoxButton.CANCEL);
        } else {
            box.setCloseButton(MsgBoxButton.CONTINUE);
        }
        box.setOnAnswer(onAnswer);
        box.setDataRenderer(msgRenderer);
        box.construct();
    }

    public static void info(NodeBase dad, String string) {
        MsgBox.message(dad, Type.INFO, string);
    }

    public static void warning(NodeBase dad, String string) {
        MsgBox.message(dad, Type.WARNING, string);
    }

    public static void error(NodeBase dad, String string) {
        MsgBox.message(dad, Type.ERROR, string);
    }

    public static void info(NodeBase dad, NodeContainer string) {
        MsgBox.message(dad, Type.INFO, string);
    }

    public static void warning(NodeBase dad, NodeContainer string) {
        MsgBox.message(dad, Type.WARNING, string);
    }

    public static void error(NodeBase dad, NodeContainer string) {
        MsgBox.message(dad, Type.ERROR, string);
    }

    public static void message(NodeBase dad, Type mt, String string, IAnswer onAnswer) {
        if (mt == Type.DIALOG) {
            throw new IllegalArgumentException("Please use one of the predefined button calls for MsgType.DIALOG type MsgBox!");
        }
        MsgBox box = MsgBox.create(dad);
        box.setType(mt);
        box.setMessage(string);
        box.addButton(MsgBoxButton.CONTINUE);
        box.setCloseButton(MsgBoxButton.CONTINUE);
        box.setOnAnswer(onAnswer);
        box.construct();
    }

    public static void dialog(NodeBase dad, String title, IAnswer onAnswer, INodeContentRenderer<String> contentRenderer) {
        MsgBox box = MsgBox.create(dad);
        box.setType(Type.DIALOG);
        box.setWindowTitle(title);
        box.addButton(MsgBoxButton.CANCEL);
        box.setCloseButton(MsgBoxButton.CANCEL);
        box.setOnAnswer(onAnswer);
        box.setDataRenderer(contentRenderer);
        box.construct();
    }

    public static void yesNoCancel(NodeBase dad, String string, IAnswer onAnswer) {
        MsgBox box = MsgBox.create(dad);
        box.setType(Type.DIALOG);
        box.setMessage(string);
        box.addButton(MsgBoxButton.YES);
        box.addButton(MsgBoxButton.NO);
        box.addButton(MsgBoxButton.CANCEL);
        box.setCloseButton(MsgBoxButton.CANCEL);
        box.setOnAnswer(onAnswer);
        box.construct();
    }

    public static void yesNo(NodeBase dad, String string, IAnswer onAnswer) {
        MsgBox.yesNo(dad, string, onAnswer, null);
    }

    public static void yesNo(NodeBase dad, String string, IAnswer onAnswer, INodeContentRenderer<String> msgRenderer) {
        MsgBox box = MsgBox.create(dad);
        box.setType(Type.DIALOG);
        box.setMessage(string);
        box.addButton(MsgBoxButton.YES);
        box.addButton(MsgBoxButton.NO);
        box.setCloseButton(MsgBoxButton.NO);
        box.setOnAnswer(onAnswer);
        box.setDataRenderer(msgRenderer);
        box.construct();
    }

    public static void yesNo(NodeBase dad, String string, IClicked<MsgBox> onAnswer) {
        MsgBox.yesNo(dad, Type.DIALOG, string, onAnswer);
    }

    public static void yesNo(NodeBase dad, Type msgtype, String string, final IClicked<MsgBox> onAnswer) {
        final MsgBox box = MsgBox.create(dad);
        box.setType(msgtype);
        box.setMessage(string);
        box.addButton(MsgBoxButton.YES);
        box.addButton(MsgBoxButton.NO);
        box.setCloseButton(MsgBoxButton.NO);
        box.setOnAnswer(new IAnswer(){

            @Override
            public void onAnswer(MsgBoxButton result) throws Exception {
                if (result == MsgBoxButton.YES) {
                    onAnswer.clicked(box);
                }
            }
        });
        box.construct();
    }

    public static void okMore(NodeBase dad, Type type, String string, IAnswer onAnswer) {
        MsgBox box = MsgBox.create(dad);
        box.setType(type);
        box.setMessage(string);
        box.addButton(MsgBoxButton.OK);
        box.addButton(MsgBoxButton.MORE);
        box.setCloseButton(MsgBoxButton.OK);
        box.setOnAnswer(onAnswer);
        box.construct();
    }

    public static void continueCancel(NodeBase dad, String string, IAnswer onAnswer) {
        MsgBox box = MsgBox.create(dad);
        box.setType(Type.DIALOG);
        box.setMessage(string);
        box.addButton(MsgBoxButton.CONTINUE);
        box.addButton(MsgBoxButton.CANCEL);
        box.setCloseButton(MsgBoxButton.CANCEL);
        box.setOnAnswer(onAnswer);
        box.construct();
    }

    public static <T> void inputString(NodeBase dad, String message, Text<T> input, IInput<T> onanswer) {
        MsgBox box = MsgBox.create(dad);
        box.setType(Type.INPUT);
        box.setMessage(message);
        box.addButton(MsgBoxButton.CONTINUE);
        box.addButton(MsgBoxButton.CANCEL);
        box.setCloseButton(MsgBoxButton.CANCEL);
        box.setOninput(onanswer);
        box.setInputControl(input);
        box.construct();
    }

    public static <T, C extends IControl<T>> void input(NodeBase dad, String prompt, C input, IInput<T> onanswer) {
        MsgBox box = MsgBox.create(dad);
        box.setType(Type.INPUT);
        box.setMessage(prompt);
        box.addButton(MsgBoxButton.CONTINUE);
        box.addButton(MsgBoxButton.CANCEL);
        box.setCloseButton(MsgBoxButton.CANCEL);
        box.setOninput(onanswer);
        box.setInputControl(input);
        box.construct();
    }

    public static void continueCancel(NodeBase dad, String string, final IClicked<MsgBox> onAnswer) {
        final MsgBox box = MsgBox.create(dad);
        box.setType(Type.DIALOG);
        box.setMessage(string);
        box.addButton(MsgBoxButton.CONTINUE);
        box.addButton(MsgBoxButton.CANCEL);
        box.setCloseButton(MsgBoxButton.CANCEL);
        box.setOnAnswer(new IAnswer(){

            @Override
            public void onAnswer(MsgBoxButton result) throws Exception {
                if (result == MsgBoxButton.CONTINUE) {
                    onAnswer.clicked(box);
                }
            }
        });
        box.construct();
    }

    public static void flexDialog(@Nonnull NodeBase dad, @Nonnull Type boxType, @Nonnull String message, @Nonnull IAnswer2 onAnswer, Object ... buttonresultpairs) {
        MsgBox box = MsgBox.create(dad);
        box.setType(boxType);
        box.setMessage(message);
        int ix = 0;
        while (ix < buttonresultpairs.length) {
            Object o;
            if ((o = buttonresultpairs[ix++]) instanceof MsgBoxButton) {
                MsgBoxButton b = (MsgBoxButton)((Object)o);
                box.addButton(b);
                continue;
            }
            if (o instanceof String) {
                String s = (String)o;
                if (ix >= buttonresultpairs.length) {
                    throw new IllegalArgumentException("Illegal format: must be [button name string], [response object].");
                }
                box.addButton(s, buttonresultpairs[ix++]);
                continue;
            }
            throw new IllegalArgumentException("Unsupported 'button' type in list: " + o + ", only supporting String:Object and MsgBoxButton");
        }
        box.setCloseButton(MsgBoxButton.NO);
        box.setOnAnswer2(onAnswer);
        box.construct();
    }

    @Nonnull
    public static DefaultButton areYouSureButton(String text, String icon, final String message, final IClicked<DefaultButton> ch) {
        final DefaultButton btn = new DefaultButton(text, icon);
        IClicked<DefaultButton> bch = new IClicked<DefaultButton>(){

            @Override
            public void clicked(@Nonnull DefaultButton b) throws Exception {
                MsgBox.yesNo((NodeBase)b, message, new IClicked<MsgBox>(){

                    @Override
                    public void clicked(@Nonnull MsgBox bx) throws Exception {
                        ch.clicked(btn);
                    }
                });
            }
        };
        btn.setClicked(bch);
        return btn;
    }

    @Nonnull
    public static DefaultButton areYouSureButton(String text, String message, IClicked<DefaultButton> ch) {
        return MsgBox.areYouSureButton(text, null, message, ch);
    }

    @Nonnull
    public static LinkButton areYouSureLinkButton(String text, String icon, final String message, final IClicked<LinkButton> ch) {
        final LinkButton btn = new LinkButton(text, icon);
        IClicked<LinkButton> bch = new IClicked<LinkButton>(){

            @Override
            public void clicked(@Nonnull LinkButton b) throws Exception {
                MsgBox.yesNo((NodeBase)b, message, new IClicked<MsgBox>(){

                    @Override
                    public void clicked(@Nonnull MsgBox bx) throws Exception {
                        ch.clicked(btn);
                    }
                });
            }
        };
        btn.setClicked(bch);
        return btn;
    }

    @Nonnull
    public static LinkButton areYouSureLinkButton(String text, String message, IClicked<LinkButton> ch) {
        return MsgBox.areYouSureLinkButton(text, null, message, ch);
    }

    private void construct() {
        Div a = new Div();
        this.add(a);
        a.setCssClass("ui-mbx-top");
        a.setStretchHeight(true);
        a.setOverflow(Overflow.AUTO);
        Table t = new Table();
        a.add(t);
        TBody b = t.getBody();
        TR row = b.addRow();
        row.setVerticalAlign(VerticalAlignType.TOP);
        TD td = row.addCell();
        td.setVerticalAlign(VerticalAlignType.TOP);
        td.add(this.m_theImage);
        td.setNowrap(true);
        td.setWidth("50px");
        td = row.addCell("ui-mbx-mc");
        NodeContainer content = this.m_content;
        if (this.getDataRenderer() != null) {
            try {
                this.getDataRenderer().renderNodeContent(this, td, this.m_theText, null);
            }
            catch (Exception ex) {
                Bug.bug(ex);
            }
        } else if (content != null) {
            td.add(content);
        } else {
            DomUtil.renderHtmlString(td, this.m_theText);
        }
        if (this.m_inputControl != null) {
            this.setErrorFence();
            NodeBase ic = (NodeBase)((Object)this.m_inputControl);
            td = b.addRowAndCell();
            td.setCssClass("ui-mbx-input-1");
            td = b.addCell();
            td.setCssClass("ui-mbx-input");
            td.add(ic);
            ic.setFocus();
        }
        this.add(this.m_theButtons);
        if (this.m_inputControl == null) {
            this.setFocusOnButton();
        }
    }

    private void setFocusOnButton() {
        if (this.m_theButtons.getChildCount() > 0 && this.m_theButtons.getChild(0) instanceof Button) {
            ((Button)this.m_theButtons.getChild(0)).setFocus();
        }
    }

    @Override
    public void setDimensions(int width, int height) {
        super.setDimensions(width, height);
    }

    void setSelectedChoice(Object selectedChoice) {
        this.m_selectedChoice = selectedChoice;
    }

    protected void answer(Object sel) throws Exception {
        this.m_selectedChoice = sel;
        if (this.m_onAnswer != null) {
            try {
                this.m_onAnswer.onAnswer((MsgBoxButton)((Object)this.m_selectedChoice));
            }
            catch (ValidationException ex) {
                this.close();
                throw ex;
            }
        }
        if (this.m_onAnswer2 != null) {
            try {
                this.m_onAnswer2.onAnswer(this.m_selectedChoice);
            }
            catch (ValidationException ex) {
                this.close();
                throw ex;
            }
        }
        if (this.m_oninput != null && sel == MsgBoxButton.CONTINUE) {
            Object v = this.m_inputControl.getValue();
            this.m_oninput.onInput(v);
        }
        this.close();
    }

    protected void addButton(final MsgBoxButton mbb) {
        if (mbb == null) {
            throw new NullPointerException("A message button cannot be null, dufus");
        }
        String lbl = MetaManager.findEnumLabel(mbb);
        if (lbl == null) {
            lbl = mbb.name();
        }
        String icon = null;
        if (mbb == MsgBoxButton.YES || mbb == MsgBoxButton.CONTINUE) {
            icon = "THEME/btnConfirm.png";
        } else if (mbb == MsgBoxButton.NO) {
            icon = "THEME/btnCancel.png";
        } else if (mbb == MsgBoxButton.CANCEL) {
            icon = "THEME/btnCancel.png";
        }
        DefaultButton btn = new DefaultButton(lbl, icon, new IClicked<DefaultButton>(){

            @Override
            public void clicked(@Nonnull DefaultButton b) throws Exception {
                MsgBox.this.answer((Object)mbb);
            }
        });
        btn.setTestID(mbb.name());
        this.m_theButtons.add(btn);
    }

    protected void addButton(String lbl, final Object selval) {
        this.m_theButtons.add(new DefaultButton(lbl, new IClicked<DefaultButton>(){

            @Override
            public void clicked(@Nonnull DefaultButton b) throws Exception {
                MsgBox.this.answer(selval);
            }
        }));
    }

    protected IAnswer getOnAnswer() {
        return this.m_onAnswer;
    }

    protected void setOnAnswer(IAnswer onAnswer) {
        this.m_onAnswer = onAnswer;
    }

    public IAnswer2 getOnAnswer2() {
        return this.m_onAnswer2;
    }

    public void setOnAnswer2(IAnswer2 onAnswer2) {
        this.m_onAnswer2 = onAnswer2;
    }

    public IInput<?> getOninput() {
        return this.m_oninput;
    }

    public void setOninput(IInput<?> oninput) {
        this.m_oninput = oninput;
    }

    public IControl<?> getInputControl() {
        return this.m_inputControl;
    }

    public void setInputControl(IControl<?> inputControl) {
        this.m_inputControl = inputControl;
    }

    protected INodeContentRenderer<String> getDataRenderer() {
        return this.m_dataRenderer;
    }

    protected void setDataRenderer(INodeContentRenderer<String> dataRenderer) {
        this.m_dataRenderer = dataRenderer;
    }

    public static void message(@Nonnull NodeBase dad, @Nonnull UIMessage msg) {
        MsgBox.message(dad, msg.getType(), msg.getMessage());
    }

    public static void message(@Nonnull NodeBase dad, @Nonnull UIMsgException msgEx) {
        MsgBox.message(dad, msgEx.getType(), msgEx.getMessage());
    }

    private static void message(@Nonnull NodeBase dad, @Nonnull MsgType type, @Nonnull String msg) {
        MsgBox box = MsgBox.create(dad);
        switch (type) {
            case INFO: {
                box.setType(Type.INFO);
                break;
            }
            case ERROR: {
                box.setType(Type.ERROR);
                break;
            }
            case WARNING: {
                box.setType(Type.WARNING);
            }
        }
        box.setMessage(msg);
        box.addButton(MsgBoxButton.CONTINUE);
        box.setCloseButton(MsgBoxButton.CONTINUE);
        box.construct();
    }

    public static enum Type {
        INFO,
        WARNING,
        ERROR,
        DIALOG,
        INPUT;


        @Nonnull
        public static Type from(@Nonnull MsgType messageType) {
            switch (messageType) {
                default: {
                    return INFO;
                }
                case ERROR: {
                    return ERROR;
                }
                case WARNING: 
            }
            return WARNING;
        }
    }

    public static interface IInput<T> {
        public void onInput(T var1) throws Exception;
    }

    public static interface IAnswer2 {
        public void onAnswer(Object var1) throws Exception;
    }

    public static interface IAnswer {
        public void onAnswer(@Nonnull MsgBoxButton var1) throws Exception;
    }
}

