/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.misc;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.buttons.DefaultButton;
import to.etc.domui.component.layout.IWindowClosed;
import to.etc.domui.component.layout.Window;
import to.etc.domui.component.meta.MetaManager;
import to.etc.domui.component.misc.MsgBoxButton;
import to.etc.domui.dom.css.Overflow;
import to.etc.domui.dom.css.VerticalAlignType;
import to.etc.domui.dom.html.Button;
import to.etc.domui.dom.html.Div;
import to.etc.domui.dom.html.IClicked;
import to.etc.domui.dom.html.IControl;
import to.etc.domui.dom.html.Img;
import to.etc.domui.dom.html.Label;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.dom.html.NodeContainer;
import to.etc.domui.dom.html.TBody;
import to.etc.domui.dom.html.TD;
import to.etc.domui.dom.html.TR;
import to.etc.domui.dom.html.Table;
import to.etc.domui.dom.html.UrlPage;
import to.etc.domui.trouble.ValidationException;
import to.etc.domui.util.DomUtil;
import to.etc.domui.util.INodeContentRenderer;
import to.etc.domui.util.Msgs;
import to.etc.domui.util.bugs.Bug;

public final class MsgBox2
extends Window {
    private IClicked<MsgBox2> m_clicked;
    private MsgBoxButton m_clickedButton;
    private Boolean m_autoClose;
    private Img m_theImage = new Img();
    private boolean m_typeSet;
    private String m_theText;
    private Div m_buttonDiv = new Div();
    private List<Button> m_theButtons = new ArrayList<Button>();
    private static final int WIDTH = 500;
    private static final int HEIGHT = 210;
    private Object m_selectedChoice;
    private IAnswer m_onAnswer;
    private IAnswer2 m_onAnswer2;
    private MsgBoxButton m_closeButtonObject;
    private IInput<?> m_oninput;
    private INodeContentRenderer<String> m_dataRenderer;
    private NodeContainer m_content;
    private MsgBoxButton m_assumedOkButton;
    private MsgBoxButton m_assumedCancelButton = MsgBoxButton.CANCEL;
    @Nonnull
    private List<InputPair> m_inputList = new ArrayList<InputPair>();

    private MsgBox2() {
        super(true, false, 500, -1, "");
        this.setErrorFence(null);
        this.setOnClose(new IWindowClosed(){

            @Override
            public void closed(@Nonnull String closeReason) throws Exception {
                if (null != MsgBox2.this.m_onAnswer) {
                    MsgBox2.this.m_selectedChoice = (Object)MsgBox2.this.m_closeButtonObject;
                    try {
                        MsgBox2.this.m_onAnswer.onAnswer(MsgBox2.this.m_closeButtonObject);
                    }
                    catch (ValidationException ex) {
                        MsgBox2.this.close();
                        throw ex;
                    }
                }
                if (null != MsgBox2.this.m_onAnswer2) {
                    MsgBox2.this.m_selectedChoice = (Object)MsgBox2.this.m_closeButtonObject;
                    try {
                        MsgBox2.this.m_onAnswer2.onAnswer((Object)MsgBox2.this.m_closeButtonObject);
                    }
                    catch (ValidationException ex) {
                        MsgBox2.this.close();
                        throw ex;
                    }
                }
            }
        });
    }

    @Override
    public void createContent() throws Exception {
        Boolean autoClose = this.m_autoClose;
        if (null == autoClose) {
            autoClose = this.m_inputList.size() == 0;
        }
        this.setAutoClose(autoClose);
        if (this.m_theButtons.size() == 0) {
            this.button(MsgBoxButton.CONTINUE);
            if (this.m_inputList.size() > 0) {
                this.button(MsgBoxButton.CANCEL);
            }
        }
        if (this.m_closeButtonObject == null) {
            this.m_closeButtonObject = this.m_assumedCancelButton;
        }
        if (!this.m_typeSet) {
            if (this.m_inputList.size() > 0) {
                this.type(Type.DIALOG);
            } else if (this.m_theButtons.size() < 2) {
                this.type(Type.INFO);
            } else {
                this.type(Type.DIALOG);
            }
        }
        Div a = new Div();
        this.add(a);
        a.setCssClass("ui-mbx-top");
        a.setStretchHeight(true);
        a.setOverflow(Overflow.AUTO);
        Table t = new Table();
        a.add(t);
        TBody b = t.getBody();
        TR row = b.addRow();
        row.setVerticalAlign(VerticalAlignType.TOP);
        TD td = row.addCell();
        td.setVerticalAlign(VerticalAlignType.TOP);
        td.add(this.m_theImage);
        td.setNowrap(true);
        td.setWidth("50px");
        td = row.addCell("ui-mbx-mc");
        NodeContainer content = this.m_content;
        INodeContentRenderer<String> renderer = this.m_dataRenderer;
        if (null != renderer) {
            try {
                renderer.renderNodeContent(this, td, this.m_theText, null);
            }
            catch (Exception ex) {
                Bug.bug(ex);
            }
        } else if (content != null) {
            td.add(content);
        } else {
            DomUtil.renderHtmlString(td, this.m_theText);
        }
        boolean unfocused = true;
        if (this.m_inputList.size() > 0) {
            unfocused = this.renderInputs(td);
        }
        Div bd = this.m_buttonDiv = new Div();
        this.add(bd);
        bd.addCssClass("ui-bb-middle");
        for (Button btn : this.m_theButtons) {
            bd.add(btn);
        }
        if (unfocused) {
            this.setFocusOnButton();
        }
    }

    private boolean renderInputs(@Nonnull NodeContainer nc) {
        boolean unfocused = true;
        Div area = new Div();
        nc.add(area);
        area.setCssClass("ui-mbx2-input-area");
        TBody tb = area.addTable(new String[0]);
        for (InputPair ip : this.m_inputList) {
            TD td;
            NodeBase input = ip.getInput();
            NodeBase label = ip.getLabel();
            if (input == null) {
                if (label == null) continue;
                td = tb.addRowAndCell();
                td.setColspan(2);
                td.add(label);
                td.setCssClass("ui-mbx2-in-lbl");
                continue;
            }
            if (label == null) {
                td = tb.addRowAndCell();
                td.setColspan(2);
                td.add(input);
                td.setCssClass("ui-mbx2-in-ctl");
            } else {
                td = tb.addRowAndCell();
                td.add(label);
                td.setCssClass("ui-mbx2-in-lbl");
                td = tb.addCell();
                td.add(input);
                td.setCssClass("ui-mbx2-in-ctl");
            }
            if (!unfocused) continue;
            input.setFocus();
            unfocused = false;
        }
        return unfocused;
    }

    private void setFocusOnButton() {
        if (this.m_buttonDiv.getChildCount() > 0 && this.m_buttonDiv.getChild(0) instanceof Button) {
            ((Button)this.m_buttonDiv.getChild(0)).setFocus();
        }
    }

    @Nonnull
    public static MsgBox2 on(@Nonnull NodeBase parent) {
        MsgBox2 b = new MsgBox2();
        UrlPage body = parent.getPage().getBody();
        body.undelegatedAdd(0, b);
        return b;
    }

    @Override
    @Nonnull
    public MsgBox2 title(String set) {
        super.title(set);
        return this;
    }

    @Nonnull
    public MsgBox2 type(@Nonnull Type type) {
        String icon;
        String ttl;
        switch (type) {
            default: {
                throw new IllegalStateException((Object)((Object)type) + " ??");
            }
            case ERROR: {
                ttl = Msgs.BUNDLE.getString("ui.mbx.error");
                icon = "THEME/mbx-error.png";
                break;
            }
            case WARNING: {
                ttl = Msgs.BUNDLE.getString("ui.mbx.warning");
                icon = "THEME/mbx-warning.png";
                break;
            }
            case INFO: {
                ttl = Msgs.BUNDLE.getString("ui.mbx.info");
                icon = "THEME/mbx-info.png";
                break;
            }
            case DIALOG: {
                ttl = Msgs.BUNDLE.getString("ui.mbx.dialog");
                icon = "THEME/mbx-question.png";
                break;
            }
            case INPUT: {
                ttl = Msgs.BUNDLE.getString("ui.mbx.input");
                icon = "THEME/mbx-question.png";
            }
        }
        this.m_theImage.setSrc(icon);
        if (this.getWindowTitle() == null) {
            this.setWindowTitle(ttl);
        }
        this.setTestID("msgBox");
        this.m_typeSet = true;
        return this;
    }

    @Nonnull
    public MsgBox2 info() {
        this.type(Type.INFO);
        return this;
    }

    @Nonnull
    public MsgBox2 warning() {
        this.type(Type.WARNING);
        return this;
    }

    @Nonnull
    public MsgBox2 error() {
        this.type(Type.ERROR);
        return this;
    }

    @Nonnull
    public MsgBox2 info(@Nonnull String message) {
        this.type(Type.INFO);
        this.text(message);
        return this;
    }

    @Nonnull
    public MsgBox2 warning(@Nonnull String message) {
        this.type(Type.WARNING);
        this.text(message);
        return this;
    }

    @Nonnull
    public MsgBox2 error(@Nonnull String message) {
        this.type(Type.ERROR);
        this.text(message);
        return this;
    }

    @Nonnull
    public MsgBox2 question() {
        this.type(Type.DIALOG);
        return this;
    }

    @Nonnull
    public MsgBox2 text(@Nonnull String txt) {
        this.m_theText = txt;
        return this;
    }

    @Nonnull
    public MsgBox2 content(@Nonnull NodeContainer content) {
        this.m_content = content;
        return this;
    }

    @Override
    @Nonnull
    public MsgBox2 size(int w, int h) {
        this.setDimensions(w, h);
        return this;
    }

    @Nonnull
    public MsgBox2 button(final @Nonnull MsgBoxButton mbb) {
        if (mbb == null) {
            throw new NullPointerException("A message button cannot be null");
        }
        String lbl = MetaManager.findEnumLabel(mbb);
        if (lbl == null) {
            lbl = mbb.name();
        }
        DefaultButton btn = new DefaultButton(lbl, new IClicked<DefaultButton>(){

            @Override
            public void clicked(@Nonnull DefaultButton b) throws Exception {
                MsgBox2.this.answer((Object)mbb);
            }
        });
        btn.setTestID(mbb.name());
        if (this.m_theButtons.size() == 0) {
            this.m_assumedOkButton = mbb;
        } else {
            this.m_assumedCancelButton = mbb;
        }
        this.m_theButtons.add(btn);
        return this;
    }

    @Nonnull
    public MsgBox2 continueCancel() {
        this.button(MsgBoxButton.CONTINUE);
        this.button(MsgBoxButton.CANCEL);
        return this;
    }

    @Nonnull
    public MsgBox2 yesNo() {
        this.button(MsgBoxButton.YES);
        this.button(MsgBoxButton.NO);
        return this;
    }

    @Nonnull
    public MsgBox2 button(String lbl, Object selval) {
        return this.button(lbl, null, selval);
    }

    @Nonnull
    public MsgBox2 button(String lbl, String icon, final Object selval) {
        this.m_theButtons.add(new DefaultButton(lbl, icon, new IClicked<DefaultButton>(){

            @Override
            public void clicked(@Nonnull DefaultButton b) throws Exception {
                MsgBox2.this.answer(selval);
            }
        }));
        return this;
    }

    @Nonnull
    public MsgBox2 renderer(INodeContentRenderer<String> cr) {
        this.m_dataRenderer = cr;
        return this;
    }

    @Nonnull
    public MsgBox2 onAnswer(@Nonnull IAnswer onAnswer) {
        this.m_onAnswer = onAnswer;
        return this;
    }

    @Nonnull
    public MsgBox2 onAnswer(@Nonnull IAnswer2 onAnswer) {
        this.m_onAnswer2 = onAnswer;
        return this;
    }

    @Nonnull
    public MsgBox2 onAnswer(@Nonnull IClicked<MsgBox2> clicked) {
        this.m_clicked = clicked;
        return this;
    }

    public MsgBox2 autoClose(boolean auto) {
        this.m_autoClose = auto;
        return this;
    }

    private void setCloseButton(MsgBoxButton val) {
        this.m_closeButtonObject = val;
    }

    private void answer(Object sel) throws Exception {
        this.m_selectedChoice = sel;
        try {
            IInput<?> oninput;
            IClicked<MsgBox2> clicked;
            if (this.m_onAnswer != null) {
                this.m_onAnswer.onAnswer((MsgBoxButton)((Object)this.m_selectedChoice));
            }
            if (this.m_onAnswer2 != null) {
                this.m_onAnswer2.onAnswer(this.m_selectedChoice);
            }
            if ((clicked = this.m_clicked) != null && sel == this.m_assumedOkButton) {
                clicked.clicked(this);
            }
            if ((oninput = this.m_oninput) != null && sel == MsgBoxButton.CONTINUE) {
                if (this.m_inputList.size() != 1) {
                    throw new IllegalStateException("Internal: bad input count??");
                }
                InputPair inputPair = this.m_inputList.get(0);
                IControl ic = (IControl)((Object)inputPair.getInput());
                if (null == ic) {
                    throw new IllegalStateException("No IControl<T> as part of IInput<> handling");
                }
                Object value = ic.getValue();
                oninput.onInput(value);
            }
            this.close();
        }
        catch (ValidationException vx) {
            throw vx;
        }
        catch (Exception x) {
            this.close();
            throw x;
        }
    }

    @Nonnull
    public MsgBox2 input(@Nonnull String label, @Nonnull NodeBase control) {
        Label l = new Label(control, label);
        this.input(l, control);
        return this;
    }

    @Nonnull
    public MsgBox2 input(@Nonnull Label label, @Nonnull NodeBase control) {
        this._input(label, control);
        return this;
    }

    private void _input(@Nullable NodeBase label, @Nullable NodeBase control) {
        if (this.m_oninput != null) {
            throw new IllegalStateException("You cannot combine an IInput-based answer with a list-of-controls");
        }
        InputPair p = new InputPair(label, control);
        this.m_inputList.add(p);
    }

    @Nonnull
    public <T> MsgBox2 input(@Nonnull String label, @Nonnull IControl<T> control, @Nonnull IInput<T> onanswer) {
        if (this.m_inputList.size() != 0) {
            throw new IllegalStateException("You cannot combine this with other input controls as there's only one answer.");
        }
        this._input(new Label((NodeBase)((Object)control), label), (NodeBase)((Object)control));
        this.m_oninput = onanswer;
        return this;
    }

    @Nonnull
    public <T> MsgBox2 input(@Nonnull IControl<T> control, @Nonnull IInput<T> onanswer) {
        if (this.m_oninput != null) {
            throw new IllegalStateException("Duplicate IInput<> set");
        }
        if (this.m_inputList.size() != 0) {
            throw new IllegalStateException("You cannot combine this with other input controls as there's only one answer.");
        }
        this._input(null, (NodeBase)((Object)control));
        this.m_oninput = onanswer;
        return this;
    }

    public <T> MsgBox2 icon(@Nonnull String icon) {
        this.m_theImage.setSrc(icon);
        return this;
    }

    public static enum Type {
        INFO,
        WARNING,
        ERROR,
        DIALOG,
        INPUT;

    }

    private final class InputPair {
        @Nullable
        private final NodeBase m_label;
        @Nullable
        private final NodeBase m_input;

        public InputPair(@Nullable NodeBase label, NodeBase input) {
            if (null == label && null == input) {
                throw new IllegalStateException("Both nodes cannot be null");
            }
            this.m_label = label;
            this.m_input = input;
        }

        @Nullable
        public NodeBase getLabel() {
            return this.m_label;
        }

        @Nullable
        public NodeBase getInput() {
            return this.m_input;
        }
    }

    public static interface IInput<T> {
        public void onInput(T var1) throws Exception;
    }

    public static interface IAnswer2 {
        public void onAnswer(Object var1) throws Exception;
    }

    public static interface IAnswer {
        public void onAnswer(@Nonnull MsgBoxButton var1) throws Exception;
    }
}

