/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.misc;

import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import to.etc.domui.component.layout.FloatingWindow;
import to.etc.domui.component.layout.TabPanel;
import to.etc.domui.dom.html.Div;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.dom.html.NodeContainer;
import to.etc.domui.dom.html.TBody;
import to.etc.domui.dom.html.TD;
import to.etc.domui.dom.html.Table;
import to.etc.util.StringTool;
import to.etc.webapp.nls.NlsContext;

public class OddCharacters
extends FloatingWindow {
    final String[] fchars = new String[]{"&euro;", "\u00e9", "\u00ed", "\u00f3", "\u00eb", "\u00ef", "\u00f6", "\u00e8"};
    final String[] chars = new String[]{"&euro;", "\u0192", "\u201e", "\u2026", "\u2020", "\u2021", "\u02c6", "\u2030", "\u0160", "\u2039", "\u0152", "&lsquo;", "&rsquo;", "&rsquo;", "&ldquo;", "&rdquo;", "\u2022", "&ndash;", "&mdash;", "\u02dc", "\u2122", "\u0161", "\u203a", "\u0153", "\u0178", "&iexcl;", "&cent;", "&pound;", "&pound;", "&curren;", "&yen;", "&brvbar;", "&sect;", "&uml;", "&copy;", "&ordf;", "&laquo;", "&not;", "\u00ad", "&reg;", "&macr;", "&deg;", "&plusmn;", "&sup2;", "&sup3;", "&acute;", "&micro;", "&para;", "&middot;", "&cedil;", "&sup1;", "&ordm;", "&raquo;", "&frac14;", "&frac12;", "&frac34;", "&iquest;", "&Agrave;", "&Aacute;", "&Acirc;", "&Atilde;", "&Auml;", "&Aring;", "&AElig;", "&Ccedil;", "&Egrave;", "&Eacute;", "&Ecirc;", "&Euml;", "&Igrave;", "&Iacute;", "&Icirc;", "&Iuml;", "&ETH;", "&Ntilde;", "&Ograve;", "&Oacute;", "&Ocirc;", "&Otilde;", "&Ouml;", "&times;", "&Oslash;", "&Ugrave;", "&Uacute;", "&Ucirc;", "&Uuml;", "&Yacute;", "&THORN;", "&szlig;", "&agrave;", "&aacute;", "&acirc;", "&atilde;", "&auml;", "&aring;", "&aelig;", "&ccedil;", "&egrave;", "&eacute;", "&ecirc;", "&euml;", "&igrave;", "&iacute;", "&icirc;", "&iuml;", "&eth;", "&ntilde;", "&ograve;", "&oacute;", "&ocirc;", "&otilde;", "&ouml;", "&divide;", "&oslash;", "&ugrave;", "&uacute;", "&ucirc;", "&uuml;", "&uuml;", "&yacute;", "&thorn;", "&yuml;"};

    @Override
    public void createContent() throws Exception {
        this.setWidth("400px");
        this.setWindowTitle("Speciale tekens en teksten");
        super.createContent();
        TabPanel tp = new TabPanel();
        this.add(tp);
        tp.add(this.createTekens(), "Tekens", "THEME/btnSpecialChar.png");
        tp.add(this.createDates(), "Datum/tijd", "THEME/btnClock.png");
    }

    private NodeBase createTekens() throws IOException {
        Div root = new Div();
        root.setCssClass("ui-oddchars");
        Table tbl = new Table();
        root.add(tbl);
        TBody b = new TBody();
        tbl.add(b);
        tbl.setCssClass("ui-oddchars-tbl");
        tbl.setCellSpacing("0");
        tbl.setCellPadding("0");
        b.addRow();
        TD td = b.addCell();
        td.setColspan(this.fchars.length);
        td.add("Vaak gebruikte speciale tekens");
        td.setCssClass("ui-oddchars-ttl");
        b.addRow();
        int i = 0;
        StringBuilder sb = new StringBuilder(32);
        for (String t : this.fchars) {
            StringTool.entitiesToUnicode((Appendable)sb, (String)t, (boolean)true);
            td = b.addCell();
            td.setText(sb.toString());
            td.setCssClass("ui-oddchars-c");
            td.setOnClickJS("WebUI.oddChar(this)");
            sb.setLength(0);
        }
        tbl = new Table();
        root.add(tbl);
        tbl.setCssClass("ui-oddchars-tbl2");
        tbl.setCellSpacing("0");
        tbl.setCellPadding("0");
        b.addRow();
        int width = 15;
        td = b.addCell();
        td.setColspan(width);
        td.add("Alle speciale tekens");
        int ix = 0;
        while (ix < this.chars.length) {
            b.addRow();
            for (i = 0; i < width; ++i) {
                td = b.addCell();
                if (ix >= this.chars.length) continue;
                td.setCssClass("ui-oddchars-c");
                sb.setLength(0);
                StringTool.entitiesToUnicode((Appendable)sb, (String)this.chars[ix++], (boolean)true);
                td.add(sb.toString());
                td.setOnClickJS("WebUI.oddChar(this)");
            }
        }
        return root;
    }

    private NodeBase createDates() {
        Div root = new Div();
        Locale l = NlsContext.getLocale();
        this.addDate(root, DateFormat.getDateInstance(0, l));
        this.addDate(root, DateFormat.getDateInstance(1, l));
        this.addDate(root, DateFormat.getDateInstance(2, l));
        this.addDate(root, DateFormat.getDateInstance(3, l));
        this.addDate(root, DateFormat.getDateTimeInstance(0, 0, l));
        this.addDate(root, DateFormat.getDateTimeInstance(2, 0, l));
        this.addDate(root, DateFormat.getDateTimeInstance(3, 0, l));
        this.addDate(root, DateFormat.getDateTimeInstance(0, 2, l));
        this.addDate(root, DateFormat.getDateTimeInstance(2, 2, l));
        this.addDate(root, DateFormat.getDateTimeInstance(3, 2, l));
        this.addDate(root, DateFormat.getDateTimeInstance(0, 3, l));
        this.addDate(root, DateFormat.getDateTimeInstance(2, 3, l));
        this.addDate(root, DateFormat.getDateTimeInstance(3, 3, l));
        return root;
    }

    private void addDate(NodeContainer c, DateFormat df) {
        Div s = new Div();
        c.add(s);
        s.setCssClass("ui-oddchars-dt");
        Date d = new Date();
        s.add(df.format(d));
        s.setOnClickJS("WebUI.oddChar(this)");
    }
}

