/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.misc;

public class WindowParameters {
    private int m_width = -1;
    private int m_height = -1;
    private String m_name;
    private boolean m_resizable = true;
    private boolean m_showScrollbars = true;
    private boolean m_showToolbar = true;
    private boolean m_showLocation = true;
    private boolean m_showDirectories = true;
    private boolean m_showStatus = true;
    private boolean m_showMenubar = true;
    private boolean m_copyhistory = false;

    public WindowParameters setSize(int w, int h) {
        this.setWidth(w);
        this.setHeight(h);
        return this;
    }

    public int getWidth() {
        return this.m_width;
    }

    public WindowParameters setWidth(int width) {
        this.m_width = width;
        return this;
    }

    public int getHeight() {
        return this.m_height;
    }

    public WindowParameters setHeight(int height) {
        this.m_height = height;
        return this;
    }

    public String getName() {
        return this.m_name;
    }

    public WindowParameters setName(String name) {
        this.m_name = name;
        return this;
    }

    public boolean isResizable() {
        return this.m_resizable;
    }

    public WindowParameters setResizable(boolean resizable) {
        this.m_resizable = resizable;
        return this;
    }

    public boolean isShowScrollbars() {
        return this.m_showScrollbars;
    }

    public WindowParameters setShowScrollbars(boolean showScrollbars) {
        this.m_showScrollbars = showScrollbars;
        return this;
    }

    public boolean isShowToolbar() {
        return this.m_showToolbar;
    }

    public WindowParameters setShowToolbar(boolean showToolbar) {
        this.m_showToolbar = showToolbar;
        return this;
    }

    public boolean isShowLocation() {
        return this.m_showLocation;
    }

    public WindowParameters setShowLocation(boolean showLocation) {
        this.m_showLocation = showLocation;
        return this;
    }

    public boolean isShowDirectories() {
        return this.m_showDirectories;
    }

    public WindowParameters setShowDirectories(boolean showDirectories) {
        this.m_showDirectories = showDirectories;
        return this;
    }

    public boolean isShowStatus() {
        return this.m_showStatus;
    }

    public WindowParameters setShowStatus(boolean showStatus) {
        this.m_showStatus = showStatus;
        return this;
    }

    public boolean isShowMenubar() {
        return this.m_showMenubar;
    }

    public WindowParameters setShowMenubar(boolean showMenubar) {
        this.m_showMenubar = showMenubar;
        return this;
    }

    public boolean isCopyhistory() {
        return this.m_copyhistory;
    }

    public WindowParameters setCopyhistory(boolean copyhistory) {
        this.m_copyhistory = copyhistory;
        return this;
    }

    public static WindowParameters createFixed(int w, int h, String name) {
        WindowParameters p = new WindowParameters();
        p.setSize(w, h);
        p.setName(name);
        p.setCopyhistory(false);
        p.setResizable(false);
        p.setShowDirectories(false);
        p.setShowLocation(true);
        p.setShowMenubar(false);
        p.setShowScrollbars(false);
        p.setShowStatus(false);
        p.setShowToolbar(false);
        return p;
    }

    public static WindowParameters createResizeableScrollable(int w, int h, String name) {
        WindowParameters p = new WindowParameters();
        p.setSize(w, h);
        p.setName(name);
        p.setCopyhistory(false);
        p.setResizable(true);
        p.setShowDirectories(false);
        p.setShowLocation(true);
        p.setShowMenubar(false);
        p.setShowScrollbars(true);
        p.setShowStatus(false);
        p.setShowToolbar(false);
        return p;
    }

    public static WindowParameters createResizeableScrollable(int w, int h) {
        return WindowParameters.createResizeableScrollable(w, h, "w" + System.nanoTime());
    }
}

