/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.ntbl;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.buttons.LinkButton;
import to.etc.domui.component.misc.MsgBox;
import to.etc.domui.component.ntbl.IEditor;
import to.etc.domui.component.ntbl.IRowButtonFactory;
import to.etc.domui.component.ntbl.IRowEditorEvent;
import to.etc.domui.component.ntbl.IRowEditorFactory;
import to.etc.domui.component.tbl.ColumnContainer;
import to.etc.domui.component.tbl.HeaderContainer;
import to.etc.domui.component.tbl.IModifyableTableModel;
import to.etc.domui.component.tbl.IRowRenderer;
import to.etc.domui.component.tbl.ITableModel;
import to.etc.domui.component.tbl.RowButtonContainer;
import to.etc.domui.component.tbl.TableModelTableBase;
import to.etc.domui.dom.html.Div;
import to.etc.domui.dom.html.IClicked;
import to.etc.domui.dom.html.IHasModifiedIndication;
import to.etc.domui.dom.html.MsgDiv;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.dom.html.NodeContainer;
import to.etc.domui.dom.html.TBody;
import to.etc.domui.dom.html.TD;
import to.etc.domui.dom.html.THead;
import to.etc.domui.dom.html.TR;
import to.etc.domui.dom.html.Table;
import to.etc.domui.server.DomApplication;
import to.etc.domui.util.DomUtil;
import to.etc.domui.util.Msgs;

public class ExpandingEditTable<T>
extends TableModelTableBase<T>
implements IHasModifiedIndication {
    @Nonnull
    private Table m_table = new Table();
    @Nonnull
    private IRowRenderer<T> m_rowRenderer;
    @Nullable
    private IRowEditorFactory<T, ?> m_editorFactory;
    @Nullable
    private IRowEditorEvent<T, ?> m_onRowChangeCompleted;
    @Nullable
    private IRowButtonFactory<T> m_rowButtonFactory;
    @Nullable
    TBody m_dataBody;
    private boolean m_hideHeader;
    private boolean m_hideIndex;
    private int m_columnCount;
    private boolean m_modifiedByUser;
    private boolean m_disableErrors = true;
    private boolean m_newAtStart;
    @Nullable
    private T m_newInstance;
    @Nullable
    private TBody m_newBody;
    @Nullable
    private NodeContainer m_newEditor;
    @Nullable
    private NodeContainer m_emptyDiv;
    private boolean m_enableDeleteButton = true;
    private boolean m_enableAddingItems = true;
    private boolean m_enableExpandItems = true;
    private boolean m_enableRowEdit = true;

    public ExpandingEditTable(@Nonnull Class<T> actualClass, @Nonnull ITableModel<T> m, @Nonnull IRowRenderer<T> r) {
        super(m);
        this.m_rowRenderer = r;
        this.setErrorFence();
    }

    public ExpandingEditTable(@Nonnull ITableModel<T> m, @Nonnull IRowRenderer<T> r) {
        super(m);
        this.m_rowRenderer = r;
        this.setErrorFence();
    }

    private boolean setEmptyDiv() throws Exception {
        if (this.getModel().getRows() == 0) {
            if (this.m_emptyDiv != null) {
                return true;
            }
            Div d = new Div();
            this.m_emptyDiv = d;
            d.setCssClass("ui-xdt-nores");
            d.setText(Msgs.BUNDLE.getString("ui.dt.empty"));
            this.add(d);
            return true;
        }
        if (this.m_emptyDiv != null) {
            this.m_emptyDiv.remove();
        }
        return false;
    }

    @Nonnull
    private TBody getDataBody() {
        if (null != this.m_dataBody) {
            return this.m_dataBody;
        }
        throw new IllegalStateException("The data body is empty??");
    }

    @Override
    public void createContent() throws Exception {
        this.setCssClass("ui-xdt");
        if (this.getErrorFence() != null) {
            DomApplication.get().getControlBuilder().addErrorFragment(this);
        }
        this.m_rowRenderer.beforeQuery(this);
        this.m_table.removeAllChildren();
        this.add(this.m_table);
        this.m_dataBody = new TBody();
        this.m_table.add(this.m_dataBody);
        if (this.setEmptyDiv()) {
            return;
        }
        List<T> list = this.getPageItems();
        if (!this.isHideHeader()) {
            THead hd = new THead();
            HeaderContainer hc = new HeaderContainer(this, hd, "ui-xdt-hdr");
            if (!this.isHideIndex()) {
                hc.add((NodeBase)null);
            }
            this.m_rowRenderer.renderHeader(this, hc);
            if (hc.hasContent()) {
                this.m_table.add(hd);
            }
            this.m_columnCount = hc.row().getChildCount();
            if (!this.isHideIndex()) {
                --this.m_columnCount;
            }
            hc.add((NodeBase)null);
        }
        ColumnContainer cc = new ColumnContainer(this);
        RowButtonContainer rc = new RowButtonContainer();
        int ix = 0;
        for (T o : list) {
            TR tr = new TR();
            this.getDataBody().add(tr);
            this.renderCollapsedRow(cc, rc, tr, ix, o);
            ++ix;
        }
    }

    @Nonnull
    protected List<T> getPageItems() throws Exception {
        return this.getModel() == null ? Collections.EMPTY_LIST : this.getModel().getItems(0, this.getModel().getRows());
    }

    private void renderCollapsedRow(int index, @Nonnull T value) throws Exception {
        ColumnContainer cc = new ColumnContainer(this);
        TR tr = (TR)this.getDataBody().getChild(index);
        tr.removeAllChildren();
        tr.setUserObject(null);
        RowButtonContainer bc = new RowButtonContainer();
        this.renderCollapsedRow(cc, bc, tr, index, value);
    }

    private void renderCollapsedRow(@Nonnull ColumnContainer<T> cc, @Nonnull RowButtonContainer bc, @Nonnull TR tr, int index, final @Nonnull T value) throws Exception {
        TD td;
        cc.setParent(tr);
        if (!this.isHideIndex()) {
            td = cc.add((NodeBase)null);
            this.createIndexNode(td, index, true);
        }
        this.m_rowRenderer.renderRow(this, cc, index, value);
        this.m_columnCount = tr.getChildCount();
        if (!this.isHideIndex()) {
            --this.m_columnCount;
        }
        td = cc.add((NodeBase)null);
        bc.setContainer(td);
        IRowButtonFactory<T> bf = this.getRowButtonFactory();
        if (bf != null) {
            bf.addButtonsFor(bc, value);
        }
        if (this.isEnableDeleteButton() && this.getModel() instanceof IModifyableTableModel) {
            bc.addConfirmedLinkButton(Msgs.BUNDLE.getString("ui.xdt.delete"), "THEME/btnDelete.png", Msgs.BUNDLE.getString("ui.xdt.delsure"), new IClicked<LinkButton>(){

                @Override
                public void clicked(@Nonnull LinkButton clickednode) throws Exception {
                    ((IModifyableTableModel)((Object)ExpandingEditTable.this.getModel())).delete(value);
                    DomUtil.setModifiedFlag(ExpandingEditTable.this);
                }
            });
        }
    }

    private void createIndexNode(@Nonnull TD td, final int index, boolean collapsed) {
        MsgDiv d = new MsgDiv(Integer.toString(index + 1));
        td.add(d);
        if (this.isEnableExpandItems()) {
            d.setCssClass(collapsed ? "ui-xdt-ix ui-xdt-clp" : "ui-xdt-ix ui-xdt-exp");
            td.setClicked(new IClicked<TD>(){

                @Override
                public void clicked(@Nonnull TD clickednode) throws Exception {
                    ExpandingEditTable.this.toggleExpanded(index);
                }
            });
        }
    }

    private void updateIndexes(int start) {
        if (this.isHideIndex()) {
            return;
        }
        for (int ix = start; ix < this.getDataBody().getChildCount(); ++ix) {
            TR tr = (TR)this.getDataBody().getChild(ix);
            TD td = (TD)tr.getChild(0);
            td.removeAllChildren();
            this.createIndexNode(td, ix, this.isExpanded(ix));
        }
    }

    private boolean isExpanded(int ix) {
        if (ix < 0 || ix >= this.getDataBody().getChildCount()) {
            return false;
        }
        TR tr = (TR)this.getDataBody().getChild(ix);
        return tr.getUserObject() != null;
    }

    private NodeContainer createEditor(@Nonnull TD into, @Nonnull RowButtonContainer bc, @Nonnull T instance, boolean isnew) throws Exception {
        if (this.getEditorFactory() == null) {
            throw new IllegalStateException("Auto editor creation not yet supported");
        }
        NodeContainer editor = this.getEditorFactory().createRowEditor(instance, isnew, !this.m_enableRowEdit);
        into.add(editor);
        if (editor.getCssClass() == null) {
            editor.setCssClass("ui-xdt-edt");
        }
        into.getParent(TR.class).setUserObject(editor);
        return editor;
    }

    protected void toggleExpanded(int index) throws Exception {
        if (index < 0 || index >= this.getDataBody().getChildCount()) {
            return;
        }
        TR tr = (TR)this.getDataBody().getChild(index);
        if (tr.getUserObject() == null) {
            this.expandRow(index, tr);
        } else {
            this.collapseRow(index, tr);
        }
    }

    public void collapseRow(int index) throws Exception {
        if (index < 0 || index >= this.getDataBody().getChildCount()) {
            return;
        }
        TR tr = (TR)this.getDataBody().getChild(index);
        this.collapseRow(index, tr);
    }

    public void expandRow(int index) throws Exception {
        if (index < 0 || index >= this.getDataBody().getChildCount()) {
            return;
        }
        TR tr = (TR)this.getDataBody().getChild(index);
        this.expandRow(index, tr);
    }

    private int getColumnCount() {
        return this.m_columnCount;
    }

    private void expandRow(int index, TR tr) throws Exception {
        TD td;
        if (tr.getUserObject() != null) {
            return;
        }
        tr.removeAllChildren();
        if (!this.isHideIndex()) {
            td = tr.addCell();
            this.createIndexNode(td, index, false);
        }
        td = tr.addCell();
        int colspan = this.getColumnCount();
        td.setColspan(colspan);
        TD atd = tr.addCell();
        RowButtonContainer bc = new RowButtonContainer(atd);
        Object item = this.getModelItem(index);
        this.createEditor(td, bc, item, false);
    }

    private void collapseRow(int index, @Nonnull TR tr) throws Exception {
        IEditor e;
        if (tr.getUserObject() == null) {
            return;
        }
        NodeContainer editor = (NodeContainer)tr.getUserObject();
        if (null == editor) {
            throw new IllegalStateException("? No editor in row user object??");
        }
        Object item = this.getModelItem(index);
        if (DomUtil.isModified(editor)) {
            DomUtil.setModifiedFlag(this);
        }
        if (editor instanceof IEditor && !(e = (IEditor)((Object)editor)).validate(false)) {
            return;
        }
        IRowEditorEvent onRowChangeCompleted = this.getOnRowChangeCompleted();
        if (onRowChangeCompleted != null && !onRowChangeCompleted.onRowChanged(this, editor, item, false)) {
            return;
        }
        if (item != null) {
            this.renderCollapsedRow(index, item);
        }
    }

    public void addNew(@Nonnull T instance) throws Exception {
        TD td;
        if (!(this.getModel() instanceof IModifyableTableModel)) {
            throw new IllegalStateException("The model is not an IModifyableTableModel: use addNew(T, IClicked) instead");
        }
        this.clearNewEditor();
        TBody newBody = this.m_newBody = new TBody();
        if (this.m_newAtStart) {
            this.getTable().add(0, newBody);
        } else {
            this.getTable().add(newBody);
        }
        TR tr = newBody.addRow();
        if (!this.isHideIndex()) {
            td = tr.addCell();
            MsgDiv d = new MsgDiv("*");
            td.add(d);
            d.setCssClass("ui-xdt-ix");
            td.setClicked(new IClicked<TD>(){

                @Override
                public void clicked(@Nonnull TD clickednode) throws Exception {
                    ExpandingEditTable.this.commitNewRow();
                }
            });
        }
        td = tr.addCell();
        int colspan = this.getColumnCount();
        td.setColspan(colspan);
        TD atd = tr.addCell();
        RowButtonContainer bc = new RowButtonContainer(atd);
        this.m_newEditor = this.createEditor(td, bc, instance, true);
        this.m_newInstance = instance;
        bc.addLinkButton(Msgs.BUNDLE.getString("ui.xdt.confirm"), "THEME/btnConfirm.png", new IClicked<LinkButton>(){

            @Override
            public void clicked(@Nonnull LinkButton clickednode) throws Exception {
                ExpandingEditTable.this.commitNewRow();
            }
        });
        bc.addLinkButton(Msgs.BUNDLE.getString("ui.xdt.cancel"), "THEME/btnDelete.png", new IClicked<LinkButton>(){

            @Override
            public void clicked(@Nonnull LinkButton clickednode) throws Exception {
                ExpandingEditTable.this.cancelNew();
            }
        });
    }

    public void cancelNew() {
        if (this.m_newEditor == null) {
            return;
        }
        if (DomUtil.isModified(this.m_newEditor)) {
            MsgBox.continueCancel((NodeBase)this, Msgs.BUNDLE.getString("ui.xdt.sure"), new IClicked<MsgBox>(){

                @Override
                public void clicked(@Nonnull MsgBox clickednode) throws Exception {
                    ExpandingEditTable.this.cancelNewReally();
                }
            });
            return;
        }
        this.cancelNewReally();
    }

    void cancelNewReally() {
        if (this.m_newEditor == null) {
            return;
        }
        this.m_newEditor = null;
        if (this.m_newBody != null) {
            this.m_newBody.remove();
        }
        this.m_newBody = null;
        this.m_newInstance = null;
    }

    protected void commitNewRow() throws Exception {
        this.clearNewEditor();
    }

    private void clearNewEditor() throws Exception {
        IEditor e;
        TBody newBody = this.m_newBody;
        NodeContainer newEditor = this.m_newEditor;
        if (newBody == null || newEditor == null) {
            return;
        }
        if (newEditor instanceof IEditor && !(e = (IEditor)((Object)newEditor)).validate(true)) {
            return;
        }
        T newInstance = this.m_newInstance;
        if (null == newInstance) {
            throw new IllegalStateException("The 'new' instance being edited is null?");
        }
        IRowEditorEvent<T, ?> onRowChangeCompleted = this.getOnRowChangeCompleted();
        if (onRowChangeCompleted != null && !onRowChangeCompleted.onRowChanged(this, newEditor, newInstance, true)) {
            return;
        }
        if (this.isEnableAddingItems()) {
            if (!(this.getModel() instanceof IModifyableTableModel)) {
                throw new IllegalStateException("model not of expected type IModifyableTableModel<T> : " + this.getModel().getClass().getName());
            }
            IModifyableTableModel mtm = (IModifyableTableModel)((Object)this.getModel());
            mtm.add(newInstance);
        }
        newBody.remove();
        this.m_newBody = null;
        this.m_newInstance = null;
        this.m_newEditor = null;
    }

    @Override
    public void modelChanged(@Nullable ITableModel<T> model) {
        this.forceRebuild();
        this.m_newBody = null;
        this.m_newEditor = null;
        this.m_newInstance = null;
    }

    @Override
    public void rowAdded(@Nonnull ITableModel<T> model, int index, @Nonnull T value) throws Exception {
        if (!this.isBuilt()) {
            return;
        }
        if (index < 0 || index > this.getDataBody().getChildCount()) {
            throw new IllegalStateException("Insane index: " + index);
        }
        TR tr = new TR();
        this.getDataBody().add(index, tr);
        this.renderCollapsedRow(index, value);
        this.updateIndexes(index + 1);
        this.setEmptyDiv();
    }

    @Override
    public void rowDeleted(@Nonnull ITableModel<T> model, int index, @Nullable T value) throws Exception {
        if (!this.isBuilt()) {
            return;
        }
        if (index < 0 || index >= this.getDataBody().getChildCount()) {
            throw new IllegalStateException("Insane index: " + index);
        }
        TR row = this.getDataBody().getRow(index);
        row.remove();
        this.updateIndexes(index);
        this.setEmptyDiv();
    }

    @Override
    public void rowModified(@Nonnull ITableModel<T> model, int index, @Nonnull T value) throws Exception {
        if (!this.isBuilt()) {
            return;
        }
        if (index < 0 || index >= this.getDataBody().getChildCount()) {
            throw new IllegalStateException("Insane index: " + index);
        }
        this.renderCollapsedRow(index, value);
    }

    @Override
    public boolean isModified() {
        return this.m_modifiedByUser;
    }

    @Override
    public void setModified(boolean as) {
        this.m_modifiedByUser = as;
    }

    @Nonnull
    protected Table getTable() {
        return this.m_table;
    }

    public void setTableWidth(@Nullable String w) {
        this.m_table.setTableWidth(w);
    }

    public boolean isHideHeader() {
        return this.m_hideHeader;
    }

    public void setHideHeader(boolean hideHeader) {
        if (this.m_hideHeader == hideHeader) {
            return;
        }
        this.m_hideHeader = hideHeader;
        this.forceRebuild();
    }

    public boolean isHideIndex() {
        return this.m_hideIndex;
    }

    public void setHideIndex(boolean hideIndex) {
        if (this.m_hideIndex == hideIndex) {
            return;
        }
        this.m_hideIndex = hideIndex;
        this.forceRebuild();
    }

    public void setDisableErrors(boolean on) {
        if (this.m_disableErrors == on) {
            return;
        }
        this.m_disableErrors = on;
        this.forceRebuild();
    }

    public boolean isDisableErrors() {
        return this.m_disableErrors;
    }

    public boolean isNewAtStart() {
        return this.m_newAtStart;
    }

    public void setNewAtStart(boolean newAtStart) {
        this.m_newAtStart = newAtStart;
    }

    @Nonnull
    public IRowEditorFactory<T, ? extends NodeContainer> getEditorFactory() {
        if (null != this.m_editorFactory) {
            return this.m_editorFactory;
        }
        throw new IllegalStateException("editorFactory is not set.");
    }

    public void setEditorFactory(@Nullable IRowEditorFactory<T, ? extends NodeContainer> editorFactory) {
        this.m_editorFactory = editorFactory;
    }

    @Nullable
    public IRowButtonFactory<T> getRowButtonFactory() {
        return this.m_rowButtonFactory;
    }

    public void setRowButtonFactory(@Nullable IRowButtonFactory<T> rowButtonFactory) {
        if (rowButtonFactory != null) {
            this.setEnableDeleteButton(false);
        }
        this.m_rowButtonFactory = rowButtonFactory;
    }

    @Nullable
    public IRowEditorEvent<T, ?> getOnRowChangeCompleted() {
        return this.m_onRowChangeCompleted;
    }

    public void setOnRowChangeCompleted(@Nullable IRowEditorEvent<T, ?> onRowChangeCompleted) {
        this.m_onRowChangeCompleted = onRowChangeCompleted;
    }

    public boolean isEnableDeleteButton() {
        return this.m_enableDeleteButton;
    }

    public void setEnableDeleteButton(boolean enableDeleteButton) {
        this.m_enableDeleteButton = enableDeleteButton;
    }

    public boolean isEnableAddingItems() {
        return this.m_enableAddingItems;
    }

    public void setEnableAddingItems(boolean enableAddingItems) {
        this.m_enableAddingItems = enableAddingItems;
    }

    public boolean collapseAllExpandedRows() throws Exception {
        boolean dataValid = true;
        if (this.m_newAtStart && this.m_newBody != null) {
            this.clearNewEditor();
            boolean bl = dataValid = this.m_newBody == null;
        }
        if (this.m_dataBody != null) {
            int index = 0;
            for (TR row : this.getDataBody().getChildren(TR.class)) {
                if (row.getUserObject() != null && row.getUserObject() instanceof IEditor) {
                    this.collapseRow(index, row);
                    dataValid = dataValid && row.getUserObject() == null;
                }
                ++index;
            }
        }
        if (!this.m_newAtStart && this.m_newBody != null) {
            this.clearNewEditor();
            dataValid = dataValid && this.m_newBody == null;
        }
        return dataValid;
    }

    public boolean isEnableExpandItems() {
        return this.m_enableExpandItems;
    }

    public void setEnableExpandItems(boolean enableExpandItems) {
        this.m_enableExpandItems = enableExpandItems;
    }

    public boolean isEnableRowEdit() {
        return this.m_enableRowEdit;
    }

    public void setEnableRowEdit(boolean enableRowEdit) {
        this.m_enableRowEdit = enableRowEdit;
    }
}

