/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.tbl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import to.etc.domui.component.meta.ClassMetaModel;
import to.etc.domui.component.meta.MetaManager;
import to.etc.domui.component.meta.SortableType;
import to.etc.domui.component.ntbl.IRowButtonFactory;
import to.etc.domui.component.tbl.ColumnContainer;
import to.etc.domui.component.tbl.ColumnDefList;
import to.etc.domui.component.tbl.DataTable;
import to.etc.domui.component.tbl.HeaderContainer;
import to.etc.domui.component.tbl.ICellClicked;
import to.etc.domui.component.tbl.IClickableRowRenderer;
import to.etc.domui.component.tbl.ISortHelper;
import to.etc.domui.component.tbl.ISortableTableModel;
import to.etc.domui.component.tbl.SimpleColumnDef;
import to.etc.domui.component.tbl.TableModelTableBase;
import to.etc.domui.converter.IConverter;
import to.etc.domui.converter.IObjectToStringConverter;
import to.etc.domui.dom.html.Div;
import to.etc.domui.dom.html.IClicked;
import to.etc.domui.dom.html.Img;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.dom.html.Span;
import to.etc.domui.dom.html.TD;
import to.etc.domui.dom.html.TH;
import to.etc.domui.dom.html.TR;
import to.etc.domui.util.INodeContentRenderer;
import to.etc.domui.util.IValueTransformer;
import to.etc.webapp.ProgrammerErrorException;
import to.etc.webapp.nls.NlsContext;

public class AbstractRowRenderer<T>
implements IClickableRowRenderer<T> {
    @Nonnull
    private final Class<T> m_dataClass;
    @Nonnull
    private final ClassMetaModel m_metaModel;
    private boolean m_completed;
    @Nonnull
    private final ColumnDefList<T> m_columnList;
    private Img[] m_sortImages;
    private ICellClicked<?> m_rowClicked;
    private IRowButtonFactory<T> m_rowButtonFactory;
    private String m_unknownColumnCaption;
    @Nullable
    private IRowRendered<T> m_onRowRendered;
    private boolean m_sortDescending;

    public AbstractRowRenderer(@Nonnull Class<T> data) {
        this(data, MetaManager.findClassMeta(data));
    }

    public AbstractRowRenderer(@Nonnull Class<T> data, @Nonnull ClassMetaModel cmm) {
        this.m_dataClass = data;
        this.m_metaModel = cmm;
        this.m_columnList = new ColumnDefList<T>(data, this.m_metaModel);
    }

    @Nonnull
    protected ColumnDefList<T> getColumnList() {
        return this.m_columnList;
    }

    public void setDefaultSort(@Nonnull SimpleColumnDef<?> cd, @Nonnull SortableType type) {
        cd.setSortable(type);
        this.getColumnList().setSortColumn(cd);
    }

    public void setSort(@Nonnull String column, @Nonnull SortableType type) {
        SimpleColumnDef<?> col = this.getColumnList().findColumn(column);
        if (null == col) {
            return;
        }
        this.getColumnList().setSortColumn(col);
        col.setSortable(type);
    }

    @Nonnull
    protected ClassMetaModel model() {
        return this.m_metaModel;
    }

    @Nonnull
    protected Class<?> getActualClass() {
        return this.m_dataClass;
    }

    protected void check() {
        if (this.m_completed) {
            throw new IllegalStateException("Programmer error: This object has been USED and cannot be changed anymore");
        }
    }

    @OverridingMethodsMustInvokeSuper
    protected void complete(@Nonnull TableModelTableBase<T> tbl) {
        SimpleColumnDef<?> scol;
        if (!this.m_completed && (scol = this.getSortColumn()) != null) {
            this.m_sortDescending = scol.getSortable() == SortableType.SORTABLE_DESC;
        }
        this.m_completed = true;
    }

    protected boolean isComplete() {
        return this.m_completed;
    }

    protected void setSortColumn(@Nullable SimpleColumnDef<?> cd, @Nullable SortableType type) {
        if (null != cd && null != type) {
            cd.setSortable(type);
        }
        this.m_columnList.setSortColumn(cd);
    }

    @Nullable
    protected SimpleColumnDef<?> getSortColumn() {
        return this.m_columnList.getSortColumn();
    }

    protected boolean isSortDescending() {
        return this.m_sortDescending;
    }

    @Nonnull
    public SimpleColumnDef<?> getColumn(int ix) {
        return this.m_columnList.get(ix);
    }

    public int getColumnCount() {
        return this.m_columnList.size();
    }

    @Nonnull
    public SimpleColumnDef<?> getColumnByName(String propertyName) {
        for (SimpleColumnDef<?> simpleColumnDef : this.m_columnList) {
            if (!propertyName.equals(simpleColumnDef.getPropertyName())) continue;
            return simpleColumnDef;
        }
        throw new ProgrammerErrorException("The property with the name '" + propertyName + "' is undefined in this RowRenderer - perhaps metadata has changed?");
    }

    public void setColumnWidths(String ... widths) {
        this.check();
        int ix = 0;
        for (String s : widths) {
            this.getColumn(ix++).setWidth(s);
        }
    }

    public void setColumnWidth(int index, String width) {
        this.check();
        this.getColumn(index).setWidth(width);
    }

    public <T> void setNodeRenderer(int index, @Nullable INodeContentRenderer<T> renderer) {
        this.check();
        this.getColumn(index).setContentRenderer(renderer);
    }

    public INodeContentRenderer<?> getNodeRenderer(int index) {
        return this.getColumn(index).getContentRenderer();
    }

    @Override
    @Nullable
    public ICellClicked<?> getRowClicked() {
        return this.m_rowClicked;
    }

    @Override
    public <V> void setRowClicked(@Nullable ICellClicked<V> rowClicked) {
        this.m_rowClicked = rowClicked;
    }

    @Nullable
    public ICellClicked<?> getCellClicked(int col) {
        return this.getColumn(col).getCellClicked();
    }

    @Override
    public <V> void setCellClicked(int col, @Nullable ICellClicked<V> cellClicked) {
        this.getColumn(col).setCellClicked(cellClicked);
    }

    @Override
    public void renderHeader(@Nonnull TableModelTableBase<T> tbl, @Nonnull HeaderContainer<T> cc) throws Exception {
        this.m_sortImages = new Img[this.m_columnList.size()];
        int ix = 0;
        boolean sortablemodel = tbl.getModel() instanceof ISortableTableModel;
        StringBuilder sb = new StringBuilder();
        for (SimpleColumnDef<?> simpleColumnDef : this.m_columnList) {
            TH th;
            String label = simpleColumnDef.getColumnLabel();
            if (!simpleColumnDef.getSortable().isSortable() || !sortablemodel) {
                th = cc.add(label);
            } else {
                Div cellSpan = new Div();
                cellSpan.setCssClass("ui-sortable");
                th = cc.add(cellSpan);
                th.setCssClass("ui-sortable");
                Img img = new Img();
                cellSpan.add(img);
                if (simpleColumnDef == this.getSortColumn()) {
                    img.setSrc(this.m_sortDescending ? "THEME/sort-desc.png" : "THEME/sort-asc.png");
                } else {
                    img.setSrc("THEME/sort-none.png");
                }
                this.m_sortImages[ix] = img;
                if (label == null || label.trim().length() == 0) {
                    label = this.getUnknownColumnCaption();
                }
                cellSpan.add(new Span(label));
                final SimpleColumnDef<?> scd = simpleColumnDef;
                th.setClicked(new IClicked<TH>(){

                    @Override
                    public void clicked(@Nonnull TH b) throws Exception {
                        AbstractRowRenderer.this.handleSortClick(b, scd);
                    }
                });
                String lbl = simpleColumnDef.getPropertyName();
                if (null == lbl) {
                    lbl = label;
                }
                if (null == lbl || lbl.length() == 0) {
                    lbl = Integer.toString(this.m_columnList.indexOf(simpleColumnDef));
                }
                th.setCalculcatedId("H-" + lbl, tbl.calcTestID());
            }
            if (simpleColumnDef.getHeaderCssClass() != null) {
                sb.setLength(0);
                if (th.getCssClass() != null) {
                    sb.append(th.getCssClass());
                    sb.append(' ');
                }
                sb.append(simpleColumnDef.getHeaderCssClass());
                th.setCssClass(sb.toString());
            }
            th.setWidth(simpleColumnDef.getWidth());
            ++ix;
        }
        if (this.getRowButtonFactory() != null) {
            cc.add("");
        }
    }

    void handleSortClick(@Nonnull NodeBase nb, @Nonnull SimpleColumnDef<?> scd) throws Exception {
        SimpleColumnDef<?> sortColumn = this.getSortColumn();
        if (scd == sortColumn) {
            this.m_sortDescending = !this.m_sortDescending;
        } else {
            if (sortColumn != null) {
                this.updateSortImage(sortColumn, "THEME/sort-none.png");
            }
            this.m_columnList.setSortColumn(scd);
            this.m_sortDescending = scd.getSortable() == SortableType.SORTABLE_DESC;
        }
        this.updateSortImage(scd, this.isSortDescending() ? "THEME/sort-desc.png" : "THEME/sort-asc.png");
        DataTable parent = nb.getParent(DataTable.class);
        this.sortModel(parent, scd);
    }

    private void updateSortImage(@Nonnull SimpleColumnDef<?> scd, @Nonnull String img) {
        int index = this.m_columnList.indexOf(scd);
        if (index == -1) {
            throw new IllegalStateException("?? Cannot find sort column!?");
        }
        Img sortimg = this.m_sortImages[index];
        if (null == sortimg) {
            return;
        }
        sortimg.setSrc(img);
    }

    @Override
    public void beforeQuery(@Nonnull TableModelTableBase<T> tbl) throws Exception {
        this.complete(tbl);
        if (!(tbl.getModel() instanceof ISortableTableModel)) {
            return;
        }
        SimpleColumnDef<?> scol = this.getSortColumn();
        if (scol == null) {
            return;
        }
        this.sortModel(tbl, scol);
    }

    private void sortModel(@Nonnull TableModelTableBase<T> tbl, SimpleColumnDef<?> scol) throws Exception {
        ISortHelper<?> sortHelper = scol.getSortHelper();
        if (sortHelper != null) {
            sortHelper.adjustSort(tbl.getModel(), this.isSortDescending());
        } else {
            ISortableTableModel stm = (ISortableTableModel)((Object)tbl.getModel());
            stm.sortOn(scol.getPropertyName(), this.isSortDescending());
        }
    }

    @Override
    public void renderRow(@Nonnull TableModelTableBase<T> tbl, @Nonnull ColumnContainer<T> cc, int index, @Nonnull T instance) throws Exception {
        for (SimpleColumnDef<?> simpleColumnDef : this.m_columnList) {
            this.renderColumn(tbl, cc, index, instance, simpleColumnDef);
        }
        IRowButtonFactory<T> rbf = this.getRowButtonFactory();
        if (rbf != null) {
            TD tD = cc.add((NodeBase)null);
            tD.setNowrap(true);
            cc.getRowButtonContainer().setContainer(tD);
            rbf.addButtonsFor(cc.getRowButtonContainer(), instance);
        }
        if ((index & 1) == 0) {
            cc.getTR().removeCssClass("ui-odd");
            cc.getTR().addCssClass("ui-even");
        } else {
            cc.getTR().removeCssClass("ui-even");
            cc.getTR().addCssClass("ui-odd");
        }
        IRowRendered<T> iRowRendered = this.getOnRowRendered();
        if (null != iRowRendered) {
            iRowRendered.rowRendered(cc.getTR(), instance);
        }
    }

    protected <X> void renderColumn(@Nonnull TableModelTableBase<T> tbl, @Nonnull ColumnContainer<T> cc, int index, final @Nonnull T instance, final @Nonnull SimpleColumnDef<X> cd) throws Exception {
        ICellClicked<X> cellClicked;
        TD cell;
        IValueTransformer<X> valueTransformer = cd.getValueTransformer();
        Object colval = valueTransformer == null ? instance : valueTransformer.getValue(instance);
        String cssClass = cd.getCssClass();
        INodeContentRenderer<X> contentRenderer = cd.getContentRenderer();
        if (null != contentRenderer) {
            cell = cc.add((NodeBase)null);
            if (cssClass != null) {
                cell.addCssClass(cssClass);
            }
            contentRenderer.renderNodeContent(tbl, cell, colval, instance);
        } else {
            IObjectToStringConverter<X> presentationConverter;
            String s = colval == null ? null : ((presentationConverter = cd.getPresentationConverter()) != null ? ((IConverter)presentationConverter).convertObjectToString(NlsContext.getLocale(), colval) : String.valueOf(colval));
            cell = s == null ? cc.add((NodeBase)null) : cc.add(s);
            if (cssClass != null) {
                cell.addCssClass(cssClass);
            }
        }
        Boolean nw = cd.isNowrap();
        if (nw == null && cd.getDisplayLength() == 0 || nw != null && nw.booleanValue()) {
            cell.setNowrap(true);
        }
        if ((cellClicked = cd.getCellClicked()) != null) {
            cell.setClicked(new IClicked<TD>(){

                @Override
                public void clicked(@Nonnull TD b) throws Exception {
                    ICellClicked<Object> clicked = cd.getCellClicked();
                    if (null != clicked) {
                        clicked.cellClicked(b, instance);
                    }
                }
            });
            cell.addCssClass("ui-cellsel");
        }
        if (cd.getAlign() != null) {
            cell.setTextAlign(cd.getAlign());
        } else if (cssClass != null) {
            cell.addCssClass(cssClass);
        }
        String label = cd.getColumnLabel();
        String lbl = cd.getPropertyName();
        if (null == lbl) {
            lbl = label;
        }
        if (null == lbl || lbl.length() == 0) {
            lbl = Integer.toString(this.m_columnList.indexOf(cd));
        }
        cell.setCalculcatedId("C-" + lbl, tbl.calcTestID());
    }

    @Nullable
    public IRowButtonFactory<T> getRowButtonFactory() {
        return this.m_rowButtonFactory;
    }

    public void setRowButtonFactory(@Nullable IRowButtonFactory<T> rowButtonFactory) {
        this.m_rowButtonFactory = rowButtonFactory;
    }

    public void setUnknownColumnCaption(@Nullable String unknownColumnCaption) {
        this.m_unknownColumnCaption = unknownColumnCaption;
    }

    @Nonnull
    public String getUnknownColumnCaption() {
        return this.m_unknownColumnCaption == null ? "" : this.m_unknownColumnCaption;
    }

    @Nullable
    public IRowRendered<T> getOnRowRendered() {
        return this.m_onRowRendered;
    }

    public void setOnRowRendered(@Nullable IRowRendered<T> onRowRendered) {
        this.m_onRowRendered = onRowRendered;
    }

    public static interface IRowRendered<T> {
        public void rowRendered(@Nonnull TR var1, @Nonnull T var2);
    }
}

