/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.tbl;

import javax.annotation.Nonnull;
import to.etc.domui.component.meta.ClassMetaModel;
import to.etc.domui.component.tbl.AbstractRowRenderer;
import to.etc.domui.component.tbl.IClickableRowRenderer;
import to.etc.domui.component.tbl.TableModelTableBase;

public class BasicRowRenderer<T>
extends AbstractRowRenderer<T>
implements IClickableRowRenderer<T> {
    public static final String NOWRAP = "-NOWRAP";
    public static final String WRAP = "-WRAP";
    public static final String DEFAULTSORT = "-DSORT";
    public static final String NUMERIC = "$ui-numeric";
    private String m_sortColumnName;

    public BasicRowRenderer(@Nonnull Class<T> dataClass, Object ... cols) throws Exception {
        super(dataClass);
        this.initColumnSet(cols);
    }

    public BasicRowRenderer(@Nonnull Class<T> dataClass, @Nonnull ClassMetaModel cmm, Object ... cols) {
        super(dataClass, cmm);
        this.initColumnSet(cols);
    }

    private void initColumnSet(Object[] cols) {
        if (cols.length != 0) {
            this.addColumns(cols);
        }
        this.m_sortColumnName = this.model().getDefaultSortProperty();
    }

    public <R> BasicRowRenderer<T> addColumns(Object ... cols) {
        this.getColumnList().addColumns(cols);
        return this;
    }

    public void addDefaultColumns() {
        this.getColumnList().addDefaultColumns();
    }

    @Override
    protected void complete(@Nonnull TableModelTableBase<T> tbl) {
        if (this.isComplete()) {
            return;
        }
        if (this.getColumnList().size() == 0) {
            this.addDefaultColumns();
        }
        if (this.m_sortColumnName != null) {
            this.getColumnList().setDefaultSortColumn(this.m_sortColumnName);
        }
        this.getColumnList().assignPercentages();
        super.complete(tbl);
    }
}

