/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.tbl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.meta.MetaManager;
import to.etc.domui.component.tbl.ColumnContainer;
import to.etc.domui.component.tbl.DataTable;
import to.etc.domui.component.tbl.HeaderContainer;
import to.etc.domui.component.tbl.IRowRenderer;
import to.etc.domui.component.tbl.ITableModel;
import to.etc.domui.dom.html.Checkbox;
import to.etc.domui.dom.html.IClicked;
import to.etc.domui.dom.html.IValueChanged;
import to.etc.domui.dom.html.TD;
import to.etc.domui.dom.html.TR;
import to.etc.domui.util.Msgs;

@Deprecated
public class CheckBoxDataTable<T>
extends DataTable<T> {
    @Nonnull
    private List<T> m_selectedRows = Collections.EMPTY_LIST;
    @Nonnull
    private List<T> m_disabledRows = Collections.EMPTY_LIST;
    @Nullable
    private String m_selectionColTitle;
    @Nullable
    private IValueChanged<CheckBoxDataTable<T>> m_selectionChangedHandler;
    private boolean m_disableOnRowClick = false;
    private boolean m_readOnly;
    private String m_readOnlyTitle;

    public CheckBoxDataTable(@Nonnull ITableModel<T> m, @Nonnull IRowRenderer<T> r) {
        super(m, r);
    }

    protected void handleSelectionChanged(boolean selected, T item) throws Exception {
        if (selected) {
            this.addToSelection(item);
        } else {
            this.removeFromSelection(item);
        }
        if (this.getSelectionChangedHandler() != null) {
            this.getSelectionChangedHandler().onValueChanged(this);
        }
    }

    @Override
    public void setModel(@Nonnull ITableModel<T> model) {
        this.clearSelection();
        super.setModel(model);
    }

    private void clearSelection() {
        if (this.m_selectedRows != Collections.EMPTY_LIST) {
            this.m_selectedRows.clear();
        }
    }

    public void setSelected(T item, boolean on) {
        if (on) {
            this.addToSelection(item);
        } else {
            this.removeFromSelection(item);
        }
    }

    public void setSelected(List<T> items, boolean on) throws Exception {
        for (Object item : this.getModel().getItems(0, this.getModel().getRows())) {
            if (!items.contains(item)) continue;
            if (on) {
                this.addToSelection(item);
                continue;
            }
            this.removeFromSelection(item);
        }
        if (this.isBuilt()) {
            this.forceRebuild();
            if (this.getSelectionChangedHandler() != null) {
                this.getSelectionChangedHandler().onValueChanged(this);
            }
        }
    }

    public void setDisabled(List<T> items, boolean disable) throws Exception {
        if (this.m_disabledRows == Collections.EMPTY_LIST) {
            this.m_disabledRows = new ArrayList<T>();
        }
        for (Object item : this.getModel().getItems(0, this.getModel().getRows())) {
            for (T toDisable : items) {
                if (!MetaManager.areObjectsEqual(item, toDisable)) continue;
                if (disable && !this.m_disabledRows.contains(item)) {
                    this.m_disabledRows.add(item);
                }
                if (disable || !this.m_disabledRows.contains(item)) continue;
                this.m_disabledRows.remove(item);
            }
        }
        if (this.isBuilt()) {
            this.forceRebuild();
        }
    }

    public void setAllDisabled(boolean allDisabled) throws Exception {
        if (this.m_disabledRows == Collections.EMPTY_LIST) {
            this.m_disabledRows = new ArrayList<T>();
        }
        this.m_disabledRows.clear();
        if (allDisabled) {
            this.m_disabledRows.addAll(this.getModel().getItems(0, this.getModel().getRows()));
        }
        if (this.isBuilt()) {
            this.forceRebuild();
        }
    }

    private void addToSelection(T item) {
        if (this.m_selectedRows == Collections.EMPTY_LIST) {
            this.m_selectedRows = new ArrayList<T>();
        }
        if (this.getSelectedIndexOf(item) == -1) {
            this.m_selectedRows.add(item);
        }
    }

    private void removeFromSelection(T item) {
        int index;
        if (this.m_selectedRows == Collections.EMPTY_LIST) {
            this.m_selectedRows = new ArrayList<T>();
        }
        if ((index = this.getSelectedIndexOf(item)) > -1) {
            this.m_selectedRows.remove(index);
        }
    }

    public void selectAll() throws Exception {
        if (this.m_selectedRows == Collections.EMPTY_LIST) {
            this.m_selectedRows = new ArrayList<T>();
        }
        this.m_selectedRows.clear();
        for (Object item : this.getModel().getItems(0, this.getModel().getRows())) {
            if (this.getDisabledIndexOf(item) >= 0) continue;
            this.m_selectedRows.add(item);
        }
        if (this.isBuilt()) {
            this.forceRebuild();
        }
        if (this.getSelectionChangedHandler() != null) {
            this.getSelectionChangedHandler().onValueChanged(this);
        }
    }

    public void deselectAll() throws Exception {
        boolean notifyChange;
        boolean bl = notifyChange = this.m_selectedRows.size() > 0;
        if (this.m_selectedRows != Collections.EMPTY_LIST) {
            this.m_selectedRows.clear();
        }
        if (this.isBuilt()) {
            this.forceRebuild();
        }
        if (notifyChange && this.getSelectionChangedHandler() != null) {
            this.getSelectionChangedHandler().onValueChanged(this);
        }
    }

    @Override
    protected void renderHeader(@Nonnull HeaderContainer<T> hc) throws Exception {
        hc.add(this.getSelectionColTitle() == null ? Msgs.BUNDLE.getString("ui.mlui.col.ttl") : this.getSelectionColTitle());
        this.getRowRenderer().renderHeader(this, hc);
    }

    @Override
    void internalRenderRow(@Nonnull TR tr, @Nonnull ColumnContainer<T> cc, int index, @Nonnull T value) throws Exception {
        TD selectionCell = new TD();
        boolean isDisabled = this.getDisabledIndexOf(value) > -1;
        Checkbox b = new Checkbox();
        b.setChecked(this.getSelectedIndexOf(value) > -1);
        if (!isDisabled) {
            b.setClicked(new IClicked<Checkbox>(){

                @Override
                public void clicked(@Nonnull Checkbox ckb) throws Exception {
                    ckb.setChecked(!ckb.isChecked());
                    ckb.setChecked(!ckb.isChecked());
                    CheckBoxDataTable.this.handleSelectionChanged(ckb.isChecked(), ckb.getUserObject());
                }
            });
        } else {
            b.setDisabled(isDisabled);
        }
        b.setUserObject(value);
        selectionCell.add(b);
        tr.add(selectionCell);
        tr.setUserObject(b);
        if (this.m_readOnly) {
            b.setReadOnly(true);
            if (this.m_readOnlyTitle != null) {
                b.setTitle(this.m_readOnlyTitle);
            }
        } else if (!this.m_disableOnRowClick && !isDisabled) {
            tr.addCssClass("ui-rowsel");
            tr.setClicked(new IClicked<TR>(){

                @Override
                public void clicked(@Nonnull TR row) throws Exception {
                    Object userObject = row.getUserObject();
                    if (userObject instanceof Checkbox) {
                        Checkbox ckb = (Checkbox)userObject;
                        if (null == ckb) {
                            throw new IllegalStateException("Missing checkbox in userObject?");
                        }
                        ckb.setChecked(!ckb.isChecked());
                        CheckBoxDataTable.this.handleSelectionChanged(ckb.isChecked(), ckb.getUserObject());
                    }
                }
            });
        }
        tr.add(selectionCell);
        this.getRowRenderer().renderRow(this, cc, index, value);
    }

    private int getSelectedIndexOf(T value) {
        int index = 0;
        for (T item : this.m_selectedRows) {
            if (MetaManager.areObjectsEqual(value, item)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    private int getDisabledIndexOf(T value) {
        int index = 0;
        for (T item : this.m_disabledRows) {
            if (MetaManager.areObjectsEqual(value, item)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public String getSelectionColTitle() {
        return this.m_selectionColTitle;
    }

    public void setSelectionColTitle(String selectionColTitle) {
        this.m_selectionColTitle = selectionColTitle;
    }

    public List<T> getSelectedRows() {
        return this.m_selectedRows;
    }

    public List<T> getDisabledRows() {
        return this.m_disabledRows;
    }

    public List<T> getUnselectedRows() throws Exception {
        ArrayList unselected = new ArrayList();
        for (Object item : this.getModel().getItems(0, this.getModel().getRows())) {
            if (this.m_selectedRows.contains(item)) continue;
            unselected.add(item);
        }
        return unselected;
    }

    public void setSelectionChangedHandler(IValueChanged<CheckBoxDataTable<T>> handler) {
        this.m_selectionChangedHandler = handler;
    }

    public IValueChanged<CheckBoxDataTable<T>> getSelectionChangedHandler() {
        return this.m_selectionChangedHandler;
    }

    public boolean isReadOnly() {
        return this.m_readOnly;
    }

    public void setReadOnly(boolean ro) {
        if (this.m_readOnly != ro) {
            this.m_readOnly = ro;
            if (this.isBuilt()) {
                this.forceRebuild();
            }
        }
    }

    public String getReadOnlyTitle() {
        return this.m_readOnlyTitle;
    }

    public void setReadOnlyTitle(String readOnlyTitle) {
        if (this.m_readOnlyTitle != readOnlyTitle) {
            this.m_readOnlyTitle = readOnlyTitle;
            if (this.isBuilt()) {
                this.forceRebuild();
            }
        }
    }

    public boolean isDisableOnRowClick() {
        return this.m_disableOnRowClick;
    }

    public void setDisableOnRowClick(boolean disableOnRowClick) {
        this.m_disableOnRowClick = disableOnRowClick;
    }
}

