/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.tbl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.tbl.RowButtonContainer;
import to.etc.domui.component.tbl.TableModelTableBase;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.dom.html.TD;
import to.etc.domui.dom.html.TR;
import to.etc.domui.dom.html.TextNode;

public class ColumnContainer<T> {
    @Nonnull
    private final TableModelTableBase<T> m_table;
    @Nullable
    private RowButtonContainer m_rowButtonContainer;
    @Nullable
    private TR m_tr;

    public ColumnContainer(@Nonnull TableModelTableBase<T> table) {
        this.m_table = table;
    }

    public void setParent(@Nonnull TR p) {
        this.m_tr = p;
    }

    @Nonnull
    public TableModelTableBase<T> getTable() {
        return this.m_table;
    }

    @Nonnull
    public TD add(NodeBase columnContent) {
        TD td = new TD();
        this.getTR().add(td);
        if (columnContent != null) {
            td.add(columnContent);
        }
        return td;
    }

    @Nonnull
    public TD add(@Nullable String txt) {
        return this.add(new TextNode(txt));
    }

    @Nonnull
    public TR getTR() {
        if (null != this.m_tr) {
            return this.m_tr;
        }
        throw new IllegalStateException("Row not set.");
    }

    @Nonnull
    public RowButtonContainer getRowButtonContainer() {
        RowButtonContainer c = this.m_rowButtonContainer;
        if (c == null) {
            c = this.m_rowButtonContainer = new RowButtonContainer();
        }
        return c;
    }
}

