/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.tbl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.meta.NumericPresentation;
import to.etc.domui.component.meta.PropertyMetaModel;
import to.etc.domui.component.meta.SortableType;
import to.etc.domui.component.meta.YesNoType;
import to.etc.domui.component.tbl.ColumnList;
import to.etc.domui.component.tbl.ICellClicked;
import to.etc.domui.component.tbl.IRowControlFactory;
import to.etc.domui.component.tbl.ISortHelper;
import to.etc.domui.converter.ConverterRegistry;
import to.etc.domui.converter.IConverter;
import to.etc.domui.dom.css.TextAlign;
import to.etc.domui.util.INodeContentRenderer;

public final class ColumnDef<I, T> {
    @Nonnull
    private final Class<T> m_actualClass;
    @Nullable
    private String m_columnLabel;
    @Nonnull
    private final ColumnList<I> m_defList;
    @Nonnull
    private final Class<T> m_columnType;
    @Nonnull
    private SortableType m_sortable = SortableType.UNKNOWN;
    @Nullable
    private ISortHelper<?> m_sortHelper;
    @Nullable
    private String m_sortProperty;
    @Nullable
    private String m_width = "1%";
    @Nullable
    private String m_propertyName;
    @Nullable
    private String m_cssClass;
    @Nullable
    private String m_headerCssClass;
    @Deprecated
    private int m_displayLength;
    private boolean m_nowrap = true;
    @Nullable
    private PropertyMetaModel<T> m_propertyMetaModel;
    @Nonnull
    private NumericPresentation m_numericPresentation = NumericPresentation.UNKNOWN;
    @Nullable
    private TextAlign m_align;
    @Nullable
    private INodeContentRenderer<T> m_contentRenderer;
    @Nullable
    private IConverter<T> m_converter;
    @Nullable
    private ICellClicked<?> m_cellClicked;
    @Nullable
    private String m_renderHint;
    private boolean m_editable;
    private IRowControlFactory<I> m_controlFactory;

    <X> ColumnDef(@Nonnull ColumnList<I> cdl, @Nonnull Class<T> valueClass) {
        this.m_actualClass = valueClass;
        this.m_columnType = valueClass;
        this.m_defList = cdl;
    }

    ColumnDef(@Nonnull ColumnList<I> cdl, @Nonnull PropertyMetaModel<T> pmm) {
        this.m_actualClass = pmm.getActualType();
        this.m_defList = cdl;
        this.m_columnType = pmm.getActualType();
        this.label(pmm.getDefaultLabel());
        this.m_propertyMetaModel = pmm;
        this.setSortable(pmm.getSortable());
        this.setPropertyName(pmm.getName());
        this.numeric(pmm.getNumericPresentation());
        if (pmm.getNowrap() == YesNoType.YES) {
            this.nowrap();
        }
        this.converter(ConverterRegistry.findBestConverter(pmm));
    }

    @Nonnull
    public Class<T> getActualClass() {
        return this.m_actualClass;
    }

    @Nullable
    public PropertyMetaModel<T> getPropertyMetaModel() {
        return this.m_propertyMetaModel;
    }

    @Nullable
    public String getColumnLabel() {
        return this.m_columnLabel;
    }

    @Nullable
    public IConverter<T> getConverter() {
        return this.m_converter;
    }

    @Nonnull
    public ColumnDef<I, T> editable() {
        if (this.m_propertyMetaModel == null) {
            throw new IllegalStateException("Cannot edit a row instance");
        }
        this.m_editable = true;
        return this;
    }

    @Nonnull
    public ColumnDef<I, T> property(@Nonnull String name) {
        if (this.m_propertyName != null) {
            throw new IllegalStateException("The property name is already defined.");
        }
        this.m_propertyName = name;
        return this;
    }

    public boolean isEditable() {
        return this.m_editable;
    }

    public <R> T getColumnValue(@Nonnull R instance) throws Exception {
        PropertyMetaModel<T> pmm = this.m_propertyMetaModel;
        if (pmm == null) {
            return (T)instance;
        }
        return pmm.getValue(instance);
    }

    @Nonnull
    public Class<T> getColumnType() {
        return this.m_columnType;
    }

    @Nonnull
    public SortableType getSortable() {
        return this.m_sortable;
    }

    @Nullable
    public String getWidth() {
        return this.m_width;
    }

    @Nullable
    public String getPropertyName() {
        return this.m_propertyName;
    }

    public void setPropertyName(@Nullable String propertyName) {
        this.m_propertyName = propertyName;
    }

    @Nullable
    public INodeContentRenderer<T> getContentRenderer() {
        return this.m_contentRenderer;
    }

    @Nullable
    public String getCssClass() {
        return this.m_cssClass;
    }

    @Nullable
    public String getHeaderCssClass() {
        return this.m_headerCssClass;
    }

    @Deprecated
    public int getDisplayLength() {
        return this.m_displayLength;
    }

    public boolean isNowrap() {
        return this.m_nowrap;
    }

    @Nullable
    public ICellClicked<?> getCellClicked() {
        return this.m_cellClicked;
    }

    @Nonnull
    public NumericPresentation getNumericPresentation() {
        return this.m_numericPresentation;
    }

    @Nullable
    public TextAlign getAlign() {
        return this.m_align;
    }

    @Nullable
    public String getRenderHint() {
        return this.m_renderHint;
    }

    @Nullable
    public ISortHelper<?> getSortHelper() {
        return this.m_sortHelper;
    }

    @Nullable
    public String getSortProperty() {
        return this.m_sortProperty;
    }

    public void setSortable(@Nonnull SortableType sortable) {
        this.m_sortable = sortable == null ? SortableType.UNKNOWN : sortable;
    }

    @Nonnull
    public String toString() {
        return "ColumnDef[" + this.getPropertyName() + ", type=" + this.getColumnType() + ", lbl=" + this.getColumnLabel() + "]";
    }

    @Nonnull
    public ColumnDef<I, T> label(@Nullable String columnLabel) {
        this.m_columnLabel = columnLabel;
        return this;
    }

    @Nonnull
    public ColumnDef<I, T> align(@Nonnull TextAlign align) {
        this.m_align = align;
        return this;
    }

    @Nonnull
    public ColumnDef<I, T> cellClicked(@Nullable ICellClicked<?> ck) {
        this.m_cellClicked = ck;
        return this;
    }

    @Nonnull
    public ColumnDef<I, T> renderer(@Nullable INodeContentRenderer<T> cr) {
        this.m_contentRenderer = cr;
        return this;
    }

    @Nonnull
    public ColumnDef<I, T> css(@Nonnull String css) {
        this.m_cssClass = css;
        return this;
    }

    @Nonnull
    public ColumnDef<I, T> cssHeader(@Nonnull String css) {
        this.m_headerCssClass = css;
        return this;
    }

    @Nonnull
    public ColumnDef<I, T> wrap() {
        this.m_nowrap = false;
        return this;
    }

    @Nonnull
    public ColumnDef<I, T> nowrap() {
        this.m_nowrap = true;
        return this;
    }

    @Nonnull
    public ColumnDef<I, T> numeric(@Nonnull NumericPresentation np) {
        this.m_numericPresentation = np;
        return this;
    }

    @Nonnull
    public ColumnDef<I, T> hint(@Nonnull String hint) {
        this.m_renderHint = hint;
        return this;
    }

    @Nonnull
    public ColumnDef<I, T> ascending() {
        this.setSortable(SortableType.SORTABLE_ASC);
        return this;
    }

    @Nonnull
    public ColumnDef<I, T> descending() {
        this.setSortable(SortableType.SORTABLE_DESC);
        return this;
    }

    @Nonnull
    public ColumnDef<I, T> sortdefault() {
        this.m_defList.setSortColumn(this);
        return this;
    }

    @Nonnull
    public ColumnDef<I, T> sort(@Nonnull ISortHelper<?> sh) {
        this.m_sortHelper = sh;
        if (this.m_sortable == SortableType.UNKNOWN) {
            this.m_sortable = SortableType.SORTABLE_ASC;
        }
        return this;
    }

    @Nonnull
    public ColumnDef<I, T> sort(@Nonnull String propertyName) {
        this.m_sortProperty = propertyName;
        return this;
    }

    @Nonnull
    public ColumnDef<I, T> width(@Nullable String w) {
        this.m_width = w;
        return this;
    }

    @Nonnull
    public ColumnDef<I, T> converter(@Nullable IConverter<T> converter) {
        this.m_converter = converter;
        return this;
    }

    @Nonnull
    public ColumnDef<I, T> factory(@Nonnull IRowControlFactory<I> factory) {
        this.m_controlFactory = factory;
        return this;
    }

    @Nullable
    public IRowControlFactory<I> getControlFactory() {
        return this.m_controlFactory;
    }
}

