/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.tbl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.meta.ClassMetaModel;
import to.etc.domui.component.meta.NumericPresentation;
import to.etc.domui.component.meta.PropertyMetaModel;
import to.etc.domui.component.meta.SortableType;
import to.etc.domui.component.meta.impl.DisplayPropertyMetaModel;
import to.etc.domui.component.meta.impl.ExpandedDisplayProperty;
import to.etc.domui.component.tbl.ExpandedColumnDef;
import to.etc.domui.component.tbl.ICellClicked;
import to.etc.domui.component.tbl.ISortHelper;
import to.etc.domui.component.tbl.SimpleColumnDef;
import to.etc.domui.converter.ConverterRegistry;
import to.etc.domui.converter.IConverter;
import to.etc.domui.server.DomApplication;
import to.etc.domui.util.DomUtil;
import to.etc.domui.util.INodeContentRenderer;
import to.etc.util.StringTool;
import to.etc.webapp.annotations.GProperty;

public final class ColumnDefList<T>
implements Iterable<SimpleColumnDef<?>> {
    public static final String NUMERIC_CSS_CLASS = "ui-numeric";
    @Nonnull
    private final ClassMetaModel m_metaModel;
    @Nonnull
    private final List<SimpleColumnDef<?>> m_columnList = new ArrayList();
    @Nullable
    private SimpleColumnDef<?> m_sortColumn;
    @Nonnull
    private final Class<T> m_rootClass;

    public ColumnDefList(@Nonnull Class<T> rootClass, @Nonnull ClassMetaModel cmm) {
        this.m_rootClass = rootClass;
        this.m_metaModel = cmm;
    }

    public int size() {
        return this.m_columnList.size();
    }

    public void add(@Nonnull SimpleColumnDef<?> cd) {
        if (null == cd) {
            throw new IllegalArgumentException("Cannot be null");
        }
        this.m_columnList.add(cd);
    }

    @Nonnull
    private ClassMetaModel model() {
        return this.m_metaModel;
    }

    @Nonnull
    public SimpleColumnDef<?> get(int ix) {
        if (ix < 0 || ix >= this.m_columnList.size()) {
            throw new IndexOutOfBoundsException("Column " + ix + " does not exist");
        }
        return this.m_columnList.get(ix);
    }

    @Nullable
    public SimpleColumnDef<?> findColumn(@Nonnull String propertyName) {
        for (SimpleColumnDef<?> scd : this.m_columnList) {
            if (!DomUtil.isEqual((Object)scd.getPropertyName(), (Object)propertyName)) continue;
            return scd;
        }
        return null;
    }

    public void setDefaultSortColumn(@Nullable String sort) {
        if (null == sort) {
            this.m_sortColumn = null;
        } else {
            SimpleColumnDef<?> scd = this.findColumn(sort);
            if (null != scd) {
                this.setSortColumn(scd);
            }
        }
    }

    public void setSortColumn(@Nullable SimpleColumnDef<?> cd) {
        this.m_sortColumn = cd;
    }

    @Deprecated
    public <R> void addColumns(Object ... cols) {
        if (cols == null || cols.length == 0) {
            throw new IllegalArgumentException("The list-of-columns is empty or null; I need at least one column to continue.");
        }
        String property = null;
        String width = null;
        IConverter conv = null;
        Class convclz = null;
        String caption = null;
        String cssclass = null;
        Boolean nowrap = null;
        SortableType sort = null;
        ISortHelper sortHelper = null;
        boolean defaultsort = false;
        INodeContentRenderer nodeRenderer = null;
        Class nrclass = null;
        ICellClicked clickHandler = null;
        for (Object val : cols) {
            if (property == null) {
                if (!(val instanceof String)) {
                    throw new IllegalArgumentException("Expecting a 'property' path expression, not a " + val);
                }
                property = (String)val;
                continue;
            }
            if ("-NOWRAP" == val) {
                nowrap = Boolean.TRUE;
                continue;
            }
            if ("-WRAP" == val) {
                nowrap = Boolean.FALSE;
                continue;
            }
            if ("-DSORT" == val) {
                defaultsort = true;
                continue;
            }
            if (val instanceof String) {
                String s = (String)val;
                char c = s.length() == 0 ? (char)'\u0000' : s.charAt(0);
                switch (c) {
                    default: {
                        if (!Character.isLetter(c)) {
                            throw new IllegalArgumentException("Unexpected 'string' parameter: '" + s + "'");
                        }
                    }
                    case '\u0000': {
                        this.internalAddProperty(property, width, conv, convclz, caption, cssclass, nodeRenderer, nrclass, nowrap, sort, clickHandler, defaultsort, sortHelper);
                        property = s;
                        width = null;
                        conv = null;
                        convclz = null;
                        caption = null;
                        cssclass = null;
                        nodeRenderer = null;
                        nrclass = null;
                        nowrap = null;
                        sort = null;
                        defaultsort = false;
                        sortHelper = null;
                        break;
                    }
                    case '%': {
                        width = s.substring(1) + "%";
                        break;
                    }
                    case '$': {
                        cssclass = s.substring(1);
                        break;
                    }
                    case '^': {
                        caption = DomUtil.nlsLabel(s.substring(1));
                        break;
                    }
                }
                continue;
            }
            if (val instanceof IConverter) {
                conv = (IConverter)val;
                continue;
            }
            if (val instanceof INodeContentRenderer) {
                nodeRenderer = (INodeContentRenderer)val;
                continue;
            }
            if (val instanceof ICellClicked) {
                clickHandler = (ICellClicked)val;
                continue;
            }
            if (val instanceof ISortHelper) {
                sortHelper = (ISortHelper)val;
                if (sort != null) continue;
                sort = SortableType.SORTABLE_ASC;
                continue;
            }
            if (val instanceof Class) {
                Class c = (Class)val;
                if (INodeContentRenderer.class.isAssignableFrom(c)) {
                    nrclass = c;
                    continue;
                }
                if (IConverter.class.isAssignableFrom(c)) {
                    convclz = c;
                    continue;
                }
                throw new IllegalArgumentException("Invalid 'class' argument: " + c);
            }
            if (val instanceof SortableType) {
                sort = (SortableType)((Object)val);
                continue;
            }
            throw new IllegalArgumentException("Invalid column modifier argument: " + val);
        }
        this.internalAddProperty(property, width, conv, convclz, caption, cssclass, nodeRenderer, nrclass, nowrap, sort, clickHandler, defaultsort, sortHelper);
    }

    private static INodeContentRenderer<?> tryRenderer(INodeContentRenderer<?> nodeRenderer, Class<?> nrclass) {
        if (nodeRenderer != null) {
            if (nrclass != null) {
                throw new IllegalArgumentException("Both a NodeContentRenderer instance AND a class specified: " + nodeRenderer + " + " + nrclass);
            }
            return nodeRenderer;
        }
        if (nrclass == null) {
            return null;
        }
        return (INodeContentRenderer)DomApplication.get().createInstance(nrclass, new Object[0]);
    }

    private static <R> IConverter<R> tryConverter(Class<R> cclz, IConverter<R> ins) {
        if (cclz != null) {
            if (ins != null) {
                throw new IllegalArgumentException("Both a IConverter class AND an instance specified: " + cclz + " and " + ins);
            }
            return ConverterRegistry.getConverterInstance(cclz);
        }
        return ins;
    }

    private <R> void internalAddProperty(String property, String width, IConverter<R> conv, Class<R> convclz, String caption, String cssclass, INodeContentRenderer<?> nodeRenderer, Class<?> nrclass, Boolean nowrap, SortableType sort, ICellClicked<?> clickHandler, boolean defaultsort, ISortHelper<?> sortHelper) {
        if (property == null) {
            throw new IllegalStateException("? property name is empty?!");
        }
        if (property.length() == 0) {
            SimpleColumnDef<T> cd = new SimpleColumnDef<T>(this, this.m_rootClass);
            this.add(cd);
            cd.setWidth(width);
            cd.setCssClass(cssclass);
            if (NUMERIC_CSS_CLASS.equals(cssclass)) {
                cd.setHeaderCssClass(cssclass);
            }
            cd.setNowrap(nowrap);
            cd.setColumnLabel(caption);
            sort = this.defineClassProperty(conv, convclz, nodeRenderer, nrclass, sort, clickHandler, defaultsort, sortHelper, cd);
            return;
        }
        PropertyMetaModel<?> pmm = this.m_metaModel.findProperty(property);
        if (pmm == null) {
            throw new IllegalArgumentException("Undefined property path: '" + property + "' in classModel=" + this.m_metaModel);
        }
        INodeContentRenderer<?> ncr = ColumnDefList.tryRenderer(nodeRenderer, nrclass);
        if (ncr != null) {
            this.defineRendererProperty(property, width, conv, convclz, caption, cssclass, nodeRenderer, nrclass, nowrap, sort, clickHandler, defaultsort, sortHelper, pmm);
            return;
        }
        ExpandedDisplayProperty<?> xdpt = ExpandedDisplayProperty.expandProperty(pmm);
        ArrayList flat = new ArrayList();
        ExpandedDisplayProperty.flatten(flat, xdpt);
        if (flat.size() > 1) {
            if (width != null) {
                throw new IllegalStateException("Cannot apply a WIDTH to a multicolumn property: " + pmm);
            }
            if (conv != null || convclz != null) {
                throw new IllegalStateException("Cannot apply an IConverter to a multicolumn property: " + pmm);
            }
            if (caption != null) {
                throw new IllegalStateException("Cannot apply a caption to a multicolumn property: " + pmm);
            }
        }
        for (ExpandedDisplayProperty expandedDisplayProperty : flat) {
            if (expandedDisplayProperty.getName() == null) {
                throw new IllegalStateException("All columns MUST have some name");
            }
            defaultsort = this.defineFromExpandedItem(width, conv, convclz, caption, cssclass, nowrap, sort, clickHandler, defaultsort, sortHelper, expandedDisplayProperty);
        }
    }

    private <V, R> boolean defineFromExpandedItem(String width, IConverter<R> conv, Class<R> convclz, String caption, String cssclass, Boolean nowrap, SortableType sort, ICellClicked<?> clickHandler, boolean defaultsort, ISortHelper<?> sortHelper, ExpandedDisplayProperty<V> xdp) {
        if (xdp.getName() == null) {
            throw new IllegalStateException("All columns MUST have some name");
        }
        SimpleColumnDef<V> scd = new SimpleColumnDef<V>(this, xdp);
        this.add(scd);
        scd.setDisplayLength(xdp.getDisplayLength());
        if (width != null) {
            scd.setWidth(width);
        }
        if (cssclass != null) {
            scd.setCssClass(cssclass);
        }
        if (sort != null) {
            scd.setSortable(sort);
        } else {
            scd.setSortable(xdp.getSortable());
        }
        scd.setSortHelper(sortHelper);
        if (defaultsort) {
            this.setSortColumn(scd);
        }
        defaultsort = false;
        scd.setColumnLabel(caption == null ? xdp.getDefaultLabel() : caption);
        scd.setValueTransformer(xdp);
        scd.setPresentationConverter(ColumnDefList.tryConverter(convclz, conv));
        if (scd.getPresentationConverter() == null && xdp.getConverter() != null) {
            scd.setPresentationConverter(xdp.getConverter());
        }
        if (scd.getPresentationConverter() == null && xdp.getActualType() != String.class) {
            IConverter<V> c = ConverterRegistry.getConverter(xdp.getActualType(), xdp);
            scd.setPresentationConverter(c);
        }
        scd.setPropertyName(xdp.getName());
        scd.setNowrap(nowrap);
        scd.setNumericPresentation(xdp.getNumericPresentation());
        if (scd.getNumericPresentation() != null && scd.getNumericPresentation() != NumericPresentation.UNKNOWN) {
            scd.setCssClass(NUMERIC_CSS_CLASS);
            scd.setHeaderCssClass(NUMERIC_CSS_CLASS);
        }
        if (clickHandler != null) {
            scd.setCellClicked(clickHandler);
        }
        return defaultsort;
    }

    private <V, R> void defineRendererProperty(String property, String width, IConverter<R> conv, Class<R> convclz, String caption, String cssclass, INodeContentRenderer<?> nodeRenderer, Class<?> nrclass, Boolean nowrap, SortableType sort, ICellClicked<?> clickHandler, boolean defaultsort, ISortHelper<?> sortHelper, PropertyMetaModel<V> pmm) {
        SimpleColumnDef<V> cd = new SimpleColumnDef<V>(this, pmm);
        this.add(cd);
        cd.setValueTransformer(pmm);
        cd.setColumnLabel(caption == null ? pmm.getDefaultLabel() : caption);
        cd.setContentRenderer(ColumnDefList.tryRenderer(nodeRenderer, nrclass));
        cd.setPropertyName(property);
        cd.setPresentationConverter(ColumnDefList.tryConverter(convclz, conv));
        cd.setWidth(width);
        cd.setCssClass(cssclass);
        cd.setNowrap(nowrap);
        cd.setDisplayLength(pmm.getDisplayLength());
        if (sort != null) {
            cd.setSortable(sort);
            cd.setSortHelper(sortHelper);
            if (defaultsort) {
                this.setSortColumn(cd);
            }
        }
        if (pmm.getNumericPresentation() != null && pmm.getNumericPresentation() != NumericPresentation.UNKNOWN) {
            cd.setCssClass(NUMERIC_CSS_CLASS);
            cd.setHeaderCssClass(NUMERIC_CSS_CLASS);
        }
        if (clickHandler != null) {
            cd.setCellClicked(clickHandler);
        }
    }

    private <V, R> SortableType defineClassProperty(IConverter<R> conv, Class<R> convclz, INodeContentRenderer<?> nodeRenderer, Class<?> nrclass, SortableType sort, ICellClicked<?> clickHandler, boolean defaultsort, ISortHelper<?> sortHelper, SimpleColumnDef<V> cd) {
        cd.setContentRenderer(ColumnDefList.tryRenderer(nodeRenderer, nrclass));
        cd.setPropertyName("");
        cd.setPresentationConverter(ColumnDefList.tryConverter(convclz, conv));
        if (sort != null && (sort == SortableType.SORTABLE_ASC || sort == SortableType.SORTABLE_DESC) && sortHelper == null) {
            System.out.println("ERROR: Attempt to define column without property name as sortable");
        } else {
            if (sort == null) {
                sort = SortableType.UNKNOWN;
            }
            cd.setSortable(sort);
            cd.setSortHelper(sortHelper);
            if (defaultsort) {
                this.setSortColumn(cd);
            }
        }
        if (clickHandler != null) {
            cd.setCellClicked(clickHandler);
        }
        return sort;
    }

    public void addDefaultColumns() {
        List<DisplayPropertyMetaModel> dpl = this.m_metaModel.getTableDisplayProperties();
        if (dpl.size() == 0) {
            throw new IllegalStateException("The list-of-columns to show is empty, and the class " + this.m_metaModel.getActualClass() + " has no @MetaObject definition defining a set of columns as default table columns, so there.");
        }
        List<ExpandedDisplayProperty<?>> xdpl = ExpandedDisplayProperty.expandDisplayProperties(dpl, this.m_metaModel, null);
        xdpl = ExpandedDisplayProperty.flatten(xdpl);
        for (ExpandedDisplayProperty<?> xdp : xdpl) {
            this.addExpandedDisplayProp(xdp);
        }
    }

    @Nonnull
    private <V> SimpleColumnDef<V> addExpandedDisplayProp(@Nonnull ExpandedDisplayProperty<V> xdp) {
        SimpleColumnDef<V> scd = new SimpleColumnDef<V>(this, xdp);
        if (scd.getNumericPresentation() != null && scd.getNumericPresentation() != NumericPresentation.UNKNOWN) {
            scd.setCssClass(NUMERIC_CSS_CLASS);
            scd.setHeaderCssClass(NUMERIC_CSS_CLASS);
        }
        this.m_columnList.add(scd);
        return scd;
    }

    public void assignPercentages() {
        int totpct = 0;
        int totpix = 0;
        int ntoass = 0;
        int totdw = 0;
        for (SimpleColumnDef<?> scd : this.m_columnList) {
            int w;
            String cwidth = scd.getWidth();
            if (cwidth == null || cwidth.length() == 0) {
                ++ntoass;
                totdw += scd.getDisplayLength();
                continue;
            }
            String s = cwidth.trim();
            if (s.endsWith("%")) {
                w = StringTool.strToInt((String)s.substring(0, s.length() - 1).trim(), (int)-1);
                if (w == -1) {
                    throw new IllegalArgumentException("Invalid width percentage: " + s + " for presentation column " + scd.getPropertyName());
                }
                totpct += w;
                continue;
            }
            w = StringTool.strToInt((String)s, (int)-1);
            if (w == -1) {
                throw new IllegalArgumentException("Invalid width #pixels: " + s + " for presentation column " + scd.getPropertyName());
            }
            totpix += w;
        }
        int pixwidth = 1280;
        if (ntoass > 0 && totpct < 100 && totpix < 1280) {
            int pctleft = 100 - totpct;
            if (pctleft == 100 && totpix > 0) {
                pctleft = 100 * (1280 - totpix) / 1280;
            }
            for (SimpleColumnDef<?> scd : this.m_columnList) {
                String width = scd.getWidth();
                if (width != null && width.length() != 0) continue;
                double fact = (double)scd.getDisplayLength() / (double)totdw;
                int pct = (int)(fact * (double)pctleft + 0.5);
                pctleft -= pct;
                totdw -= scd.getDisplayLength();
                scd.setWidth(pct + "%");
            }
        }
    }

    @Override
    @Nonnull
    public Iterator<SimpleColumnDef<?>> iterator() {
        return this.m_columnList.iterator();
    }

    public int indexOf(@Nonnull SimpleColumnDef<?> scd) {
        return this.m_columnList.indexOf(scd);
    }

    @Nullable
    public SimpleColumnDef<?> getSortColumn() {
        return this.m_sortColumn;
    }

    @Nonnull
    public <V> SimpleColumnDef<V> column(@Nonnull Class<V> type, @Nonnull @GProperty String property) {
        PropertyMetaModel<?> pmm = this.model().getProperty(property);
        return this.createColumnDef(pmm);
    }

    @Nonnull
    private <V> SimpleColumnDef<V> createColumnDef(@Nonnull PropertyMetaModel<V> pmm) {
        SimpleColumnDef<V> scd = new SimpleColumnDef<V>(this, pmm);
        scd.setNowrap(Boolean.TRUE);
        this.add(scd);
        return scd;
    }

    @Nonnull
    public SimpleColumnDef<?> column(@Nonnull @GProperty String property) {
        PropertyMetaModel<?> pmm = this.model().getProperty(property);
        return this.createColumnDef(pmm);
    }

    @Nonnull
    public SimpleColumnDef<T> column() {
        SimpleColumnDef<T> scd = new SimpleColumnDef<T>(this, this.m_rootClass);
        this.add(scd);
        scd.setNowrap(Boolean.TRUE);
        return scd;
    }

    @Nonnull
    public <V> ExpandedColumnDef<V> expand(@Nonnull Class<V> clz, @Nonnull @GProperty String property) {
        PropertyMetaModel<?> pmm = this.model().getProperty(property);
        return this.createExpandedColumnDef(pmm);
    }

    @Nonnull
    public ExpandedColumnDef<?> expand(@Nonnull @GProperty String property) {
        PropertyMetaModel<?> pmm = this.model().getProperty(property);
        return this.createExpandedColumnDef(pmm);
    }

    @Nonnull
    private <V> ExpandedColumnDef<V> createExpandedColumnDef(@Nonnull PropertyMetaModel<V> pmm) {
        ExpandedDisplayProperty<?> xdpt = ExpandedDisplayProperty.expandProperty(pmm);
        ArrayList flat = new ArrayList();
        ExpandedDisplayProperty.flatten(flat, xdpt);
        if (flat.size() == 0) {
            throw new IllegalStateException("Expansion for property " + pmm + " resulted in 0 columns!?");
        }
        ExpandedColumnDef<V> xcd = new ExpandedColumnDef<V>(this, pmm.getActualType(), pmm.getName());
        for (ExpandedDisplayProperty expandedDisplayProperty : flat) {
            if (expandedDisplayProperty.getName() == null) {
                throw new IllegalStateException("All columns MUST have some name");
            }
            SimpleColumnDef<V> ccd = this.addExpandedDisplayProp(expandedDisplayProperty);
            xcd.addExpanded(ccd);
        }
        return xcd;
    }
}

