/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.tbl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.meta.ClassMetaModel;
import to.etc.domui.component.meta.NumericPresentation;
import to.etc.domui.component.meta.PropertyMetaModel;
import to.etc.domui.component.meta.SortableType;
import to.etc.domui.component.meta.impl.DisplayPropertyMetaModel;
import to.etc.domui.component.meta.impl.ExpandedDisplayProperty;
import to.etc.domui.component.tbl.ColumnDef;
import to.etc.domui.util.DomUtil;
import to.etc.util.StringTool;
import to.etc.webapp.annotations.GProperty;

public class ColumnList<T>
implements Iterable<ColumnDef<T, ?>> {
    @Nonnull
    private final ClassMetaModel m_metaModel;
    @Nonnull
    private final List<ColumnDef<T, ?>> m_columnList = new ArrayList();
    @Nullable
    private ColumnDef<T, ?> m_sortColumn;
    private boolean m_sortDescending;
    @Nonnull
    private final Class<T> m_actualClass;

    public ColumnList(@Nonnull Class<T> rootClass, @Nonnull ClassMetaModel cmm) {
        this.m_actualClass = rootClass;
        this.m_metaModel = cmm;
        this.m_sortDescending = cmm.getDefaultSortDirection() == SortableType.SORTABLE_DESC;
    }

    public int size() {
        return this.m_columnList.size();
    }

    public void add(@Nonnull ColumnDef<T, ?> cd) {
        if (null == cd) {
            throw new IllegalArgumentException("Cannot be null");
        }
        this.m_columnList.add(cd);
    }

    @Nonnull
    private ClassMetaModel model() {
        return this.m_metaModel;
    }

    @Nonnull
    public ColumnDef<T, ?> get(int ix) {
        if (ix < 0 || ix >= this.m_columnList.size()) {
            throw new IndexOutOfBoundsException("Column " + ix + " does not exist");
        }
        return this.m_columnList.get(ix);
    }

    public void setDefaultSortColumn(@Nullable String sort) {
        if (null == sort) {
            this.m_sortColumn = null;
        } else {
            for (ColumnDef<T, ?> scd : this.m_columnList) {
                if (!DomUtil.isEqual((Object)scd.getPropertyName(), (Object)sort)) continue;
                this.setSortColumn(scd, scd.getSortable());
                break;
            }
        }
    }

    public void setSortColumn(@Nullable ColumnDef<T, ?> cd, @Nullable SortableType type) {
        this.m_sortColumn = cd;
        this.m_sortDescending = type == SortableType.SORTABLE_DESC;
    }

    public void setSortColumn(@Nullable ColumnDef<T, ?> cd) {
        this.m_sortColumn = cd;
    }

    public void addDefaultColumns() {
        List<DisplayPropertyMetaModel> dpl = this.m_metaModel.getTableDisplayProperties();
        if (dpl.size() == 0) {
            throw new IllegalStateException("The list-of-columns to show is empty, and the class " + this.m_metaModel.getActualClass() + " has no @MetaObject definition defining a set of columns as default table columns, so there.");
        }
        List<ExpandedDisplayProperty<?>> xdpl = ExpandedDisplayProperty.expandDisplayProperties(dpl, this.m_metaModel, null);
        xdpl = ExpandedDisplayProperty.flatten(xdpl);
        for (ExpandedDisplayProperty<?> xdp : xdpl) {
            this.addExpandedDisplayProp(xdp);
        }
    }

    @Nonnull
    private <V> ColumnDef<T, V> addExpandedDisplayProp(@Nonnull ExpandedDisplayProperty<V> xdp) {
        ColumnDef scd = new ColumnDef(this, xdp);
        if (scd.getNumericPresentation() != null && scd.getNumericPresentation() != NumericPresentation.UNKNOWN) {
            scd.css("ui-numeric");
            scd.cssHeader("ui-numeric");
        }
        this.m_columnList.add(scd);
        return scd;
    }

    public void assignPercentages() {
        int totpct = 0;
        int totpix = 0;
        int ntoass = 0;
        int totdw = 0;
        for (ColumnDef<T, ?> scd : this.m_columnList) {
            int w;
            String cwidth = scd.getWidth();
            if (cwidth == null || cwidth.length() == 0) {
                ++ntoass;
                totdw += scd.getDisplayLength();
                continue;
            }
            String s = cwidth.trim();
            if (s.endsWith("%")) {
                w = StringTool.strToInt((String)s.substring(0, s.length() - 1).trim(), (int)-1);
                if (w == -1) {
                    throw new IllegalArgumentException("Invalid width percentage: " + s + " for presentation column " + scd.getPropertyName());
                }
                totpct += w;
                continue;
            }
            if (!s.endsWith("px")) {
                s = s + "px";
                scd.width(s);
            }
            if ((w = StringTool.strToInt((String)s.substring(0, s.length() - 2).trim(), (int)-1)) == -1) {
                throw new IllegalArgumentException("Invalid width #pixels: " + s + " for presentation column " + scd.getPropertyName());
            }
            totpix += w;
        }
        int pixwidth = 1280;
        if (ntoass > 0 && totpct < 100 && totpix < 1280) {
            int pctleft = 100 - totpct;
            if (pctleft == 100 && totpix > 0) {
                pctleft = 100 * (1280 - totpix) / 1280;
            }
            for (ColumnDef<T, ?> scd : this.m_columnList) {
                String width = scd.getWidth();
                if (width != null && width.length() != 0) continue;
                double fact = (double)scd.getDisplayLength() / (double)totdw;
                int pct = (int)(fact * (double)pctleft + 0.5);
                pctleft -= pct;
                totdw -= scd.getDisplayLength();
                scd.width(pct + "%");
            }
        }
    }

    @Override
    @Nonnull
    public Iterator<ColumnDef<T, ?>> iterator() {
        return this.m_columnList.iterator();
    }

    public int indexOf(@Nonnull ColumnDef<T, ?> scd) {
        return this.m_columnList.indexOf(scd);
    }

    @Nullable
    public ColumnDef<T, ?> getSortColumn() {
        return this.m_sortColumn;
    }

    protected void updateDefaultSort(@Nonnull ColumnDef<T, ?> scd) {
        if (this.m_sortColumn == scd) {
            this.m_sortDescending = scd.getSortable() == SortableType.SORTABLE_DESC;
        }
    }

    public boolean isSortDescending() {
        return this.m_sortDescending;
    }

    public void setSortDescending(boolean desc) {
        this.m_sortDescending = desc;
    }

    @Nonnull
    public <V> ColumnDef<T, V> column(@Nonnull Class<V> type, @Nonnull @GProperty String property) {
        PropertyMetaModel<?> pmm = this.model().getProperty(property);
        return this.createColumnDef(pmm);
    }

    @Nonnull
    private <V> ColumnDef<T, V> createColumnDef(@Nonnull PropertyMetaModel<V> pmm) {
        ColumnDef scd = new ColumnDef(this, pmm);
        scd.nowrap();
        this.add(scd);
        return scd;
    }

    @Nonnull
    public ColumnDef<T, ?> column(@Nonnull @GProperty String property) {
        PropertyMetaModel<?> pmm = this.model().getProperty(property);
        return this.createColumnDef(pmm);
    }

    @Nonnull
    public ColumnDef<T, T> column() {
        ColumnDef scd = new ColumnDef(this, this.m_actualClass);
        this.add(scd);
        scd.nowrap();
        return scd;
    }
}

