/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.tbl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.meta.MetaManager;
import to.etc.domui.component.tbl.ISelectableTableComponent;
import to.etc.domui.component.tbl.ISelectionListener;
import to.etc.domui.component.tbl.ISelectionModel;
import to.etc.domui.component.tbl.ITableModel;
import to.etc.domui.component.tbl.PageableTabularComponentBase;
import to.etc.domui.dom.html.Div;
import to.etc.domui.dom.html.IClicked;
import to.etc.domui.dom.html.TBody;
import to.etc.domui.dom.html.TD;
import to.etc.domui.dom.html.TR;
import to.etc.domui.dom.html.Table;
import to.etc.domui.dom.html.TableVAlign;
import to.etc.domui.server.DomApplication;
import to.etc.domui.util.INodeContentRenderer;
import to.etc.domui.util.Msgs;

public class DataCellTable<T>
extends PageableTabularComponentBase<T>
implements ISelectionListener<T>,
ISelectableTableComponent<T> {
    private int m_rows = 3;
    private int m_columns = 3;
    @Nonnull
    private final Table m_table = new Table();
    private TBody m_dataBody;
    private boolean m_renderEmptyCells;
    private boolean m_renderEmptyRows;
    private INodeContentRenderer<T> m_contentRenderer;
    private INodeContentRenderer<T> m_actualContentRenderer;
    private Class<? extends INodeContentRenderer<T>> m_contentRendererClass;
    @Nonnull
    private final Map<T, Div> m_visibleMap = new HashMap<T, Div>();

    public DataCellTable(@Nonnull ITableModel<T> model) {
        super(model);
    }

    public int getRows() {
        return this.m_rows;
    }

    public void setRows(int rows) {
        if (rows == this.m_rows) {
            return;
        }
        this.m_rows = rows;
        this.rebuild();
    }

    public int getColumns() {
        return this.m_columns;
    }

    public void setColumns(int columns) {
        if (this.m_columns == columns) {
            return;
        }
        this.m_columns = columns;
        this.rebuild();
    }

    @Override
    protected int getPageSize() {
        return this.m_columns * this.m_rows;
    }

    public boolean isRenderEmptyCells() {
        return this.m_renderEmptyCells;
    }

    public void setRenderEmptyCells(boolean renderEmptyCells) {
        this.m_renderEmptyCells = renderEmptyCells;
    }

    @Nullable
    public INodeContentRenderer<T> getContentRenderer() {
        return this.m_contentRenderer;
    }

    public void setContentRenderer(@Nullable INodeContentRenderer<T> contentRenderer) {
        this.m_contentRenderer = contentRenderer;
    }

    @Nullable
    public Class<? extends INodeContentRenderer<T>> getContentRendererClass() {
        return this.m_contentRendererClass;
    }

    public void setContentRendererClass(@Nullable Class<? extends INodeContentRenderer<T>> contentRendererClass) {
        this.m_contentRendererClass = contentRendererClass;
    }

    public boolean isRenderEmptyRows() {
        return this.m_renderEmptyRows;
    }

    public void setRenderEmptyRows(boolean renderEmptyRows) {
        this.m_renderEmptyRows = renderEmptyRows;
    }

    private void rebuild() {
        this.forceRebuild();
    }

    @Nonnull
    private INodeContentRenderer<T> calculateContentRenderer(@Nullable Object val) {
        if (this.m_actualContentRenderer != null) {
            return this.m_actualContentRenderer;
        }
        if (this.m_contentRenderer != null) {
            this.m_actualContentRenderer = this.m_contentRenderer;
            return this.m_actualContentRenderer;
        }
        if (this.m_contentRendererClass != null) {
            this.m_actualContentRenderer = DomApplication.get().createInstance(this.m_contentRendererClass, new Object[0]);
            return this.m_actualContentRenderer;
        }
        throw new IllegalStateException("Missing INodeContentRenderer on " + this);
    }

    @Override
    public void createContent() throws Exception {
        this.setCssClass("ui-dct");
        this.calcIndices();
        List list = this.getPageItems();
        if (list.size() == 0) {
            Div error = new Div();
            error.setCssClass("ui-dct-nores");
            error.setText(Msgs.BUNDLE.getString("ui.dt.empty"));
            this.add(error);
            return;
        }
        this.m_table.removeAllChildren();
        this.add(this.m_table);
        TBody body = this.m_dataBody = new TBody();
        this.m_table.add(body);
        this.m_visibleMap.clear();
        int index = 0;
        for (int row = 0; row < this.getRows(); ++row) {
            TR tr = new TR();
            body.add(tr);
            for (int col = 0; col < this.getColumns(); ++col) {
                TD td = new TD();
                tr.add(td);
                td.setValign(TableVAlign.TOP);
                Div seldiv = new Div();
                td.add(seldiv);
                seldiv.setCssClass("ui-dct-item");
                T value = null;
                if (index >= list.size()) {
                    if (!this.isRenderEmptyCells()) {
                        seldiv.setCssClass("ui-dct-empty");
                        continue;
                    }
                } else {
                    value = list.get(index);
                }
                if (null != value) {
                    this.m_visibleMap.put(value, seldiv);
                    this.renderCell(seldiv, value);
                }
                ++index;
            }
            if (index >= list.size() && !this.isRenderEmptyRows()) break;
        }
    }

    private boolean hasSelectionModel() {
        return this.getSelectionModel() != null;
    }

    private void renderCell(final @Nonnull Div td, final @Nonnull T value) throws Exception {
        boolean selected = false;
        ISelectionModel<T> sm = this.getSelectionModel();
        if (null != sm) {
            selected = sm.isSelected(value);
            td.addCssClass("ui-clickable");
            td.setClicked(new IClicked<Div>(){

                @Override
                public void clicked(@Nonnull Div clickednode) throws Exception {
                    DataCellTable.this.handleSelectionClick(td, value);
                }
            });
        }
        INodeContentRenderer<T> r = this.calculateContentRenderer(value);
        r.renderNodeContent(this, td, value, selected);
        if (selected) {
            td.setCssClass("ui-dct-selected");
        }
    }

    private void handleSelectionClick(@Nonnull Div td, @Nonnull T value) throws Exception {
        ISelectionModel<T> sm = this.getSelectionModel();
        if (null == sm) {
            throw new IllegalStateException("SelectionModel is null??");
        }
        boolean nvalue = !sm.isSelected(value);
        sm.setInstanceSelected(value, nvalue);
    }

    @Override
    public void modelChanged(@Nullable ITableModel<T> model) {
        this.rebuild();
    }

    @Override
    public void rowAdded(@Nonnull ITableModel<T> model, int index, @Nonnull T value) throws Exception {
    }

    @Override
    public void rowDeleted(@Nonnull ITableModel<T> model, int index, @Nonnull T value) throws Exception {
    }

    @Override
    public void rowModified(@Nonnull ITableModel<T> model, int index, @Nonnull T value) throws Exception {
    }

    @Override
    public void selectionChanged(@Nonnull T row, boolean on) throws Exception {
        for (Map.Entry<T, Div> me : this.m_visibleMap.entrySet()) {
            if (!MetaManager.areObjectsEqual(me.getKey(), row)) continue;
            Div d = me.getValue();
            if (on) {
                d.addCssClass("ui-dct-selected");
            } else {
                d.removeCssClass("ui-dct-selected");
            }
            return;
        }
    }

    @Override
    public void selectionAllChanged() throws Exception {
        ISelectionModel<T> sm = this.getSelectionModel();
        if (sm == null) {
            throw new IllegalStateException("Got selection changed event but selection model is empty?");
        }
        for (T item : this.m_visibleMap.keySet()) {
            this.selectionChanged(item, sm.isSelected(item));
        }
    }

    @Override
    public boolean isMultiSelectionVisible() {
        ISelectionModel sm = this.getSelectionModel();
        return sm != null && sm.isMultiSelect();
    }

    @Override
    protected void createSelectionUI() throws Exception {
    }
}

