/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.tbl;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.buttons.SmallImgButton;
import to.etc.domui.component.misc.VerticalSpacer;
import to.etc.domui.component.tbl.IDataTableChangeListener;
import to.etc.domui.component.tbl.ISelectableTableComponent;
import to.etc.domui.component.tbl.ISelectionModel;
import to.etc.domui.component.tbl.ITableModel;
import to.etc.domui.component.tbl.PageableTabularComponentBase;
import to.etc.domui.component.tbl.TableModelTableBase;
import to.etc.domui.dom.css.DisplayType;
import to.etc.domui.dom.css.FloatType;
import to.etc.domui.dom.html.ATag;
import to.etc.domui.dom.html.Div;
import to.etc.domui.dom.html.IClicked;
import to.etc.domui.dom.html.Img;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.dom.html.TextNode;
import to.etc.domui.util.Msgs;
import to.etc.webapp.nls.BundleRef;

public class DataPager
extends Div
implements IDataTableChangeListener {
    private ATag m_firstBtn;
    private ATag m_prevBtn;
    private ATag m_nextBtn;
    private ATag m_lastBtn;
    private SmallImgButton m_showSelectionBtn;
    private Img m_truncated;
    private PageableTabularComponentBase<?> m_table;
    private TextNode m_txt;
    private Div m_textDiv;
    private boolean m_showSelection = true;
    private Div m_buttonDiv;
    @Nonnull
    private List<SmallImgButton> m_extraButtonList = new ArrayList<SmallImgButton>();

    public DataPager() {
    }

    public DataPager(PageableTabularComponentBase<?> tbl) {
        this.m_table = tbl;
        tbl.addChangeListener(this);
    }

    @Override
    public void createContent() throws Exception {
        this.setCssClass("ui-dp");
        Div d = new Div();
        this.add(d);
        d.setFloat(FloatType.RIGHT);
        Div txtPnl = new Div();
        txtPnl.setTestID("pager results label");
        txtPnl.setCssClass("ui-dp-nav-pgr");
        this.m_txt = new TextNode();
        d.add(new VerticalSpacer(10));
        txtPnl.add(this.m_txt);
        d.add(txtPnl);
        this.m_textDiv = d;
        this.m_buttonDiv = new Div();
        this.add(this.m_buttonDiv);
        this.m_buttonDiv.setCssClass("ui-dp-btns");
        this.m_firstBtn = new ATag();
        this.m_firstBtn.setTestID("firstBtn");
        this.m_buttonDiv.add(this.m_firstBtn);
        this.m_prevBtn = new ATag();
        this.m_prevBtn.setTestID("prevBtn");
        this.m_buttonDiv.add(this.m_prevBtn);
        this.m_nextBtn = new ATag();
        this.m_nextBtn.setTestID("nextBtn");
        this.m_buttonDiv.add(this.m_nextBtn);
        this.m_lastBtn = new ATag();
        this.m_lastBtn.setTestID("lastBtn");
        this.m_buttonDiv.add(this.m_lastBtn);
        this.m_buttonDiv.add("\u00a0\u00a0");
        for (SmallImgButton sib : this.m_extraButtonList) {
            this.m_buttonDiv.add(sib);
        }
        this.redraw();
        this.m_firstBtn.setClicked(new IClicked<NodeBase>(){

            @Override
            public void clicked(@Nonnull NodeBase b) throws Exception {
                DataPager.this.m_table.setCurrentPage(0);
            }
        });
        this.m_lastBtn.setClicked(new IClicked<NodeBase>(){

            @Override
            public void clicked(@Nonnull NodeBase b) throws Exception {
                int pg = DataPager.this.m_table.getPageCount();
                if (pg == 0) {
                    return;
                }
                DataPager.this.m_table.setCurrentPage(pg - 1);
            }
        });
        this.m_prevBtn.setClicked(new IClicked<NodeBase>(){

            @Override
            public void clicked(@Nonnull NodeBase b) throws Exception {
                int cp = DataPager.this.m_table.getCurrentPage();
                if (cp <= 0) {
                    return;
                }
                DataPager.this.m_table.setCurrentPage(cp - 1);
            }
        });
        this.m_nextBtn.setClicked(new IClicked<NodeBase>(){

            @Override
            public void clicked(@Nonnull NodeBase b) throws Exception {
                int cp = DataPager.this.m_table.getCurrentPage();
                int mx = DataPager.this.m_table.getPageCount();
                if (++cp >= mx) {
                    return;
                }
                DataPager.this.m_table.setCurrentPage(cp);
            }
        });
    }

    @Nullable
    private ISelectableTableComponent<?> getSelectableTable() {
        if (this.m_table instanceof ISelectableTableComponent) {
            return this.m_table;
        }
        return null;
    }

    @Nullable
    private ISelectionModel<?> getSelectionModel() {
        ISelectableTableComponent<?> stm = this.getSelectableTable();
        if (null == stm) {
            return null;
        }
        return stm.getSelectionModel();
    }

    private boolean isNeedSelectionButton() throws Exception {
        ISelectionModel<?> sm = this.getSelectionModel();
        if (sm == null || !this.m_showSelection) {
            return false;
        }
        if (!sm.isMultiSelect()) {
            return false;
        }
        ISelectableTableComponent<?> tc = this.getSelectableTable();
        if (null == tc) {
            throw new IllegalStateException("Null selectable table?");
        }
        if (tc.isMultiSelectionVisible()) {
            return false;
        }
        return tc.getModel() != null && tc.getModel().getRows() != 0;
    }

    @Override
    public void selectionUIChanged(@Nonnull TableModelTableBase<?> tbl) throws Exception {
        this.redraw();
    }

    private void redraw() throws Exception {
        if (this.m_buttonDiv == null) {
            return;
        }
        int cp = this.m_table.getCurrentPage();
        int np = this.m_table.getPageCount();
        int rowsAsked = -1;
        if (np == 0) {
            this.m_txt.setText("");
            this.setDisplay(DisplayType.NONE);
        } else {
            int rows = rowsAsked = this.m_table.getModel().getRows();
            this.m_txt.setText(Msgs.BUNDLE.formatMessage("ui.pagertext", new Object[]{cp + 1, np, rows}));
            this.setDisplay(DisplayType.BLOCK);
        }
        if (cp <= 0) {
            this.m_firstBtn.setCssClass("ui-dp-nav-f-dis");
            this.m_prevBtn.setCssClass("ui-dp-nav-p-dis");
        } else {
            this.m_firstBtn.setCssClass("ui-dp-nav-f");
            this.m_prevBtn.setCssClass("ui-dp-nav-p");
        }
        if (cp + 1 >= np) {
            this.m_lastBtn.setCssClass("ui-dp-nav-l-dis");
            this.m_nextBtn.setCssClass("ui-dp-nav-n-dis");
        } else {
            this.m_lastBtn.setCssClass("ui-dp-nav-l");
            this.m_nextBtn.setCssClass("ui-dp-nav-n");
        }
        int tc = this.m_table.getTruncatedCount();
        if (tc > 0) {
            if (this.m_truncated == null) {
                this.m_truncated = new Img();
                this.m_truncated.setSrc("THEME/nav-overflow.png");
                this.m_truncated.setTitle(Msgs.BUNDLE.formatMessage("ui.pagerover", new Object[]{tc}));
                this.m_truncated.setCssClass("ui-dp-nav-pgr-ovf");
                this.m_textDiv.add(this.m_truncated);
            }
        } else if (this.m_truncated != null) {
            this.m_truncated.remove();
            this.m_truncated = null;
        }
        if (this.isShowSelection() && this.getSelectableTable() != null) {
            this.redrawSelectionButtons();
        }
    }

    private void redrawSelectionButtons() throws Exception {
        final ISelectableTableComponent<?> dt = this.getSelectableTable();
        if (null == dt) {
            throw new IllegalStateException("Null selectable table?");
        }
        if (this.isNeedSelectionButton()) {
            if (this.m_showSelectionBtn == null) {
                this.m_showSelectionBtn = new SmallImgButton("THEME/dpr-select-on.png");
                this.m_buttonDiv.add(4, this.m_showSelectionBtn);
                this.m_showSelectionBtn.setClicked(new IClicked<NodeBase>(){

                    @Override
                    public void clicked(@Nonnull NodeBase clickednode) throws Exception {
                        dt.setShowSelection(true);
                        clickednode.remove();
                        DataPager.this.m_showSelectionBtn = null;
                    }
                });
                this.m_showSelectionBtn.setTitle(Msgs.BUNDLE.getString("ui.dpr.selections"));
            }
        } else if (this.m_showSelectionBtn != null) {
            this.m_showSelectionBtn.remove();
            this.m_showSelectionBtn = null;
        }
    }

    public Div getButtonDiv() {
        return this.m_buttonDiv;
    }

    public void addButton(String image, final IClicked<DataPager> click, BundleRef bundle, String ttlkey) {
        SmallImgButton i = new SmallImgButton(image, new IClicked<SmallImgButton>(){

            @Override
            public void clicked(@Nonnull SmallImgButton b) throws Exception {
                click.clicked(DataPager.this);
            }
        });
        if (bundle != null) {
            i.setTitle(bundle.getString(ttlkey));
        } else if (ttlkey != null) {
            i.setTitle(ttlkey);
        }
        this.getButtonDiv().add(i);
    }

    @Override
    public void modelChanged(@Nonnull TableModelTableBase<?> tbl, @Nullable ITableModel<?> old, @Nullable ITableModel<?> nw) throws Exception {
        this.forceRebuild();
        this.m_buttonDiv = null;
    }

    @Override
    public void pageChanged(@Nonnull TableModelTableBase<?> tbl) throws Exception {
        this.redraw();
    }

    public boolean isShowSelection() {
        return this.m_showSelection;
    }

    public void setShowSelection(boolean showSelection) {
        if (this.m_showSelection == showSelection) {
            return;
        }
        this.m_showSelection = showSelection;
        this.forceRebuild();
    }

    public void addButton(@Nonnull SmallImgButton sib) {
        this.m_extraButtonList.add(sib);
        this.forceRebuild();
    }

    public void addButton(@Nonnull String img, @Nonnull IClicked<SmallImgButton> clicked) {
        this.m_extraButtonList.add(new SmallImgButton(img, clicked));
    }
}

