/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.tbl;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.meta.MetaManager;
import to.etc.domui.component.misc.MiniLogger;
import to.etc.domui.component.tbl.ColumnContainer;
import to.etc.domui.component.tbl.HeaderContainer;
import to.etc.domui.component.tbl.IAcceptable;
import to.etc.domui.component.tbl.ICellClicked;
import to.etc.domui.component.tbl.IRowRenderer;
import to.etc.domui.component.tbl.ISelectableTableComponent;
import to.etc.domui.component.tbl.ISelectionListener;
import to.etc.domui.component.tbl.ISelectionModel;
import to.etc.domui.component.tbl.ITableModel;
import to.etc.domui.component.tbl.PageableTabularComponentBase;
import to.etc.domui.dom.html.Checkbox;
import to.etc.domui.dom.html.ClickInfo;
import to.etc.domui.dom.html.Div;
import to.etc.domui.dom.html.IClickBase;
import to.etc.domui.dom.html.IClicked;
import to.etc.domui.dom.html.IClicked2;
import to.etc.domui.dom.html.Img;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.dom.html.TBody;
import to.etc.domui.dom.html.TD;
import to.etc.domui.dom.html.TH;
import to.etc.domui.dom.html.THead;
import to.etc.domui.dom.html.TR;
import to.etc.domui.dom.html.Table;
import to.etc.domui.dom.html.TextNode;
import to.etc.domui.util.DomUtil;
import to.etc.domui.util.JavascriptUtil;
import to.etc.domui.util.Msgs;

public class DataTable<T>
extends PageableTabularComponentBase<T>
implements ISelectionListener<T>,
ISelectableTableComponent<T> {
    private MiniLogger m_ml = new MiniLogger(40);
    private Table m_table = new Table();
    private IRowRenderer<T> m_rowRenderer;
    private int m_pageSize;
    private TBody m_dataBody;
    private Div m_errorDiv;
    private final List<T> m_visibleItemList = new ArrayList<T>();
    private boolean m_multiSelectMode;
    private int m_lastSelectionLocation = -1;
    @Nullable
    private NodeBase m_emptyMessage;
    private boolean m_displayReadonlySelection = true;
    private boolean m_showHeaderAlways;
    private boolean m_preventRowHighlight;
    @Nonnull
    private final IClicked<TH> m_headerSelectClickHandler = new IClicked<TH>(){

        @Override
        public void clicked(@Nonnull TH clickednode) throws Exception {
            if (DataTable.this.isDisabled()) {
                return;
            }
            ISelectionModel sm = DataTable.this.getSelectionModel();
            if (null == sm) {
                return;
            }
            int ct = sm.getSelectionCount();
            if (0 == ct && sm.isMultiSelect()) {
                sm.selectAll(DataTable.this.getModel());
            } else {
                sm.clearSelection();
            }
        }
    };

    public DataTable(@Nonnull ITableModel<T> m, @Nonnull IRowRenderer<T> r) {
        super(m);
        this.m_rowRenderer = r;
    }

    public DataTable(@Nonnull IRowRenderer<T> r) {
        this.m_rowRenderer = r;
    }

    public DataTable(@Nonnull ITableModel<T> m) {
        super(m);
    }

    public DataTable() {
    }

    @Nonnull
    protected Table getTable() {
        if (null == this.m_table) {
            throw new IllegalStateException("Backing table is still null");
        }
        return this.m_table;
    }

    protected void setDataBody(@Nonnull TBody dataBody) {
        this.m_dataBody = dataBody;
        this.updateBodyClipboardSelection();
    }

    protected void updateBodyClipboardSelection() {
        TBody dataBody = this.m_dataBody;
        if (null == dataBody) {
            return;
        }
        if (this.isDisableClipboardSelection()) {
            this.appendJavascript(JavascriptUtil.disableSelection(dataBody));
        }
    }

    @Nonnull
    protected TBody getDataBody() {
        if (null == this.m_dataBody) {
            throw new IllegalStateException("dataBody is still null");
        }
        return this.m_dataBody;
    }

    @Override
    public void createContent() throws Exception {
        this.m_dataBody = null;
        this.m_errorDiv = null;
        this.addCssClass("ui-dt");
        ISelectionModel sm = this.getSelectionModel();
        if (sm != null) {
            this.m_multiSelectMode = this.isShowSelectionAlways() || sm.getSelectionCount() > 0 ? sm.isMultiSelect() : false;
        }
        if (this.m_rowRenderer == null) {
            throw new IllegalStateException("There is no row renderer assigned to the table");
        }
        this.m_rowRenderer.beforeQuery(this);
        this.calcIndices();
        List list = this.getPageItems();
        if (list.size() == 0) {
            this.setNoResults();
            return;
        }
        this.setResults();
        ColumnContainer cc = new ColumnContainer(this);
        this.m_visibleItemList.clear();
        int ix = this.m_six;
        for (Object o : list) {
            this.m_visibleItemList.add(o);
            TR tr = new TR();
            this.m_dataBody.add(tr);
            tr.setTestRepeatID("r" + ix);
            cc.setParent(tr);
            this.renderRow(tr, cc, ix, o);
            ++ix;
        }
        this.ml("createContent rebuilt visibleList after render");
    }

    private void setResults() throws Exception {
        if (this.m_errorDiv != null) {
            this.m_errorDiv.remove();
            this.m_errorDiv = null;
        }
        if (this.m_dataBody != null) {
            return;
        }
        this.m_table.removeAllChildren();
        this.add(this.m_table);
        THead hd = new THead();
        this.m_table.add(hd);
        HeaderContainer hc = new HeaderContainer(this, hd, "ui-dt-hdr");
        this.renderHeader(hc);
        if (!hc.hasContent()) {
            hd.remove();
        }
        this.m_dataBody = new TBody();
        this.m_table.add(this.m_dataBody);
        this.updateBodyClipboardSelection();
    }

    @Deprecated
    void renderHeader(@Nonnull HeaderContainer<T> hc) throws Exception {
        if (this.m_multiSelectMode) {
            TH headerCell = hc.add("");
            headerCell.add(new Img("THEME/dspcb-on.png"));
            headerCell.setTestID("dt_select_all");
            headerCell.setWidth("1%");
            headerCell.setClicked(this.m_headerSelectClickHandler);
            headerCell.setCssClass("ui-clickable");
        }
        this.m_rowRenderer.renderHeader(this, hc);
    }

    private void setNoResults() throws Exception {
        if (this.m_showHeaderAlways) {
            this.setNoResultsWithHeader();
        } else {
            this.setNoResultsWithoutHeader();
        }
    }

    private void setNoResultsWithHeader() throws Exception {
        this.m_visibleItemList.clear();
        this.ml("setNoResults visibleList cleared");
        if (this.m_errorDiv != null) {
            return;
        }
        if (this.m_table != null) {
            this.m_table.removeAllChildren();
        } else {
            this.m_table = new Table();
            this.add(this.m_table);
        }
        this.m_dataBody = null;
        if (!this.m_table.isAttached()) {
            this.add(this.m_table);
        }
        THead hd = new THead();
        this.m_table.add(hd);
        HeaderContainer hc = new HeaderContainer(this, hd, "ui-dt-hdr");
        this.renderHeader(hc);
        if (!hc.hasContent()) {
            hd.remove();
        }
        this.m_dataBody = new TBody();
        this.m_table.add(this.m_dataBody);
        this.updateBodyClipboardSelection();
        this.renderNoResultsMessage();
    }

    private void renderNoResultsMessage() {
        this.m_errorDiv = new Div();
        this.m_errorDiv.setCssClass("ui-dt-nores");
        NodeBase emptyMessage = this.m_emptyMessage;
        if (null == emptyMessage) {
            this.m_errorDiv.setText(Msgs.BUNDLE.getString("ui.dt.empty"));
        } else {
            this.m_errorDiv.add(emptyMessage);
        }
        this.add(this.m_errorDiv);
    }

    private void setNoResultsWithoutHeader() throws Exception {
        this.m_visibleItemList.clear();
        this.ml("setNoResults visibleList cleared");
        if (this.m_errorDiv != null) {
            return;
        }
        if (this.m_table != null) {
            this.m_table.removeAllChildren();
            this.m_table.remove();
            this.m_dataBody = null;
        }
        this.renderNoResultsMessage();
    }

    public void setEmptyMessage(@Nullable String message) {
        this.m_emptyMessage = null != message ? new TextNode(message) : null;
    }

    public void setEmptyMessage(@Nullable NodeBase node) {
        this.m_emptyMessage = node;
    }

    private void renderRow(@Nonnull TR tr, @Nonnull ColumnContainer<T> cc, int index, final @Nonnull T value) throws Exception {
        ISelectionModel<T> sm = this.getSelectionModel();
        if (this.m_rowRenderer.getRowClicked() != null || null != sm) {
            cc.getTR().setClicked(new IClicked2<TR>(){

                @Override
                public void clicked(@Nonnull TR b, @Nonnull ClickInfo clinfo) throws Exception {
                    DataTable.this.handleRowClick(b, value, clinfo);
                }
            });
            cc.getTR().addCssClass("ui-rowsel");
        } else if (!this.m_preventRowHighlight) {
            cc.getTR().addCssClass("ui-dt-row-nosel");
        }
        if (sm != null) {
            String clzName;
            boolean issel = sm.isSelected(value);
            String string = clzName = sm.isMultiSelect() ? "mselected" : "selected";
            if (issel) {
                tr.addCssClass(clzName);
            } else {
                tr.removeCssClass(clzName);
            }
            if (this.m_multiSelectMode) {
                Checkbox cb = this.createSelectionCheckbox(value, sm);
                TD td = cc.add(cb);
                if (cb.isReadOnly()) {
                    td.addCssClass("ui-cur-default");
                } else {
                    this.hookCheckboxClickToCellToo(td, cb);
                }
                cb.setChecked(issel);
            }
        }
        this.internalRenderRow(tr, cc, index, value);
    }

    private void hookCheckboxClickToCellToo(TD td, Checkbox cb) {
        td.setClicked((node, clinfo) -> {
            IClickBase<?> clickHandler;
            if (!cb.isDisabled() && null != (clickHandler = cb.getClicked()) && clickHandler instanceof IClicked2) {
                cb.setChecked(!cb.isChecked());
                ((IClicked2)clickHandler).clicked(cb, clinfo);
            }
        });
    }

    @Deprecated
    void internalRenderRow(@Nonnull TR tr, @Nonnull ColumnContainer<T> cc, int index, @Nonnull T value) throws Exception {
        this.m_rowRenderer.renderRow(this, cc, index, value);
    }

    private void handleRowClick(TR b, T instance, ClickInfo clinfo) throws Exception {
        ICellClicked<?> rowClicked;
        ISelectionModel selectionModel = this.getSelectionModel();
        if (selectionModel != null) {
            if (clinfo.isControl() || clinfo.isShift()) {
                this.handleSelectClicky(instance, clinfo, null);
                return;
            }
            if (!selectionModel.isMultiSelect()) {
                this.handleSelectClicky(instance, clinfo, null);
            }
        }
        if (null != (rowClicked = this.m_rowRenderer.getRowClicked())) {
            rowClicked.cellClicked(b, instance);
        }
    }

    private void selectionCheckboxClicked(T instance, boolean checked, ClickInfo info, @Nonnull Checkbox checkbox) throws Exception {
        this.handleSelectClicky(instance, info, checked);
        ISelectionModel<T> sm = this.getSelectionModel();
        if (null != sm) {
            checkbox.setChecked(sm.isSelected(instance));
        }
    }

    private void handleSelectClicky(@Nonnull T instance, @Nonnull ClickInfo clinfo, @Nullable Boolean setTo) throws Exception {
        int el;
        int sl;
        boolean nvalue;
        ISelectionModel sm = this.getSelectionModel();
        if (null == sm) {
            throw new IllegalStateException("SelectionModel is null??");
        }
        boolean bl = setTo != null ? setTo : (nvalue = !sm.isSelected(instance));
        if (!clinfo.isShift()) {
            sm.setInstanceSelected(instance, nvalue);
            this.m_lastSelectionLocation = -1;
            return;
        }
        int itemindex = -1;
        int index = 0;
        for (T item : this.m_visibleItemList) {
            if (MetaManager.areObjectsEqual(item, instance)) {
                itemindex = index;
                break;
            }
            ++index;
        }
        if (itemindex == -1) {
            return;
        }
        itemindex += this.m_six;
        if (this.m_lastSelectionLocation == -1) {
            this.m_lastSelectionLocation = itemindex;
            sm.setInstanceSelected(instance, !sm.isSelected(instance));
            return;
        }
        if (this.m_lastSelectionLocation < itemindex) {
            sl = this.m_lastSelectionLocation + 1;
            el = itemindex + 1;
        } else {
            sl = itemindex;
            el = this.m_lastSelectionLocation;
        }
        int i = sl;
        while (i < el) {
            int ex = i + 50;
            if (ex > el) {
                ex = el;
            }
            List sub = this.getModel().getItems(i, ex);
            i += ex;
            for (Object item : sub) {
                if (item == null) {
                    throw new IllegalStateException("null item in list");
                }
                sm.setInstanceSelected(item, !sm.isSelected(item));
            }
        }
        this.m_lastSelectionLocation = -1;
    }

    private void updateSelectionChanged(T instance, int lrow, boolean on) throws Exception {
        TD td;
        Checkbox cb;
        ISelectionModel sm = this.getSelectionModel();
        if (sm == null) {
            throw new IllegalStateException("No selection model!?");
        }
        TR row = (TR)this.m_dataBody.getChild(lrow);
        THead head = this.m_table.getHead();
        if (null == head) {
            throw new IllegalStateException("I've lost my head!?");
        }
        TR headerrow = (TR)head.getChild(0);
        if (!sm.isMultiSelect()) {
            if (on) {
                row.addCssClass("selected");
            } else {
                row.removeCssClass("selected");
            }
            return;
        }
        if (!this.m_multiSelectMode) {
            if (!on) {
                return;
            }
            this.createMultiselectUI(headerrow);
        }
        if ((cb = (Checkbox)(td = (TD)row.getChild(0)).getChild(0)).isChecked() != on) {
            cb.setChecked(on);
        }
        if (on) {
            row.addCssClass("mselected");
        } else {
            row.removeCssClass("mselected");
        }
    }

    private void createMultiselectUI(TR headerrow) {
        if (this.m_multiSelectMode) {
            return;
        }
        this.m_multiSelectMode = true;
        TH th = new TH();
        th.add(new Img("THEME/dspcb-on.png"));
        th.setTestID("dt_select_all");
        th.setWidth("1%");
        headerrow.add(0, th);
        th.setClicked(this.m_headerSelectClickHandler);
        th.setCssClass("ui-clickable");
        for (int i = 0; i < this.m_dataBody.getChildCount(); ++i) {
            T instance = this.m_visibleItemList.get(i);
            TR tr = (TR)this.m_dataBody.getChild(i);
            TD td = new TD();
            tr.add(0, td);
            Checkbox cb = this.createSelectionCheckbox(instance, this.getSelectionModel());
            if (cb.isReadOnly()) {
                td.addCssClass("ui-cur-default");
            } else {
                this.hookCheckboxClickToCellToo(td, cb);
            }
            td.add(cb);
            cb.setChecked(false);
        }
        this.fireSelectionUIChanged();
    }

    @Override
    protected void createSelectionUI() throws Exception {
        THead head = this.m_table.getHead();
        if (null == head) {
            throw new IllegalStateException("I've lost my head!?");
        }
        TR headerrow = (TR)head.getChild(0);
        this.createMultiselectUI(headerrow);
    }

    @Override
    public boolean isMultiSelectionVisible() {
        return this.m_multiSelectMode;
    }

    @Override
    public int getPageSize() {
        return this.m_pageSize;
    }

    public void setPageSize(int pageSize) {
        if (this.m_pageSize == pageSize) {
            return;
        }
        this.m_pageSize = pageSize;
        this.forceRebuild();
        this.firePageChanged();
    }

    @Override
    public void modelChanged(@Nullable ITableModel<T> model) {
        this.forceRebuild();
        this.fireModelChanged(null, model);
    }

    @Override
    public void rowAdded(@Nonnull ITableModel<T> model, int index, @Nonnull T value) throws Exception {
        try {
            int lastChildIndex;
            if (!this.isBuilt()) {
                return;
            }
            this.calcIndices();
            if (index < this.m_six || index >= this.m_eix) {
                this.firePageChanged();
                return;
            }
            this.setResults();
            int rrow = index - this.m_six;
            this.ml("rowAdded before anything: rrow=" + rrow + " index=" + index);
            ColumnContainer cc = new ColumnContainer(this);
            TR tr = new TR();
            this.m_dataBody.add(rrow, tr);
            cc.setParent(tr);
            tr.setTestRepeatID("r" + index);
            this.renderRow(tr, cc, index, value);
            this.m_visibleItemList.add(rrow, value);
            this.ml("rowAdded after adds: rrow=" + rrow + ", index=" + index);
            if (this.m_pageSize > 0 && this.m_dataBody.getChildCount() > this.m_pageSize) {
                lastChildIndex = this.m_dataBody.getChildCount() - 1;
                this.ml("rowAdded removing last BODY row at " + lastChildIndex);
                this.m_dataBody.removeChild(lastChildIndex);
            }
            if (this.m_pageSize > 0) {
                while (this.m_visibleItemList.size() > this.m_pageSize) {
                    lastChildIndex = this.m_visibleItemList.size() - 1;
                    this.ml("rowAdded removing last VISIBLE row at " + lastChildIndex);
                    this.m_visibleItemList.remove(lastChildIndex);
                }
                this.ml("rowAdded after pgsz delete visibleSz=" + this.m_visibleItemList.size());
            }
            this.handleOddEven(rrow);
            this.firePageChanged();
        }
        catch (Exception x) {
            System.err.println("Last DataTable actions:\n" + this.m_ml.getData());
            throw x;
        }
    }

    private void ml(String rest) {
        try {
            TBody dataBody = this.m_dataBody;
            int sz = dataBody == null ? -1 : dataBody.getChildCount();
            this.m_ml.add(rest + ": six=" + this.m_six + ", eix=" + this.m_eix + ", visibleSz=" + this.m_visibleItemList.size() + ", bodySz=" + sz + ", modelSz=" + this.getModel().getRows());
        }
        catch (Exception x) {
            this.m_ml.add("Exception adding to log stack: " + x);
        }
    }

    @Override
    public void rowDeleted(@Nonnull ITableModel<T> model, int index, @Nonnull T value) throws Exception {
        try {
            if (!this.isBuilt()) {
                return;
            }
            if (index < this.m_six || index >= this.m_eix) {
                this.calcIndices();
                this.firePageChanged();
                return;
            }
            int rrow = index - this.m_six;
            this.ml("rowDeleted before, index=" + index + ", rrow=" + rrow);
            this.m_dataBody.removeChild(rrow);
            this.m_visibleItemList.remove(rrow);
            if (this.m_dataBody.getChildCount() == 0) {
                this.calcIndices();
                this.setNoResults();
                this.firePageChanged();
                return;
            }
            int peix = this.m_six + this.m_pageSize - 1;
            if (this.m_pageSize > 0 && peix < this.m_eix && peix < this.getModel().getRows()) {
                this.ml("rowDelete grow page: peix=" + peix + ", rrow=" + rrow);
                ColumnContainer cc = new ColumnContainer(this);
                TR tr = new TR();
                cc.setParent(tr);
                Object mi = this.getModelItem(peix);
                this.m_dataBody.add(this.m_pageSize - 1, tr);
                this.renderRow(tr, cc, peix, mi);
                this.m_visibleItemList.add(this.m_pageSize - 1, mi);
            }
            this.calcIndices();
            this.handleOddEven(rrow);
            this.firePageChanged();
        }
        catch (IndexOutOfBoundsException x) {
            System.err.println("Last DataTable actions:\n" + this.m_ml.getData());
            throw new RuntimeException("Bug 7153 rowDelete index error " + x.getMessage() + "\n" + this.m_ml.getData(), x);
        }
        catch (Exception x) {
            System.err.println("Last DataTable actions:\n" + this.m_ml.getData());
            throw x;
        }
    }

    private void handleOddEven(int index) {
        for (int ix = index; ix < this.m_dataBody.getChildCount(); ++ix) {
            TR tr = (TR)this.m_dataBody.getChild(ix);
            if ((ix & 1) == 0) {
                tr.removeCssClass("ui-odd");
                tr.addCssClass("ui-even");
                continue;
            }
            tr.addCssClass("ui-odd");
            tr.removeCssClass("ui-even");
        }
    }

    @Override
    public void rowModified(@Nonnull ITableModel<T> model, int index, @Nonnull T value) throws Exception {
        if (!this.isBuilt()) {
            return;
        }
        if (index < this.m_six || index >= this.m_eix) {
            return;
        }
        try {
            int rrow = index - this.m_six;
            TR tr = (TR)this.m_dataBody.getChild(rrow);
            tr.removeAllChildren();
            this.m_visibleItemList.set(rrow, value);
            this.ml("rowModified: index=" + index + ", rrow=" + rrow);
            ColumnContainer cc = new ColumnContainer(this);
            cc.setParent(tr);
            this.renderRow(tr, cc, index, value);
        }
        catch (Exception x) {
            System.err.println("Last DataTable actions:\n" + this.m_ml.getData());
            throw x;
        }
    }

    public void setTableWidth(@Nullable String w) {
        this.m_table.setTableWidth(w);
    }

    @Nonnull
    public IRowRenderer<T> getRowRenderer() {
        return this.m_rowRenderer;
    }

    public void setRowRenderer(@Nonnull IRowRenderer<T> rowRenderer) {
        if (DomUtil.isEqual(this.m_rowRenderer, rowRenderer)) {
            return;
        }
        this.m_rowRenderer = rowRenderer;
        this.forceRebuild();
    }

    @Override
    protected void onForceRebuild() {
        this.m_visibleItemList.clear();
        this.ml("onForceRebuild, visiblesz cleared");
        this.m_lastSelectionLocation = -1;
        super.onForceRebuild();
    }

    @Override
    public void selectionChanged(@Nonnull T row, boolean on) throws Exception {
        for (int i = 0; i < this.m_visibleItemList.size(); ++i) {
            if (!MetaManager.areObjectsEqual(row, this.m_visibleItemList.get(i))) continue;
            this.updateSelectionChanged(row, i, on);
            return;
        }
    }

    @Override
    public void selectionAllChanged() throws Exception {
        ISelectionModel<T> sm = this.getSelectionModel();
        if (sm == null) {
            throw new IllegalStateException("Got selection changed event but selection model is empty?");
        }
        for (int i = 0; i < this.m_visibleItemList.size(); ++i) {
            T item = this.m_visibleItemList.get(i);
            this.updateSelectionChanged(item, i, sm.isSelected(item));
        }
    }

    @Nonnull
    private Checkbox createSelectionCheckbox(final @Nonnull T rowInstance, @Nullable ISelectionModel<T> selectionModel) {
        Checkbox cb = new Checkbox();
        boolean selectable = true;
        if (selectionModel instanceof IAcceptable) {
            selectable = ((IAcceptable)((Object)selectionModel)).acceptable(rowInstance);
        }
        if (selectable) {
            cb.setClicked(new IClicked2<Checkbox>(){

                @Override
                public void clicked(@Nonnull Checkbox clickednode, @Nonnull ClickInfo info) throws Exception {
                    DataTable.this.selectionCheckboxClicked(rowInstance, clickednode.isChecked(), info, clickednode);
                }
            });
        } else {
            cb.setReadOnly(true);
        }
        return cb;
    }

    public boolean isDisplayReadonlySelection() {
        return this.m_displayReadonlySelection;
    }

    public void setDisplayReadonlySelection(boolean displayReadonlySelection) {
        if (this.m_displayReadonlySelection == displayReadonlySelection) {
            return;
        }
        this.m_displayReadonlySelection = displayReadonlySelection;
        this.forceRebuild();
    }

    public boolean isShowHeaderAlways() {
        return this.m_showHeaderAlways;
    }

    public void setShowHeaderAlways(boolean showHeaderAlways) {
        this.m_showHeaderAlways = showHeaderAlways;
    }

    public boolean isPreventRowHighlight() {
        return this.m_preventRowHighlight;
    }

    public void setPreventRowHighlight(boolean preventRowHighlight) {
        this.m_preventRowHighlight = preventRowHighlight;
    }
}

