/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.tbl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.meta.SortableType;
import to.etc.domui.component.tbl.ColumnDefList;
import to.etc.domui.component.tbl.SimpleColumnDef;

public class ExpandedColumnDef<T> {
    @Nonnull
    private final ColumnDefList<?> m_defList;
    @Nonnull
    private List<SimpleColumnDef<?>> m_childColumns = Collections.EMPTY_LIST;
    @Nonnull
    private final Class<T> m_columnType;
    @Nonnull
    private final String m_propertyName;

    public ExpandedColumnDef(@Nonnull ColumnDefList<?> defList, @Nonnull Class<T> columnType, @Nonnull String propertyName) {
        this.m_defList = defList;
        this.m_columnType = columnType;
        this.m_propertyName = propertyName;
    }

    public boolean isSimple() {
        return this.m_childColumns.size() == 1;
    }

    @Nonnull
    public SimpleColumnDef<?> simple() {
        if (this.m_childColumns.size() != 1) {
            throw new IllegalStateException("Cannot call this with non-simple expanded column");
        }
        return this.m_childColumns.get(0);
    }

    @Nonnull
    public String getPropertyName() {
        return this.m_propertyName;
    }

    protected void addExpanded(@Nonnull SimpleColumnDef<?> ccd) {
        if (this.m_childColumns.size() == 0) {
            this.m_childColumns = new ArrayList();
        }
        this.m_childColumns.add(ccd);
    }

    @Nullable
    public String getWidth() {
        return this.simple().getWidth();
    }

    @Nonnull
    public ExpandedColumnDef<T> width(@Nullable String w) {
        this.simple().width(w);
        return this;
    }

    @Nonnull
    public SortableType getSortable() {
        return this.simple().getSortable();
    }

    private void setSortable(@Nonnull SortableType sortable) {
        this.simple().setSortable(sortable);
    }

    @Nonnull
    public ExpandedColumnDef<T> ascending() {
        this.setSortable(SortableType.SORTABLE_ASC);
        return this;
    }

    @Nonnull
    public ExpandedColumnDef<T> descending() {
        this.setSortable(SortableType.SORTABLE_DESC);
        return this;
    }

    @Nonnull
    public ExpandedColumnDef<T> sortdefault() {
        this.m_defList.setSortColumn(this.simple());
        return this;
    }
}

