/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.tbl;

import javax.annotation.DefaultNonNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.tbl.TableHeader;
import to.etc.domui.component.tbl.TableModelTableBase;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.dom.html.TH;
import to.etc.domui.dom.html.THead;
import to.etc.domui.dom.html.TR;
import to.etc.domui.dom.html.TextNode;

@DefaultNonNull
public final class HeaderContainer<T> {
    @Nullable
    private final String m_headerRowCSS;
    private TableModelTableBase<T> m_table;
    private final THead m_head;
    @Nullable
    private TR m_tr;
    private boolean m_finished;

    public HeaderContainer(TableModelTableBase<T> table, THead head, @Nullable String headerRowCSS) {
        this.m_table = table;
        this.m_head = head;
        this.m_headerRowCSS = headerRowCSS;
    }

    public TableModelTableBase<T> getTable() {
        return this.m_table;
    }

    public void addHeader(boolean after, @Nonnull TableHeader header) {
        if (after) {
            this.row();
            this.m_head.add(header);
        } else {
            TR tr = this.m_tr;
            if (null == tr) {
                this.m_head.add(header);
            } else {
                tr.appendBeforeMe(header);
            }
        }
        header.addCssClass("ui-dt-hdr-extra");
    }

    public final TR row() {
        this.m_finished = true;
        TR tr = this.m_tr;
        if (null == tr) {
            this.m_tr = tr = new TR();
            tr.setCssClass(this.m_headerRowCSS);
            this.m_head.add(tr);
        }
        return tr;
    }

    public TH add(@Nullable NodeBase columnContent) {
        TH td = new TH();
        this.row().add(td);
        if (columnContent != null) {
            td.add(columnContent);
        }
        return td;
    }

    public TH add(@Nullable String txt) {
        if (txt != null && (txt = txt.trim()) != null && txt.length() > 0) {
            return this.add(new TextNode(txt));
        }
        return this.add((NodeBase)null);
    }

    public boolean hasContent() {
        TR tr = this.m_tr;
        return tr != null && tr.getChildCount() > 0;
    }
}

