/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.tbl;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.tbl.AbstractSelectionModel;
import to.etc.domui.component.tbl.IAcceptable;
import to.etc.domui.component.tbl.ITableModel;

public class InstanceSelectionModel<T>
extends AbstractSelectionModel<T>
implements Iterable<T>,
IAcceptable<T> {
    private final Set<T> m_selectedSet = new HashSet<T>();
    private final boolean m_multiSelect;
    private final IAcceptable<T> m_acceptable;

    public InstanceSelectionModel(boolean multiSelect) {
        this(multiSelect, null);
    }

    public InstanceSelectionModel(boolean multiSelect, @Nullable IAcceptable<T> acceptable) {
        this.m_multiSelect = multiSelect;
        this.m_acceptable = acceptable;
    }

    @Override
    public final boolean isMultiSelect() {
        return this.m_multiSelect;
    }

    @Override
    public int getSelectionCount() {
        return this.m_selectedSet.size();
    }

    @Override
    public boolean acceptable(@Nonnull T value) {
        IAcceptable<T> acceptor = this.m_acceptable;
        if (acceptor != null) {
            return acceptor.acceptable(value);
        }
        return true;
    }

    @Override
    public boolean isSelected(@Nonnull T rowinstance) {
        if (null == rowinstance) {
            throw new IllegalArgumentException("null row");
        }
        return this.m_selectedSet.contains(rowinstance);
    }

    @Override
    public void setInstanceSelected(@Nonnull T rowinstance, boolean on) throws Exception {
        if (null == rowinstance) {
            throw new IllegalArgumentException("null row");
        }
        if (on) {
            if (this.m_acceptable != null && !this.m_acceptable.acceptable(rowinstance)) {
                return;
            }
            if (!this.m_multiSelect && this.m_selectedSet.size() > 0) {
                T old = this.m_selectedSet.iterator().next();
                if (rowinstance.equals(old)) {
                    return;
                }
                this.m_selectedSet.clear();
                this.callChanged(old, false);
            }
            if (!this.m_selectedSet.add(rowinstance)) {
                return;
            }
            this.callChanged(rowinstance, true);
        } else {
            if (!this.m_selectedSet.remove(rowinstance)) {
                return;
            }
            this.callChanged(rowinstance, false);
        }
    }

    @Override
    public void clearSelection() throws Exception {
        if (this.m_selectedSet.size() == 0) {
            return;
        }
        this.m_selectedSet.clear();
        this.callSelectionAllChanged();
    }

    @Override
    public void selectAll(ITableModel<T> in) throws Exception {
        int index = 0;
        int rows = in.getRows();
        while (index < rows) {
            int eix = index + 50;
            if (eix > rows) {
                eix = rows;
            }
            List<T> itemlist = in.getItems(index, eix);
            for (T item : itemlist) {
                if (this.m_acceptable != null && !this.m_acceptable.acceptable(item)) continue;
                this.m_selectedSet.add(item);
            }
            index = eix;
        }
        this.callSelectionAllChanged();
    }

    @Override
    public Iterator<T> iterator() {
        return this.m_selectedSet.iterator();
    }

    @Nonnull
    public Set<T> getSelectedSet() {
        return new HashSet<T>(this.m_selectedSet);
    }

    @Nullable
    public T getSelected() {
        if (this.isMultiSelect()) {
            throw new IllegalStateException("This call is invalid for multi-select");
        }
        if (this.m_selectedSet.size() == 0) {
            return null;
        }
        return this.getSelectedSet().iterator().next();
    }

    public void setSelectedSet(@Nonnull Collection<T> in) throws Exception {
        if (null == in) {
            this.clearSelection();
            return;
        }
        HashSet<T> old = new HashSet<T>(this.m_selectedSet);
        for (T data : in) {
            if (old.remove(data)) continue;
            this.setInstanceSelected(data, true);
        }
        for (Object s : old) {
            this.setInstanceSelected(s, false);
        }
    }
}

