/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.tbl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import to.etc.domui.component.tbl.AbstractSelectionModel;
import to.etc.domui.component.tbl.ITableModel;
import to.etc.webapp.query.IIdentifyable;

public class KeySelectionModel<T, K>
extends AbstractSelectionModel<T> {
    private final Map<K, T> m_selectedSet = new HashMap<K, T>();
    private final boolean m_multiSelect;
    private final boolean m_retainInstances;

    public KeySelectionModel(boolean multiSelect, boolean retainInstances) {
        this.m_multiSelect = multiSelect;
        this.m_retainInstances = retainInstances;
    }

    public KeySelectionModel(boolean multiSelect) {
        this(multiSelect, false);
    }

    @Override
    public boolean isMultiSelect() {
        return this.m_multiSelect;
    }

    @Override
    public boolean isSelected(@Nonnull T rowinstance) {
        if (null == rowinstance) {
            throw new IllegalArgumentException("null row");
        }
        return this.m_selectedSet.containsKey(this.getKey(rowinstance));
    }

    public K getKey(@Nonnull T rowinstance) {
        if (rowinstance instanceof IIdentifyable) {
            return (K)((IIdentifyable)rowinstance).getId();
        }
        if (null == rowinstance) {
            throw new IllegalArgumentException("null row");
        }
        throw new IllegalStateException("The instance needs to implement IIdentifyable<K>, or the getKey() method needs to be overridden.");
    }

    @Override
    public int getSelectionCount() {
        return this.m_selectedSet.size();
    }

    @Override
    public void setInstanceSelected(@Nonnull T rowinstance, boolean on) throws Exception {
        if (null == rowinstance) {
            throw new IllegalArgumentException("null row");
        }
        K key = this.getKey(rowinstance);
        if (on) {
            if (!this.m_multiSelect && this.m_selectedSet.size() > 0) {
                T old = this.m_selectedSet.values().iterator().next();
                if (rowinstance.equals(old)) {
                    return;
                }
                this.m_selectedSet.clear();
                this.callChanged(old, false);
            }
            if (this.m_selectedSet.containsKey(key)) {
                return;
            }
            this.m_selectedSet.put(key, this.m_retainInstances ? rowinstance : null);
            this.callChanged(rowinstance, true);
        } else {
            if (!this.m_selectedSet.containsKey(key)) {
                return;
            }
            this.m_selectedSet.remove(this.getKey(rowinstance));
            this.callChanged(rowinstance, false);
        }
    }

    @Override
    public void clearSelection() throws Exception {
        if (this.m_selectedSet.size() == 0) {
            return;
        }
        this.m_selectedSet.clear();
        this.callSelectionAllChanged();
    }

    @Override
    public void selectAll(ITableModel<T> in) throws Exception {
        int index = 0;
        int rows = in.getRows();
        while (index < rows) {
            int eix = index + 50;
            if (eix > rows) {
                eix = rows;
            }
            List<T> itemlist = in.getItems(index, eix);
            for (T item : itemlist) {
                K key = this.getKey(item);
                this.m_selectedSet.put(key, this.m_retainInstances ? item : null);
            }
            index = eix;
        }
        this.callSelectionAllChanged();
    }

    public List<T> getSelectedInstances() {
        if (!this.m_retainInstances) {
            throw new IllegalStateException("Selection model is not set to retain instances!");
        }
        return new ArrayList<T>(this.m_selectedSet.values());
    }

    public Set<K> getSelectedKeys() {
        return new HashSet<K>(this.m_selectedSet.keySet());
    }
}

