/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.tbl;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.buttons.DefaultButton;
import to.etc.domui.component.meta.ClassMetaModel;
import to.etc.domui.component.meta.MetaManager;
import to.etc.domui.component.tbl.IMovableShuttleModel;
import to.etc.domui.component.tbl.IShuttleModel;
import to.etc.domui.component.tbl.ITableModel;
import to.etc.domui.component.tbl.ITableModelListener;
import to.etc.domui.dom.css.Overflow;
import to.etc.domui.dom.html.Div;
import to.etc.domui.dom.html.IClicked;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.dom.html.TBody;
import to.etc.domui.dom.html.TD;
import to.etc.domui.dom.html.TR;
import to.etc.domui.dom.html.Table;
import to.etc.domui.dom.html.TableVAlign;
import to.etc.domui.server.DomApplication;
import to.etc.domui.util.INodeContentRenderer;

public class ListShuttle
extends Div
implements ITableModelListener<Object> {
    private TBody m_body;
    private boolean m_orderable;
    private TD m_sourceCell;
    private TD m_targetCell;
    private TD m_orderCell;
    private TBody m_sourceBody;
    private TBody m_targetBody;
    private Div m_sourceDiv;
    private Div m_targetDiv;
    private IShuttleModel<Object, Object> m_model;
    private ITableModel<Object> m_sourceModel;
    private ITableModel<Object> m_targetModel;
    private Class<? extends INodeContentRenderer<?>> m_sourceRendererClass;
    private Class<? extends INodeContentRenderer<?>> m_targetRendererClass;
    private INodeContentRenderer<Object> m_sourceRenderer;
    private INodeContentRenderer<Object> m_targetRenderer;
    private static final int INNERHEIGHT = 400;
    private static IClicked<TD> C_CLICK = new IClicked<TD>(){

        @Override
        public void clicked(@Nonnull TD b) throws Exception {
            if (b.hasCssClass("selected")) {
                b.removeCssClass("selected");
            } else {
                b.addCssClass("selected");
            }
        }
    };

    @Override
    public void createContent() throws Exception {
        this.setCssClass("ui-sh");
        Table t = new Table();
        this.add(t);
        this.m_body = new TBody();
        t.add(this.m_body);
        this.m_body.addRow();
        this.m_sourceCell = this.m_body.addCell();
        TD midcell = this.m_body.addCell();
        this.m_targetCell = this.m_body.addCell();
        this.m_sourceCell.setCssClass("ui-sh-sc");
        this.m_targetCell.setCssClass("ui-sh-tc");
        this.m_sourceDiv = new Div();
        this.m_sourceCell.add(this.m_sourceDiv);
        this.m_targetDiv = new Div();
        this.m_targetCell.add(this.m_targetDiv);
        this.m_sourceDiv.setCssClass("ui-sh-scd");
        this.m_targetDiv.setCssClass("ui-sh-tcd");
        this.m_sourceDiv.setHeight("400px");
        this.m_targetDiv.setHeight("400px");
        this.m_sourceDiv.setOverflow(Overflow.AUTO);
        this.m_targetDiv.setOverflow(Overflow.AUTO);
        this.m_sourceCell.setValign(TableVAlign.TOP);
        this.m_targetCell.setValign(TableVAlign.TOP);
        this.createMiddle(midcell);
        this.createOrderPane();
        this.renderSource();
        this.renderTarget();
    }

    private void createOrderPane() {
        this.m_orderCell = this.m_body.addCell();
        this.m_orderCell.setCssClass("ui-sh-oc");
        Table t = new Table();
        if (this.needOrderButtons()) {
            this.m_orderCell.add(t);
        }
        TBody b = new TBody();
        t.add(b);
        DefaultButton ib = new DefaultButton("", "THEME/sh-up.png", new IClicked<DefaultButton>(){

            @Override
            public void clicked(@Nonnull DefaultButton xb) throws Exception {
                ListShuttle.this.moveUp();
            }
        });
        b.addRowAndCell().add(ib);
        ib = new DefaultButton("", "THEME/sh-down.png", new IClicked<DefaultButton>(){

            @Override
            public void clicked(@Nonnull DefaultButton xb) throws Exception {
                ListShuttle.this.moveDown();
            }
        });
        b.addRowAndCell().add(ib);
    }

    private void createMiddle(TD mid) {
        mid.setCssClass("ui-sh-bc");
        Table t = new Table();
        mid.add(t);
        TBody b = new TBody();
        t.add(b);
        DefaultButton ib = new DefaultButton("", "THEME/sh-2ar-right.png", new IClicked<DefaultButton>(){

            @Override
            public void clicked(@Nonnull DefaultButton clickednode) throws Exception {
                ListShuttle.this.moveRight();
            }
        });
        b.addRowAndCell().add(ib);
        ib = new DefaultButton("", "THEME/sh-1ar-right.png", new IClicked<DefaultButton>(){

            @Override
            public void clicked(@Nonnull DefaultButton xb) throws Exception {
                ListShuttle.this.moveRight();
            }
        });
        b.addRowAndCell().add(ib);
        ib = new DefaultButton("", "THEME/sh-1ar-left.png", new IClicked<DefaultButton>(){

            @Override
            public void clicked(@Nonnull DefaultButton xb) throws Exception {
                ListShuttle.this.moveLeft();
            }
        });
        b.addRowAndCell().add(ib);
        ib = new DefaultButton("", "THEME/sh-2ar-left.png", new IClicked<DefaultButton>(){

            @Override
            public void clicked(@Nonnull DefaultButton clickednode) throws Exception {
                ListShuttle.this.moveLeft();
            }
        });
        b.addRowAndCell().add(ib);
    }

    private void renderSource() throws Exception {
        Table t = new Table();
        this.m_sourceDiv.add(t);
        this.m_sourceBody = new TBody();
        t.add(this.m_sourceBody);
        if (this.m_sourceModel == null) {
            return;
        }
        int count = this.m_sourceModel.getRows();
        if (count == 0) {
            return;
        }
        List<Object> list = this.m_sourceModel.getItems(0, count);
        INodeContentRenderer<Object> r = null;
        for (int i = 0; i < count; ++i) {
            TD td = this.m_sourceBody.addRowAndCell();
            Object value = list.get(i);
            if (r == null) {
                r = this.calculateSourceRenderer(value);
            }
            r.renderNodeContent(this, td, value, null);
            td.setClicked(C_CLICK);
        }
    }

    private void renderTarget() throws Exception {
        Table t = new Table();
        this.m_targetDiv.add(t);
        this.m_targetBody = new TBody();
        t.add(this.m_targetBody);
        if (this.m_targetModel == null) {
            return;
        }
        int count = this.m_targetModel.getRows();
        if (count == 0) {
            return;
        }
        List<Object> list = this.m_targetModel.getItems(0, count);
        INodeContentRenderer<Object> r = null;
        for (int i = 0; i < count; ++i) {
            TD td = this.m_targetBody.addRowAndCell();
            Object value = list.get(i);
            if (r == null) {
                r = this.calculateTargetRenderer(value);
            }
            r.renderNodeContent(this, td, value, null);
            td.setClicked(C_CLICK);
        }
    }

    private boolean needOrderButtons() {
        return this.isOrderable() && this.getModel() instanceof IMovableShuttleModel;
    }

    private INodeContentRenderer<Object> calculateSourceRenderer(Object val) {
        if (this.m_sourceRenderer != null) {
            return this.m_sourceRenderer;
        }
        if (this.m_sourceRendererClass != null) {
            return DomApplication.get().createInstance(this.m_sourceRendererClass, new Object[0]);
        }
        if (val == null) {
            throw new IllegalStateException("Cannot calculate content renderer for null value");
        }
        ClassMetaModel cmm = MetaManager.findClassMeta(val.getClass());
        return MetaManager.createDefaultComboRenderer(null, cmm);
    }

    private INodeContentRenderer<Object> calculateTargetRenderer(Object val) {
        if (this.m_targetRenderer != null) {
            return this.m_targetRenderer;
        }
        if (this.m_targetRendererClass != null) {
            return DomApplication.get().createInstance(this.m_targetRendererClass, new Object[0]);
        }
        if (val == null) {
            throw new IllegalStateException("Cannot calculate content renderer for null value");
        }
        ClassMetaModel cmm = MetaManager.findClassMeta(val.getClass());
        return MetaManager.createDefaultComboRenderer(null, cmm);
    }

    void moveRight() throws Exception {
        int ix = this.m_sourceBody.getChildCount();
        while (--ix >= 0) {
            NodeBase tb = this.m_sourceBody.getChild(ix);
            if (!(tb instanceof TR)) {
                throw new IllegalStateException("?? Unexpected node: " + tb);
            }
            TR tr = (TR)tb;
            TD td = (TD)tr.getChild(0);
            if (!td.hasCssClass("selected")) continue;
            this.m_model.moveSourceToTarget(ix, 9999);
        }
    }

    void moveLeft() throws Exception {
        int ix = this.m_targetBody.getChildCount();
        while (--ix >= 0) {
            NodeBase tb = this.m_targetBody.getChild(ix);
            if (!(tb instanceof TR)) {
                throw new IllegalStateException("?? Unexpected node: " + tb);
            }
            TR tr = (TR)tb;
            TD td = (TD)tr.getChild(0);
            if (!td.hasCssClass("selected")) continue;
            this.m_model.moveTargetToSource(ix);
        }
    }

    void moveUp() throws Exception {
        for (int ix = 0; ix < this.m_targetBody.getChildCount(); ++ix) {
            NodeBase tb = this.m_targetBody.getChild(ix);
            if (!(tb instanceof TR)) {
                throw new IllegalStateException("?? Unexpected node: " + tb);
            }
            TR tr = (TR)tb;
            TD td = (TD)tr.getChild(0);
            if (!td.hasCssClass("selected")) continue;
            if (ix == 0) {
                return;
            }
            ((IMovableShuttleModel)this.m_model).moveTargetItem(ix, ix - 1);
            this.reselect(ix - 1);
        }
    }

    void moveDown() throws Exception {
        int ix = this.m_targetBody.getChildCount();
        while (--ix >= 0) {
            NodeBase tb = this.m_targetBody.getChild(ix);
            if (!(tb instanceof TR)) {
                throw new IllegalStateException("?? Unexpected node: " + tb);
            }
            TR tr = (TR)tb;
            TD td = (TD)tr.getChild(0);
            if (!td.hasCssClass("selected")) continue;
            if (ix >= this.m_targetBody.getChildCount() - 1) {
                return;
            }
            ((IMovableShuttleModel)this.m_model).moveTargetItem(ix, ix + 1);
            this.reselect(ix + 1);
        }
    }

    private void reselect(int ix) {
        NodeBase tb = this.m_targetBody.getChild(ix);
        if (!(tb instanceof TR)) {
            throw new IllegalStateException("?? Unexpected node: " + tb);
        }
        TR tr = (TR)tb;
        TD td = (TD)tr.getChild(0);
        td.setCssClass("selected");
    }

    public IShuttleModel<?, ?> getModel() {
        return this.m_model;
    }

    public void setModel(IShuttleModel<?, ?> model) {
        if (this.m_model == model) {
            return;
        }
        this.m_model = model;
        ITableModel<Object> tm = this.m_model.getSourceModel();
        if (this.m_sourceModel != tm) {
            if (this.m_sourceModel != null) {
                this.m_sourceModel.removeChangeListener(this);
            }
            this.m_sourceModel = tm;
            if (this.m_sourceModel != null) {
                this.m_sourceModel.addChangeListener(this);
            }
            this.forceRebuild();
        }
        if (this.m_targetModel != (tm = this.m_model.getTargetModel())) {
            if (this.m_targetModel != null) {
                this.m_targetModel.removeChangeListener(this);
            }
            this.m_targetModel = tm;
            if (this.m_targetModel != null) {
                this.m_targetModel.addChangeListener(this);
            }
            this.forceRebuild();
        }
    }

    @Override
    public void modelChanged(@Nullable ITableModel<Object> model) {
        this.forceRebuild();
    }

    @Override
    public void rowAdded(@Nonnull ITableModel<Object> model, int index, @Nonnull Object value) throws Exception {
        boolean issrc = model == this.m_sourceModel;
        TBody b = issrc ? this.m_sourceBody : this.m_targetBody;
        TR tr = new TR();
        TD td = new TD();
        tr.add(td);
        td.setClicked(C_CLICK);
        INodeContentRenderer<Object> r = issrc ? this.calculateSourceRenderer(value) : this.calculateTargetRenderer(value);
        r.renderNodeContent(this, td, value, null);
        b.add(index, tr);
    }

    @Override
    public void rowDeleted(@Nonnull ITableModel<Object> model, int index, @Nonnull Object value) throws Exception {
        boolean issrc = model == this.m_sourceModel;
        TBody b = issrc ? this.m_sourceBody : this.m_targetBody;
        b.removeChild(index);
    }

    @Override
    public void rowModified(@Nonnull ITableModel<Object> model, int index, @Nonnull Object value) throws Exception {
        boolean issrc = model == this.m_sourceModel;
        TBody b = issrc ? this.m_sourceBody : this.m_targetBody;
        TR tr = (TR)b.getChild(index);
        TD td = (TD)tr.getChild(0);
        td.removeAllChildren();
        INodeContentRenderer<Object> r = issrc ? this.calculateSourceRenderer(value) : this.calculateTargetRenderer(value);
        r.renderNodeContent(this, td, value, null);
    }

    public INodeContentRenderer<Object> getSourceRenderer() {
        return this.m_sourceRenderer;
    }

    public void setSourceRenderer(INodeContentRenderer<Object> sourceRenderer) {
        this.m_sourceRenderer = sourceRenderer;
    }

    public INodeContentRenderer<Object> getTargetRenderer() {
        return this.m_targetRenderer;
    }

    public void setTargetRenderer(INodeContentRenderer<Object> targetRenderer) {
        this.m_targetRenderer = targetRenderer;
    }

    public boolean isOrderable() {
        return this.m_orderable;
    }

    public Class<? extends INodeContentRenderer<?>> getSourceRendererClass() {
        return this.m_sourceRendererClass;
    }

    public void setSourceRendererClass(Class<? extends INodeContentRenderer<?>> sourceRendererClass) {
        this.m_sourceRendererClass = sourceRendererClass;
    }

    public Class<? extends INodeContentRenderer<?>> getTargetRendererClass() {
        return this.m_targetRendererClass;
    }

    public void setTargetRendererClass(Class<? extends INodeContentRenderer<?>> targetRendererClass) {
        this.m_targetRendererClass = targetRendererClass;
    }

    public void setOrderable(boolean orderable) {
        this.m_orderable = orderable;
    }
}

