/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.tbl;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.tbl.ColumnContainer;
import to.etc.domui.component.tbl.DataTable;
import to.etc.domui.component.tbl.HeaderContainer;
import to.etc.domui.component.tbl.ICellClicked;
import to.etc.domui.component.tbl.IRowRenderer;
import to.etc.domui.component.tbl.ITableModel;
import to.etc.domui.dom.html.Checkbox;
import to.etc.domui.dom.html.ClickInfo;
import to.etc.domui.dom.html.Div;
import to.etc.domui.dom.html.IClicked;
import to.etc.domui.dom.html.IClicked2;
import to.etc.domui.dom.html.Img;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.dom.html.TBody;
import to.etc.domui.dom.html.TD;
import to.etc.domui.dom.html.THead;
import to.etc.domui.dom.html.TR;
import to.etc.domui.dom.html.Table;
import to.etc.domui.util.Msgs;

public class MultipleSelectionDataTable<T>
extends DataTable<T> {
    @Nonnull
    private List<T> m_accumulatedRows = new ArrayList<T>();
    @Nonnull
    List<Boolean> m_accumulatedSelections = new ArrayList<Boolean>();
    @Nullable
    private String m_selectionColTitle;

    public MultipleSelectionDataTable(@Nonnull Class<T> dataClass, @Nonnull ITableModel<T> m, @Nonnull IRowRenderer<T> r) {
        super(m, r);
    }

    @Override
    public void createContent() throws Exception {
        this.setCssClass("ui-dt");
        this.getRowRenderer().beforeQuery(this);
        this.calcIndices();
        List list = this.getPageItems();
        if (this.m_accumulatedRows.size() > 0 || list.size() > 0) {
            this.getTable().removeAllChildren();
            Table t = this.getTable();
            if (null == t) {
                throw new IllegalStateException("?");
            }
            this.add(t);
            THead hd = new THead();
            this.getTable().add(hd);
            HeaderContainer hc = new HeaderContainer(this, hd, "ui-dt-hdr");
            Img selImg = new Img("THEME/dspcb-on.png");
            selImg.setTitle(this.getSelectionColTitle() == null ? Msgs.BUNDLE.getString("ui.mlui.col.ttl") : this.getSelectionColTitle());
            selImg.setTestID("msdt_select_all");
            hc.add(selImg);
            this.getRowRenderer().renderHeader(this, hc);
            this.setDataBody(new TBody());
            this.getTable().add(this.getDataBody());
            ColumnContainer cc = new ColumnContainer(this);
            for (int index = 0; index < this.m_accumulatedRows.size(); ++index) {
                T accumulatedItem = this.m_accumulatedRows.get(index);
                TR tr = new TR();
                this.getDataBody().add(tr);
                boolean selected = this.m_accumulatedSelections.size() > index ? this.m_accumulatedSelections.get(index) : false;
                this.renderAccumulatedItem(tr, cc, accumulatedItem, selected, index);
            }
            if (this.m_accumulatedRows.size() > 0) {
                TR splitterRow = this.createSplitterRow();
                this.getDataBody().add(splitterRow);
            }
            int ix = this.m_six;
            for (Object item : list) {
                TR tr = new TR();
                this.getDataBody().add(tr);
                cc.setParent(tr);
                TD selectionMarkerCell = new TD();
                if (!this.m_accumulatedRows.contains(item)) {
                    Img imgAddToSelection = new Img("THEME/addToSelection.png");
                    selectionMarkerCell.add(imgAddToSelection);
                } else {
                    selectionMarkerCell.add(" ");
                }
                selectionMarkerCell.setUserObject(item);
                tr.add(selectionMarkerCell);
                ICellClicked<?> rowClicked = this.getRowRenderer().getRowClicked();
                if (rowClicked != null) {
                    final TR therow = tr;
                    final Object theitem = item;
                    cc.getTR().setClicked(new IClicked2<TR>(){

                        @Override
                        public void clicked(@Nonnull TR b, @Nonnull ClickInfo clinfo) throws Exception {
                            ICellClicked<?> rowClicked = MultipleSelectionDataTable.this.getRowRenderer().getRowClicked();
                            if (null != rowClicked) {
                                rowClicked.cellClicked(therow, theitem);
                            }
                        }
                    });
                    cc.getTR().addCssClass("ui-rowsel");
                }
                this.getRowRenderer().renderRow(this, cc, ix, item);
                ++ix;
            }
        }
        if (list.size() == 0) {
            Div error = new Div();
            error.setCssClass("ui-dt-nores");
            error.setText(Msgs.BUNDLE.getString("ui.dt.empty"));
            this.add(error);
        }
    }

    private TR createSplitterRow() {
        if (this.getDataBody().getChildCount() == 0) {
            throw new IllegalStateException("Missing childs!");
        }
        TR headerRow = this.getDataBody().getRow(0);
        TR splitterRow = new TR();
        TD splitterCell = new TD();
        splitterCell.setText(" ");
        splitterCell.setCssClass("ui-dt-separator");
        splitterCell.setColspan(headerRow.getChildCount());
        splitterRow.add(splitterCell);
        return splitterRow;
    }

    private void renderAccumulatedItem(TR tr, ColumnContainer<T> cc, T item, boolean selected, int index) throws Exception {
        cc.setParent(tr);
        Checkbox b = new Checkbox();
        b.setClicked(new IClicked<Checkbox>(){

            @Override
            public void clicked(@Nonnull Checkbox ckb) throws Exception {
                TR row = ckb.getParent(TR.class);
                MultipleSelectionDataTable.this.handleAccumulatedItemRowSelectionChanged(row, ckb.isChecked());
            }
        });
        b.setChecked(selected);
        TD selectionCell = new TD();
        selectionCell.add(b);
        tr.add(selectionCell);
        tr.setUserObject(b);
        tr.setClicked(new IClicked<TR>(){

            @Override
            public void clicked(@Nonnull TR row) throws Exception {
                Object userObject = row.getUserObject();
                if (userObject instanceof Checkbox) {
                    ((Checkbox)userObject).setChecked(!((Checkbox)userObject).isChecked());
                }
            }
        });
        ICellClicked<?> rowClicked = this.getRowRenderer().getRowClicked();
        if (rowClicked != null) {
            final TR therow = tr;
            final T theitem = item;
            cc.getTR().setClicked(new IClicked2<TR>(){

                @Override
                public void clicked(@Nonnull TR b, @Nonnull ClickInfo clinfo) throws Exception {
                    ICellClicked<?> rowClicked = MultipleSelectionDataTable.this.getRowRenderer().getRowClicked();
                    if (null != rowClicked) {
                        rowClicked.cellClicked(therow, theitem);
                    }
                }
            });
            cc.getTR().addCssClass("ui-rowsel");
        }
        this.getRowRenderer().renderRow(this, cc, index, item);
    }

    protected void handleAccumulatedItemRowSelectionChanged(TR row, Boolean value) {
        int index = this.getDataBody().getChildren(TR.class).indexOf(row);
        if (this.m_accumulatedSelections.size() > index) {
            this.m_accumulatedSelections.set(index, value);
        }
    }

    public void accumulateSelection(TR row, T item) throws Exception {
        if (!this.m_accumulatedRows.contains(item)) {
            this.m_accumulatedRows.add(item);
            this.m_accumulatedSelections.add(Boolean.TRUE);
            TR tr = new TR();
            this.getDataBody().add(this.m_accumulatedRows.size() - 1, tr);
            ColumnContainer cc = new ColumnContainer(this);
            this.renderAccumulatedItem(tr, cc, item, true, this.m_accumulatedRows.size() - 1);
            if (this.m_accumulatedRows.size() == 1) {
                TR splitterRow = this.createSplitterRow();
                this.getDataBody().add(this.m_accumulatedRows.size(), splitterRow);
            }
            if (row.getChildren(TD.class).size() == 0) {
                throw new IllegalStateException("Missing row childs!");
            }
            TD selectionMarkerCell = row.getChildren(TD.class).get(0);
            selectionMarkerCell.removeAllChildren();
            selectionMarkerCell.add(" ");
        }
    }

    @Override
    public void setModel(@Nonnull ITableModel<T> model) {
        this.clearDeselectedAccumulatedRows();
        super.setModel(model);
    }

    private void clearDeselectedAccumulatedRows() {
        for (int index = this.m_accumulatedSelections.size() - 1; index >= 0; --index) {
            boolean selected = this.m_accumulatedSelections.get(index);
            if (selected) continue;
            this.m_accumulatedSelections.remove(index);
            if (this.m_accumulatedRows.size() <= index) continue;
            this.m_accumulatedRows.remove(index);
        }
    }

    public void handleRowClicked(NodeBase tr, T val) throws Exception {
        if (tr instanceof TR) {
            if (tr.getUserObject() instanceof Checkbox) {
                Checkbox ckb = (Checkbox)tr.getUserObject();
                if (null == ckb) {
                    throw new IllegalStateException("No checkbox??");
                }
                ckb.setChecked(!ckb.isChecked());
                this.handleAccumulatedItemRowSelectionChanged((TR)tr, ckb.isChecked());
            } else {
                this.accumulateSelection((TR)tr, val);
            }
        } else {
            throw new IllegalStateException("expected TR: " + tr);
        }
    }

    public List<T> getAccumulatedResults() {
        ArrayList<T> results = new ArrayList<T>();
        for (int index = 0; index < this.m_accumulatedRows.size(); ++index) {
            boolean selected;
            boolean bl = selected = this.m_accumulatedSelections.size() > index ? this.m_accumulatedSelections.get(index) : false;
            if (!selected) continue;
            results.add(this.m_accumulatedRows.get(index));
        }
        return results;
    }

    public String getSelectionColTitle() {
        return this.m_selectionColTitle;
    }

    public void setSelectionColTitle(String selectionColTitle) {
        this.m_selectionColTitle = selectionColTitle;
    }

    public void addAllSearchResultsToAccumulatedResults() throws Exception {
        this.m_accumulatedRows.clear();
        this.m_accumulatedSelections.clear();
        for (Object item : this.getModel().getItems(0, this.getModel().getRows())) {
            this.m_accumulatedRows.add(item);
            this.m_accumulatedSelections.add(Boolean.TRUE);
        }
    }
}

