/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.tbl;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.tbl.ITableModel;
import to.etc.domui.component.tbl.ITableModelListener;
import to.etc.domui.component.tbl.ITruncateableDataModel;
import to.etc.domui.component.tbl.SelectableTabularComponent;

public abstract class PageableTabularComponentBase<T>
extends SelectableTabularComponent<T>
implements ITableModelListener<T> {
    private int m_currentPage;
    protected int m_six;
    protected int m_eix;

    protected abstract int getPageSize();

    public PageableTabularComponentBase(ITableModel<T> model) {
        super(model);
    }

    public PageableTabularComponentBase() {
    }

    @Override
    protected void fireModelChanged(@Nullable ITableModel<T> old, @Nullable ITableModel<T> model) {
        super.fireModelChanged(old, model);
    }

    @Override
    protected void resetState() {
        this.m_currentPage = 0;
    }

    protected void calcIndices() throws Exception {
        int size = this.getModel().getRows();
        int pageSize = this.getPageSize();
        if (pageSize <= 0) {
            this.m_six = 0;
            this.m_eix = size;
        } else {
            this.m_six = this.m_currentPage * pageSize;
            if (this.m_six >= size) {
                int lp = size / pageSize;
                this.m_six = lp * pageSize;
            }
            this.m_eix = this.m_six + pageSize;
            if (this.m_eix > size) {
                this.m_eix = size;
            }
        }
    }

    @Nonnull
    protected List<T> getPageItems() throws Exception {
        return this.getModel().getItems(this.m_six, this.m_eix);
    }

    public int getCurrentPage() {
        return this.m_currentPage;
    }

    public void setCurrentPage(int currentPage) {
        if (this.m_currentPage < 0 || currentPage != 0 && this.getPageSize() <= 0) {
            throw new IllegalStateException("Cannot set current page to " + currentPage);
        }
        if (this.m_currentPage == currentPage) {
            return;
        }
        this.m_currentPage = currentPage;
        this.forceRebuild();
        this.firePageChanged();
    }

    public int getPageCount() throws Exception {
        int pageSize = this.getPageSize();
        if (pageSize <= 0) {
            return 1;
        }
        return (this.getModel().getRows() + pageSize - 1) / pageSize;
    }

    public int getTruncatedCount() throws Exception {
        ITableModel tm = this.getModel();
        if (tm == null || !(tm instanceof ITruncateableDataModel)) {
            return 0;
        }
        ITruncateableDataModel t = (ITruncateableDataModel)((Object)tm);
        if (t.isTruncated()) {
            return this.getModel().getRows();
        }
        return 0;
    }
}

