/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.tbl;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.meta.MetaManager;
import to.etc.domui.component.tbl.ColumnContainer;
import to.etc.domui.component.tbl.HeaderContainer;
import to.etc.domui.component.tbl.IAcceptable;
import to.etc.domui.component.tbl.ICellClicked;
import to.etc.domui.component.tbl.IRowRenderer;
import to.etc.domui.component.tbl.ISelectableTableComponent;
import to.etc.domui.component.tbl.ISelectionListener;
import to.etc.domui.component.tbl.ISelectionModel;
import to.etc.domui.component.tbl.ITableModel;
import to.etc.domui.component.tbl.SelectableTabularComponent;
import to.etc.domui.dom.css.Overflow;
import to.etc.domui.dom.html.Checkbox;
import to.etc.domui.dom.html.ClickInfo;
import to.etc.domui.dom.html.Div;
import to.etc.domui.dom.html.IClicked;
import to.etc.domui.dom.html.IClicked2;
import to.etc.domui.dom.html.Img;
import to.etc.domui.dom.html.TBody;
import to.etc.domui.dom.html.TD;
import to.etc.domui.dom.html.TH;
import to.etc.domui.dom.html.THead;
import to.etc.domui.dom.html.TR;
import to.etc.domui.dom.html.Table;
import to.etc.domui.server.RequestContextImpl;
import to.etc.domui.util.DomUtil;
import to.etc.domui.util.JavascriptUtil;
import to.etc.domui.util.Msgs;

@Deprecated
public final class ScrollableDataTable<T>
extends SelectableTabularComponent<T>
implements ISelectionListener<T>,
ISelectableTableComponent<T> {
    private static final boolean DEBUG = true;
    private IRowRenderer<T> m_rowRenderer;
    @Nullable
    private Table m_dataTable;
    private TBody m_dataBody;
    private Div m_errorDiv;
    private final List<T> m_visibleItemList = new ArrayList<T>();
    private boolean m_multiSelectMode;
    private int m_lastSelectionLocation = -1;
    private int m_nextIndexToLoad;
    private int m_batchSize = 80;
    private boolean m_allRendered;
    @Nonnull
    private final IClicked<TH> m_headerSelectClickHandler = new IClicked<TH>(){

        @Override
        public void clicked(@Nonnull TH clickednode) throws Exception {
            if (ScrollableDataTable.this.isDisabled()) {
                return;
            }
            ISelectionModel sm = ScrollableDataTable.this.getSelectionModel();
            if (null == sm) {
                return;
            }
            int ct = sm.getSelectionCount();
            if (0 == ct && sm.isMultiSelect()) {
                sm.selectAll(ScrollableDataTable.this.getModel());
            } else {
                sm.clearSelection();
            }
        }
    };
    private boolean m_redrawn;

    public ScrollableDataTable(@Nonnull ITableModel<T> m, @Nonnull IRowRenderer<T> r) {
        super(m);
        this.m_rowRenderer = r;
    }

    public ScrollableDataTable(@Nonnull IRowRenderer<T> r) {
        this.m_rowRenderer = r;
    }

    public ScrollableDataTable(@Nonnull ITableModel<T> m) {
        super(m);
    }

    public ScrollableDataTable() {
    }

    @Override
    public void createContent() throws Exception {
        this.m_dataTable = null;
        this.m_dataBody = null;
        this.m_errorDiv = null;
        this.m_allRendered = false;
        this.addCssClass("ui-dt");
        this.setOverflow(Overflow.AUTO);
        this.m_nextIndexToLoad = 0;
        ISelectionModel sm = this.getSelectionModel();
        if (sm != null) {
            this.m_multiSelectMode = this.isShowSelectionAlways() || sm.getSelectionCount() > 0 ? sm.isMultiSelect() : false;
        }
        if (this.m_rowRenderer == null) {
            throw new IllegalStateException("There is no row renderer assigned to the table");
        }
        this.m_rowRenderer.beforeQuery(this);
        if (this.getModel().getRows() == 0) {
            this.setNoResults();
            return;
        }
        this.setResults();
        this.loadMoreData();
        if (this.isDisableClipboardSelection()) {
            this.appendCreateJS(JavascriptUtil.disableSelection(this));
        }
        if (this.m_redrawn) {
            this.appendJavascript("WebUI.scrollableTableReset('" + this.getActualID() + "','" + this.tbl().getActualID() + "');");
        } else {
            this.appendCreateJS("WebUI.initScrollableTable('" + this.getActualID() + "','" + this.tbl().getActualID() + "');");
            this.m_redrawn = true;
        }
    }

    @Nonnull
    private Table tbl() {
        Table t = this.m_dataTable;
        if (null == t) {
            throw new IllegalStateException("Access to table while unbuilt?");
        }
        return t;
    }

    private void loadMoreData() throws Exception {
        if (this.m_allRendered) {
            System.err.println("domui: ScrollableDataTable got unexpected loadMoreData");
            return;
        }
        int rows = this.getModel().getRows();
        if (this.m_nextIndexToLoad >= rows) {
            System.err.println("domui: ScrollableDataTable got unexpected loadMoreData and allrendered is false!?");
            return;
        }
        int six = this.m_nextIndexToLoad;
        int eix = six + this.m_batchSize;
        if (eix > rows) {
            eix = rows;
        }
        List list = this.getModel().getItems(six, eix);
        ColumnContainer cc = new ColumnContainer(this);
        int ix = six;
        for (Object o : list) {
            this.m_visibleItemList.add(o);
            TR tr = new TR();
            this.m_dataBody.add(tr);
            tr.setTestRepeatID("r" + ix);
            cc.setParent(tr);
            this.renderRow(tr, cc, ix, o);
            ++ix;
        }
        this.m_nextIndexToLoad = eix;
        if (ix >= this.getModel().getRows()) {
            this.renderFinalRow();
        }
        System.out.println("rendered till " + this.m_nextIndexToLoad);
    }

    private void rerender() throws Exception {
        if (!this.isBuilt() || this.m_dataBody == null) {
            return;
        }
        this.m_nextIndexToLoad = 0;
        this.m_dataBody.removeAllChildren();
        this.m_allRendered = false;
        this.m_visibleItemList.clear();
        this.loadMoreData();
        this.appendJavascript("WebUI.scrollableTableReset('" + this.getActualID() + "','" + this.tbl().getActualID() + "');");
    }

    private void renderFinalRow() {
        TBody dataBody = this.m_dataBody;
        if (null == dataBody) {
            throw new IllegalStateException("No data body?");
        }
        if (dataBody.getChildCount() > 0) {
            TR row = dataBody.getRow(dataBody.getChildCount() - 1);
            row.setSpecialAttribute("lastRow", "true");
        }
        this.m_allRendered = true;
    }

    private List<T> getPageItems() throws Exception {
        return this.getModel().getItems(0, this.m_nextIndexToLoad);
    }

    private void setResults() throws Exception {
        if (this.m_errorDiv != null) {
            this.m_errorDiv.remove();
            this.m_errorDiv = null;
        }
        if (this.m_dataBody != null) {
            return;
        }
        Table dataTable = this.m_dataTable = new Table();
        this.add(dataTable);
        dataTable.setCssClass("ui-dt-ovflw-tbl");
        THead hd = new THead();
        dataTable.add(hd);
        HeaderContainer hc = new HeaderContainer(this, hd, "ui-dt-hdr");
        this.renderHeader(hc);
        if (!hc.hasContent()) {
            hd.remove();
        }
        this.m_dataBody = new TBody();
        dataTable.add(this.m_dataBody);
    }

    @Deprecated
    private void renderHeader(@Nonnull HeaderContainer<T> hc) throws Exception {
        if (this.m_multiSelectMode) {
            TH headerCell = hc.add("");
            headerCell.add(new Img("THEME/dspcb-on.png"));
            headerCell.setTestID("dt_select_all");
            headerCell.setWidth("1%");
            headerCell.setClicked(this.m_headerSelectClickHandler);
            headerCell.setCssClass("ui-clickable");
        }
        this.m_rowRenderer.renderHeader(this, hc);
    }

    private void setNoResults() {
        this.m_visibleItemList.clear();
        if (this.m_errorDiv != null) {
            return;
        }
        Table dataTable = this.m_dataTable;
        if (dataTable != null) {
            dataTable.removeAllChildren();
            dataTable.remove();
            this.m_dataBody = null;
            this.m_dataTable = null;
        }
        this.m_errorDiv = new Div();
        this.m_errorDiv.setCssClass("ui-dt-nores");
        this.m_errorDiv.setText(Msgs.BUNDLE.getString("ui.dt.empty"));
        this.add(this.m_errorDiv);
    }

    private void renderRow(@Nonnull TR tr, @Nonnull ColumnContainer<T> cc, int index, final @Nonnull T value) throws Exception {
        ISelectionModel<T> sm = this.getSelectionModel();
        if (this.m_rowRenderer.getRowClicked() != null || null != sm) {
            cc.getTR().setClicked(new IClicked2<TR>(){

                @Override
                public void clicked(@Nonnull TR b, @Nonnull ClickInfo clinfo) throws Exception {
                    ScrollableDataTable.this.handleRowClick(b, value, clinfo);
                }
            });
            cc.getTR().addCssClass("ui-rowsel");
        }
        if (this.m_multiSelectMode && sm != null) {
            Checkbox cb = this.createSelectionCheckbox(value, sm);
            TD td = cc.add(cb);
            if (cb.isReadOnly()) {
                td.addCssClass("ui-cur-default");
            }
            boolean issel = sm.isSelected(value);
            cb.setChecked(issel);
            if (issel) {
                tr.addCssClass("mselected");
            } else {
                tr.removeCssClass("mselected");
            }
        }
        this.internalRenderRow(tr, cc, index, value);
    }

    @Deprecated
    private void internalRenderRow(@Nonnull TR tr, @Nonnull ColumnContainer<T> cc, int index, @Nonnull T value) throws Exception {
        this.m_rowRenderer.renderRow(this, cc, index, value);
    }

    private void handleRowClick(TR b, T instance, ClickInfo clinfo) throws Exception {
        ICellClicked<?> rowClicked;
        ISelectionModel selectionModel = this.getSelectionModel();
        if (selectionModel != null) {
            if (clinfo.isControl() || clinfo.isShift()) {
                this.handleSelectClicky(instance, clinfo, null);
                return;
            }
            if (!selectionModel.isMultiSelect()) {
                this.handleSelectClicky(instance, clinfo, null);
            }
        }
        if (null != (rowClicked = this.m_rowRenderer.getRowClicked())) {
            rowClicked.cellClicked(b, instance);
        }
    }

    private void selectionCheckboxClicked(T instance, boolean checked, ClickInfo info, @Nonnull Checkbox checkbox) throws Exception {
        this.handleSelectClicky(instance, info, checked);
        ISelectionModel<T> sm = this.getSelectionModel();
        if (null != sm) {
            checkbox.setChecked(sm.isSelected(instance));
        }
    }

    private void handleSelectClicky(@Nonnull T instance, @Nonnull ClickInfo clinfo, @Nullable Boolean setTo) throws Exception {
        int el;
        int sl;
        boolean nvalue;
        ISelectionModel sm = this.getSelectionModel();
        if (null == sm) {
            throw new IllegalStateException("SelectionModel is null??");
        }
        boolean bl = setTo != null ? setTo : (nvalue = !sm.isSelected(instance));
        if (!clinfo.isShift()) {
            sm.setInstanceSelected(instance, nvalue);
            this.m_lastSelectionLocation = -1;
            return;
        }
        int itemindex = -1;
        int index = 0;
        for (T item : this.m_visibleItemList) {
            if (MetaManager.areObjectsEqual(item, instance)) {
                itemindex = index;
                break;
            }
            ++index;
        }
        if (itemindex == -1) {
            return;
        }
        if (this.m_lastSelectionLocation == -1) {
            this.m_lastSelectionLocation = itemindex;
            sm.setInstanceSelected(instance, !sm.isSelected(instance));
            return;
        }
        if (this.m_lastSelectionLocation < itemindex) {
            sl = this.m_lastSelectionLocation + 1;
            el = itemindex + 1;
        } else {
            sl = itemindex;
            el = this.m_lastSelectionLocation;
        }
        int i = sl;
        while (i < el) {
            int ex = i + 50;
            if (ex > el) {
                ex = el;
            }
            List sub = this.getModel().getItems(i, ex);
            i += ex;
            for (Object item : sub) {
                if (item == null) {
                    throw new IllegalStateException("null item in list");
                }
                sm.setInstanceSelected(item, !sm.isSelected(item));
            }
        }
        this.m_lastSelectionLocation = -1;
    }

    private void updateSelectionChanged(T instance, int lrow, boolean on) throws Exception {
        TD td;
        Checkbox cb;
        ISelectionModel sm = this.getSelectionModel();
        if (sm == null) {
            throw new IllegalStateException("No selection model!?");
        }
        TR row = (TR)this.m_dataBody.getChild(lrow);
        THead head = this.tbl().getHead();
        if (null == head) {
            throw new IllegalStateException("I've lost my head!?");
        }
        TR headerrow = (TR)head.getChild(0);
        if (!sm.isMultiSelect()) {
            if (on) {
                row.addCssClass("selected");
            } else {
                row.removeCssClass("selected");
            }
            return;
        }
        if (!this.m_multiSelectMode) {
            if (!on) {
                return;
            }
            this.createMultiselectUI(headerrow);
        }
        if ((cb = (Checkbox)(td = (TD)row.getChild(0)).getChild(0)).isChecked() != on) {
            cb.setChecked(on);
        }
        if (on) {
            row.addCssClass("mselected");
        } else {
            row.removeCssClass("mselected");
        }
    }

    private void createMultiselectUI(TR headerrow) {
        if (this.m_multiSelectMode) {
            return;
        }
        this.m_multiSelectMode = true;
        TH th = new TH();
        th.add(new Img("THEME/dspcb-on.png"));
        th.setTestID("dt_select_all");
        th.setWidth("1%");
        headerrow.add(0, th);
        th.setClicked(this.m_headerSelectClickHandler);
        th.setCssClass("ui-clickable");
        for (int i = 0; i < this.m_dataBody.getChildCount(); ++i) {
            T instance = this.m_visibleItemList.get(i);
            TR tr = (TR)this.m_dataBody.getChild(i);
            TD td = new TD();
            tr.add(0, td);
            Checkbox cb = this.createSelectionCheckbox(instance, this.getSelectionModel());
            if (cb.isReadOnly()) {
                td.addCssClass("ui-cur-default");
            }
            td.add(cb);
            cb.setChecked(false);
        }
        this.fireSelectionUIChanged();
    }

    @Override
    protected void createSelectionUI() throws Exception {
        THead head = this.tbl().getHead();
        if (null == head) {
            throw new IllegalStateException("I've lost my head!?");
        }
        TR headerrow = (TR)head.getChild(0);
        this.createMultiselectUI(headerrow);
    }

    @Override
    public boolean isMultiSelectionVisible() {
        return this.m_multiSelectMode;
    }

    @Override
    public void modelChanged(@Nullable ITableModel<T> model) throws Exception {
        this.rerender();
        this.fireModelChanged(null, model);
    }

    @Override
    public void rowAdded(@Nonnull ITableModel<T> model, int index, @Nonnull T value) throws Exception {
        if (!this.isBuilt()) {
            return;
        }
        this.calcIndices();
        System.out.println("dd: add@ " + index + ", eix=" + this.m_nextIndexToLoad);
        if (index < 0 || index >= this.m_nextIndexToLoad && this.m_nextIndexToLoad >= this.m_batchSize) {
            this.firePageChanged();
            return;
        }
        this.setResults();
        int rrow = index;
        ColumnContainer cc = new ColumnContainer(this);
        TR tr = new TR();
        this.m_dataBody.add(rrow, tr);
        cc.setParent(tr);
        tr.setTestRepeatID("r" + index);
        this.renderRow(tr, cc, index, value);
        this.m_visibleItemList.add(rrow, value);
        if (this.m_nextIndexToLoad < this.m_batchSize) {
            if (this.m_visibleItemList.size() > this.m_nextIndexToLoad) {
                this.m_nextIndexToLoad = this.m_visibleItemList.size();
                System.out.println("dd: nextIndexToLoad set to " + this.m_nextIndexToLoad);
            }
        } else if (this.m_visibleItemList.size() > this.m_nextIndexToLoad && this.m_nextIndexToLoad >= this.m_batchSize) {
            int delindex = this.m_visibleItemList.size() - 1;
            this.m_visibleItemList.remove(delindex);
            this.m_dataBody.removeChild(delindex);
        }
        this.handleOddEven(rrow);
        this.firePageChanged();
    }

    @Override
    public void rowDeleted(@Nonnull ITableModel<T> model, int index, @Nonnull T value) throws Exception {
        if (!this.isBuilt()) {
            return;
        }
        System.out.println("dd: delete index=" + index + ", eix=" + this.m_nextIndexToLoad);
        if (index < 0 || index >= this.m_nextIndexToLoad) {
            this.calcIndices();
            this.firePageChanged();
            return;
        }
        int rrow = index;
        this.m_dataBody.removeChild(rrow);
        this.m_visibleItemList.remove(rrow);
        if (this.m_dataBody.getChildCount() == 0) {
            this.calcIndices();
            this.setNoResults();
            this.firePageChanged();
            return;
        }
        if (index < this.m_nextIndexToLoad && this.m_nextIndexToLoad <= this.getModel().getRows()) {
            ColumnContainer cc = new ColumnContainer(this);
            TR tr = new TR();
            cc.setParent(tr);
            Object mi = this.getModelItem(this.m_nextIndexToLoad - 1);
            System.out.println("dd: Add item#" + this.m_nextIndexToLoad + " @ " + (this.m_nextIndexToLoad - 1));
            this.m_dataBody.add(this.m_nextIndexToLoad - 1, tr);
            this.renderRow(tr, cc, this.m_nextIndexToLoad - 1, mi);
            this.m_visibleItemList.add(this.m_nextIndexToLoad - 1, mi);
        }
        if (this.m_nextIndexToLoad > this.getModel().getRows()) {
            this.m_nextIndexToLoad = this.getModel().getRows();
            System.out.println("dd: decrement size of loaded data eix=" + this.m_nextIndexToLoad);
        }
        while (this.m_visibleItemList.size() > this.m_nextIndexToLoad) {
            this.m_visibleItemList.remove(this.m_visibleItemList.size() - 1);
        }
        System.out.println("dd: sizes " + this.getModel().getRows() + " " + this.m_dataBody.getChildCount() + ", " + this.m_visibleItemList.size() + ", eix=" + this.m_nextIndexToLoad);
        this.calcIndices();
        this.handleOddEven(rrow);
        this.firePageChanged();
    }

    private void calcIndices() {
    }

    private void handleOddEven(int index) {
        for (int ix = index; ix < this.m_dataBody.getChildCount(); ++ix) {
            TR tr = (TR)this.m_dataBody.getChild(ix);
            if ((ix & 1) == 0) {
                tr.removeCssClass("ui-odd");
                tr.addCssClass("ui-even");
                continue;
            }
            tr.addCssClass("ui-odd");
            tr.removeCssClass("ui-even");
        }
    }

    @Override
    public void rowModified(@Nonnull ITableModel<T> model, int index, @Nonnull T value) throws Exception {
        if (!this.isBuilt()) {
            return;
        }
        if (index < 0 || index >= this.m_nextIndexToLoad) {
            return;
        }
        int rrow = index;
        TR tr = (TR)this.m_dataBody.getChild(rrow);
        tr.removeAllChildren();
        this.m_visibleItemList.set(rrow, value);
        ColumnContainer cc = new ColumnContainer(this);
        cc.setParent(tr);
        this.renderRow(tr, cc, index, value);
    }

    public void setTableWidth(@Nullable String w) {
        this.tbl().setTableWidth(w);
    }

    @Nonnull
    public IRowRenderer<T> getRowRenderer() {
        return this.m_rowRenderer;
    }

    public void setRowRenderer(@Nonnull IRowRenderer<T> rowRenderer) {
        if (DomUtil.isEqual(this.m_rowRenderer, rowRenderer)) {
            return;
        }
        this.m_rowRenderer = rowRenderer;
        this.forceRebuild();
    }

    @Override
    protected void onForceRebuild() {
        this.m_visibleItemList.clear();
        this.m_lastSelectionLocation = -1;
        super.onForceRebuild();
    }

    @Override
    public void selectionChanged(@Nonnull T row, boolean on) throws Exception {
        for (int i = 0; i < this.m_visibleItemList.size(); ++i) {
            if (!MetaManager.areObjectsEqual(row, this.m_visibleItemList.get(i))) continue;
            this.updateSelectionChanged(row, i, on);
            return;
        }
    }

    @Override
    public void selectionAllChanged() throws Exception {
        ISelectionModel<T> sm = this.getSelectionModel();
        if (sm == null) {
            throw new IllegalStateException("Got selection changed event but selection model is empty?");
        }
        for (int i = 0; i < this.m_visibleItemList.size(); ++i) {
            T item = this.m_visibleItemList.get(i);
            this.updateSelectionChanged(item, i, sm.isSelected(item));
        }
    }

    @Nonnull
    private Checkbox createSelectionCheckbox(final @Nonnull T rowInstance, @Nullable ISelectionModel<T> selectionModel) {
        Checkbox cb = new Checkbox();
        boolean selectable = true;
        if (selectionModel instanceof IAcceptable) {
            selectable = ((IAcceptable)((Object)selectionModel)).acceptable(rowInstance);
        }
        if (selectable) {
            cb.setClicked(new IClicked2<Checkbox>(){

                @Override
                public void clicked(@Nonnull Checkbox clickednode, @Nonnull ClickInfo info) throws Exception {
                    ScrollableDataTable.this.selectionCheckboxClicked(rowInstance, clickednode.isChecked(), info, clickednode);
                }
            });
        } else {
            cb.setReadOnly(true);
        }
        return cb;
    }

    @Override
    public void componentHandleWebAction(@Nonnull RequestContextImpl ctx, @Nonnull String action) throws Exception {
        if ("LOADMORE".equals(action)) {
            this.loadMoreData();
            return;
        }
        super.componentHandleWebAction(ctx, action);
    }

    public int getBatchSize() {
        return this.m_batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.m_batchSize = batchSize;
    }
}

