/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.tbl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.tbl.ISelectableTableComponent;
import to.etc.domui.component.tbl.ISelectionAllHandler;
import to.etc.domui.component.tbl.ISelectionListener;
import to.etc.domui.component.tbl.ISelectionModel;
import to.etc.domui.component.tbl.ITableModel;
import to.etc.domui.component.tbl.TableModelTableBase;
import to.etc.domui.dom.html.IActionControl;
import to.etc.domui.util.DomUtil;

public abstract class SelectableTabularComponent<T>
extends TableModelTableBase<T>
implements ISelectionListener<T>,
ISelectableTableComponent<T>,
IActionControl {
    private boolean m_disabled;
    @Nullable
    private ISelectionModel<T> m_selectionModel;
    @Nullable
    private ISelectionAllHandler m_selectionAllHandler;
    private boolean m_showSelectionAlways = true;

    protected abstract void createSelectionUI() throws Exception;

    public SelectableTabularComponent(@Nonnull ITableModel<T> model) {
        super(model);
    }

    public SelectableTabularComponent() {
    }

    @Override
    @Nullable
    public ISelectionAllHandler getSelectionAllHandler() {
        return this.m_selectionAllHandler;
    }

    public void setSelectionAllHandler(@Nullable ISelectionAllHandler selectionAllHandler) {
        if (this.m_selectionAllHandler == selectionAllHandler) {
            return;
        }
        this.m_selectionAllHandler = selectionAllHandler;
        this.fireSelectionUIChanged();
    }

    @Override
    @Nullable
    public ISelectionModel<T> getSelectionModel() {
        return this.m_selectionModel;
    }

    public void setSelectionModel(@Nullable ISelectionModel<T> selectionModel) {
        if (DomUtil.isEqual(this.m_selectionModel, selectionModel)) {
            return;
        }
        if (this.m_selectionModel != null) {
            this.m_selectionModel.removeListener(this);
        }
        this.m_selectionModel = selectionModel;
        if (null != selectionModel) {
            this.setDisableClipboardSelection(true);
            selectionModel.addListener(this);
        }
        this.forceRebuild();
    }

    public boolean isShowSelectionAlways() {
        return this.m_showSelectionAlways;
    }

    @Override
    public void setShowSelection(boolean showSelectionAlways) throws Exception {
        if (this.m_showSelectionAlways == showSelectionAlways) {
            return;
        }
        this.m_showSelectionAlways = showSelectionAlways;
        ISelectionModel<T> sm = this.getSelectionModel();
        if (sm == null) {
            throw new IllegalStateException("Selection model is empty?");
        }
        if (!this.isBuilt() || this.getSelectionModel() == null || !sm.isMultiSelect()) {
            return;
        }
        this.createSelectionUI();
    }

    public boolean isDisabled() {
        return this.m_disabled;
    }

    @Override
    public void setDisabled(boolean disabled) {
        this.m_disabled = disabled;
    }
}

