/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.tbl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.meta.NumericPresentation;
import to.etc.domui.component.meta.PropertyMetaModel;
import to.etc.domui.component.meta.SortableType;
import to.etc.domui.component.meta.YesNoType;
import to.etc.domui.component.meta.impl.ExpandedDisplayProperty;
import to.etc.domui.component.tbl.ColumnDefList;
import to.etc.domui.component.tbl.ICellClicked;
import to.etc.domui.component.tbl.ISortHelper;
import to.etc.domui.converter.ConverterRegistry;
import to.etc.domui.converter.IConverter;
import to.etc.domui.converter.IObjectToStringConverter;
import to.etc.domui.dom.css.TextAlign;
import to.etc.domui.util.INodeContentRenderer;
import to.etc.domui.util.IValueTransformer;

public final class SimpleColumnDef<T> {
    public static final String NOWRAP = "-NOWRAP";
    public static final String WRAP = "-WRAP";
    public static final String DEFAULTSORT = "-DSORT";
    @Nullable
    private String m_columnLabel;
    @Nonnull
    private final ColumnDefList<?> m_defList;
    @Nonnull
    private final Class<T> m_columnType;
    @Nonnull
    private SortableType m_sortable = SortableType.UNKNOWN;
    @Nullable
    private ISortHelper<?> m_sortHelper;
    @Nullable
    private String m_width;
    @Nullable
    private String m_propertyName;
    @Nullable
    private String m_cssClass;
    @Nullable
    private String m_headerCssClass;
    @Deprecated
    private int m_displayLength;
    @Nullable
    private Boolean m_nowrap;
    @Nullable
    private IValueTransformer<T> m_valueTransformer;
    @Nullable
    private IObjectToStringConverter<T> m_presentationConverter;
    @Nonnull
    private NumericPresentation m_numericPresentation = NumericPresentation.UNKNOWN;
    @Nullable
    private TextAlign m_align;
    @Nullable
    private INodeContentRenderer<T> m_contentRenderer;
    @Nullable
    private ICellClicked<T> m_cellClicked;
    @Nullable
    private String m_renderHint;

    public <X> SimpleColumnDef(@Nonnull ColumnDefList<?> cdl, @Nonnull Class<T> valueClass) {
        this.m_columnType = valueClass;
        this.m_defList = cdl;
    }

    public SimpleColumnDef(@Nonnull ColumnDefList<?> cdl, @Nonnull PropertyMetaModel<T> pmm) {
        this.m_defList = cdl;
        this.m_columnType = pmm.getActualType();
        this.setColumnLabel(pmm.getDefaultLabel());
        this.setValueTransformer(pmm);
        this.setPresentationConverter(ConverterRegistry.findBestConverter(pmm));
        this.setSortable(pmm.getSortable());
        this.setPropertyName(pmm.getName());
        this.setNumericPresentation(pmm.getNumericPresentation());
        if (pmm.getNowrap() == YesNoType.YES) {
            this.setNowrap(Boolean.TRUE);
        }
    }

    public SimpleColumnDef(@Nonnull ColumnDefList<?> cdl, @Nonnull ExpandedDisplayProperty<T> m) {
        this.m_defList = cdl;
        this.m_columnType = m.getActualType();
        this.setColumnLabel(m.getDefaultLabel());
        this.setValueTransformer(m);
        this.setPresentationConverter(m.getBestConverter());
        this.setSortable(SortableType.UNSORTABLE);
        this.setSortable(m.getSortable());
        this.setPropertyName(m.getName());
        if (m.getName() == null) {
            throw new IllegalStateException("All columns MUST have some name");
        }
        this.setNumericPresentation(m.getNumericPresentation());
        this.setRenderHint(m.getRenderHint());
        if (m.getDisplayLength() > 0) {
            this.setDisplayLength(m.getDisplayLength());
        }
        if (m.getNowrap() == YesNoType.YES) {
            this.setNowrap(Boolean.TRUE);
        }
    }

    @Nullable
    public String getColumnLabel() {
        return this.m_columnLabel;
    }

    public void setColumnLabel(@Nullable String columnLabel) {
        this.label(columnLabel);
    }

    <R> T getColumnValue(@Nonnull R instance) throws Exception {
        IValueTransformer<T> valueTransformer = this.getValueTransformer();
        if (valueTransformer == null) {
            return (T)instance;
        }
        return valueTransformer.getValue(instance);
    }

    @Nonnull
    public Class<T> getColumnType() {
        return this.m_columnType;
    }

    @Nonnull
    public SortableType getSortable() {
        return this.m_sortable;
    }

    public void setSortable(@Nonnull SortableType sortable) {
        this.m_sortable = sortable == null ? SortableType.UNKNOWN : sortable;
    }

    @Nullable
    public String getWidth() {
        return this.m_width;
    }

    public void setWidth(@Nullable String width) {
        this.width(width);
    }

    @Nullable
    public IValueTransformer<T> getValueTransformer() {
        return this.m_valueTransformer;
    }

    public void setValueTransformer(@Nullable IValueTransformer<T> valueTransformer) {
        this.m_valueTransformer = valueTransformer;
    }

    @Nullable
    public IObjectToStringConverter<T> getPresentationConverter() {
        return this.m_presentationConverter;
    }

    public void setPresentationConverter(@Nullable IConverter<T> valueConverter) {
        this.m_presentationConverter = valueConverter;
    }

    @Nullable
    public String getPropertyName() {
        return this.m_propertyName;
    }

    public void setPropertyName(@Nullable String propertyName) {
        this.m_propertyName = propertyName;
    }

    @Nullable
    public INodeContentRenderer<T> getContentRenderer() {
        return this.m_contentRenderer;
    }

    public void setContentRenderer(@Nullable INodeContentRenderer<T> contentRenderer) {
        this.m_contentRenderer = contentRenderer;
    }

    @Nullable
    public String getCssClass() {
        return this.m_cssClass;
    }

    public void setCssClass(@Nullable String cssClass) {
        this.m_cssClass = cssClass;
    }

    @Nullable
    public String getHeaderCssClass() {
        return this.m_headerCssClass;
    }

    public void setHeaderCssClass(@Nullable String headerCssClass) {
        this.m_headerCssClass = headerCssClass;
    }

    @Deprecated
    public int getDisplayLength() {
        return this.m_displayLength;
    }

    @Deprecated
    public void setDisplayLength(int displayLength) {
        this.m_displayLength = displayLength;
    }

    @Nullable
    public Boolean isNowrap() {
        return this.m_nowrap;
    }

    public void setNowrap(@Nullable Boolean nowrap) {
        this.m_nowrap = nowrap;
    }

    @Nullable
    public ICellClicked<T> getCellClicked() {
        return this.m_cellClicked;
    }

    public void setCellClicked(@Nullable ICellClicked<T> cellClicked) {
        this.m_cellClicked = cellClicked;
    }

    @Nonnull
    public NumericPresentation getNumericPresentation() {
        return this.m_numericPresentation;
    }

    public void setNumericPresentation(@Nonnull NumericPresentation numericPresentation) {
        this.m_numericPresentation = numericPresentation;
    }

    @Nullable
    public TextAlign getAlign() {
        return this.m_align;
    }

    public void setAlign(@Nullable TextAlign align) {
        this.m_align = align;
    }

    @Nullable
    public String getRenderHint() {
        return this.m_renderHint;
    }

    public void setRenderHint(@Nullable String renderHint) {
        this.m_renderHint = renderHint;
    }

    @Nullable
    public ISortHelper<?> getSortHelper() {
        return this.m_sortHelper;
    }

    public void setSortHelper(@Nullable ISortHelper<?> sortHelper) {
        this.m_sortHelper = sortHelper;
    }

    @Nonnull
    public String toString() {
        return "SimpleColumnDef[" + this.getPropertyName() + ", type=" + this.getColumnType() + ", lbl=" + this.getColumnLabel() + "]";
    }

    @Nonnull
    public SimpleColumnDef<T> label(@Nullable String columnLabel) {
        this.m_columnLabel = columnLabel;
        return this;
    }

    @Nonnull
    public SimpleColumnDef<T> align(@Nonnull TextAlign align) {
        this.m_align = align;
        return this;
    }

    @Nonnull
    public SimpleColumnDef<T> cellClicked(@Nonnull ICellClicked<T> ck) {
        this.m_cellClicked = ck;
        return this;
    }

    @Nonnull
    public SimpleColumnDef<T> renderer(@Nonnull INodeContentRenderer<T> cr) {
        this.m_contentRenderer = cr;
        return this;
    }

    @Nonnull
    public SimpleColumnDef<T> css(@Nonnull String css) {
        this.m_cssClass = css;
        return this;
    }

    @Nonnull
    public SimpleColumnDef<T> cssHeader(@Nonnull String css) {
        this.m_headerCssClass = css;
        return this;
    }

    @Nonnull
    public SimpleColumnDef<T> wrap() {
        this.m_nowrap = Boolean.FALSE;
        return this;
    }

    @Nonnull
    public SimpleColumnDef<T> nowrap() {
        this.m_nowrap = Boolean.TRUE;
        return this;
    }

    @Nonnull
    public SimpleColumnDef<T> numeric(@Nonnull NumericPresentation np) {
        this.m_numericPresentation = np;
        return this;
    }

    @Nonnull
    public SimpleColumnDef<T> converter(@Nonnull IObjectToStringConverter<T> c) {
        this.m_presentationConverter = c;
        return this;
    }

    @Nonnull
    public SimpleColumnDef<T> hint(@Nonnull String hint) {
        this.m_renderHint = hint;
        return this;
    }

    @Nonnull
    public SimpleColumnDef<T> ascending() {
        this.setSortable(SortableType.SORTABLE_ASC);
        return this;
    }

    @Nonnull
    public SimpleColumnDef<T> descending() {
        this.setSortable(SortableType.SORTABLE_DESC);
        return this;
    }

    @Nonnull
    public SimpleColumnDef<T> sortdefault() {
        this.m_defList.setSortColumn(this);
        return this;
    }

    @Nonnull
    public SimpleColumnDef<T> sort(@Nonnull ISortHelper<T> sh) {
        this.m_sortHelper = sh;
        if (this.m_sortable == SortableType.UNKNOWN) {
            this.m_sortable = SortableType.SORTABLE_ASC;
        }
        return this;
    }

    @Nonnull
    public SimpleColumnDef<T> transform(@Nonnull IValueTransformer<T> vt) {
        this.m_valueTransformer = vt;
        return this;
    }

    @Nonnull
    public SimpleColumnDef<T> width(@Nullable String w) {
        this.m_width = w;
        return this;
    }
}

