/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.tbl;

import java.util.List;
import javax.annotation.Nonnull;
import to.etc.domui.component.meta.ClassMetaModel;
import to.etc.domui.component.meta.NumericPresentation;
import to.etc.domui.component.meta.impl.DisplayPropertyMetaModel;
import to.etc.domui.component.meta.impl.ExpandedDisplayProperty;
import to.etc.domui.component.meta.impl.ExpandedDisplayPropertyList;
import to.etc.domui.component.tbl.AbstractRowRenderer;
import to.etc.domui.component.tbl.IClickableRowRenderer;
import to.etc.domui.component.tbl.SimpleColumnDef;

@Deprecated
public class SimpleRowRenderer<T>
extends AbstractRowRenderer<T>
implements IClickableRowRenderer<T> {
    private int m_totwidth;

    public SimpleRowRenderer(@Nonnull Class<T> dataClass, String ... cols) {
        super(dataClass);
        this.initColumnList(cols);
    }

    public SimpleRowRenderer(@Nonnull Class<T> dataClass, @Nonnull ClassMetaModel cmm, String ... cols) {
        super(dataClass, cmm);
        this.initColumnList(cols);
    }

    private void initColumnList(@Nonnull String[] cols) {
        if (cols.length != 0) {
            this.initializeExplicitColumns(cols);
        } else {
            this.initializeDefaultColumns();
        }
        String sort = this.model().getDefaultSortProperty();
        if (null != sort) {
            this.getColumnList().setDefaultSortColumn(sort);
        }
    }

    protected void initializeExplicitColumns(String[] cols) {
        if (cols == null || cols.length == 0) {
            throw new IllegalStateException("The list-of-columns is empty or null; I need at least one column to continue.");
        }
        List<ExpandedDisplayProperty<?>> xdpl = ExpandedDisplayProperty.expandProperties(this.model(), cols);
        this.initialize(xdpl);
    }

    protected void initialize(@Nonnull List<ExpandedDisplayProperty<?>> xdpl) {
        int[] widths = new int[80];
        this.m_totwidth = 0;
        int ix = 0;
        this.addColumns(xdpl, widths);
        ix = 0;
        for (SimpleColumnDef<?> simpleColumnDef : this.getColumnList()) {
            int pct = 100 * widths[ix++] / this.m_totwidth;
            simpleColumnDef.setWidth(pct + "%");
        }
    }

    protected void addColumns(List<ExpandedDisplayProperty<?>> xdpl, int[] widths) {
        for (ExpandedDisplayProperty<?> xdp : xdpl) {
            if (xdp instanceof ExpandedDisplayPropertyList) {
                ExpandedDisplayPropertyList xdl = (ExpandedDisplayPropertyList)xdp;
                this.addColumns(xdl.getChildren(), widths);
                continue;
            }
            SimpleColumnDef<?> scd = this.createDef(xdp);
            int dl = xdp.getDisplayLength();
            if (dl <= 5) {
                dl = 5;
            }
            if (dl > 40) {
                dl = 40;
            }
            widths[this.getColumnList().size()] = dl;
            this.m_totwidth += dl;
            this.getColumnList().add(scd);
            if (scd.getNumericPresentation() == null || scd.getNumericPresentation() == NumericPresentation.UNKNOWN) continue;
            scd.setCssClass("ui-numeric");
            scd.setHeaderCssClass("ui-numeric");
        }
    }

    @Nonnull
    private <V> SimpleColumnDef<V> createDef(@Nonnull ExpandedDisplayProperty<V> v) {
        return new SimpleColumnDef<V>(this.getColumnList(), v);
    }

    private void initializeDefaultColumns() {
        List<DisplayPropertyMetaModel> dpl = this.model().getTableDisplayProperties();
        if (dpl.size() == 0) {
            throw new IllegalStateException("The list-of-columns to show is empty, and the class has no metadata (@MetaObject) defining a set of columns as default table columns, so there.");
        }
        List<ExpandedDisplayProperty<?>> xdpl = ExpandedDisplayProperty.expandDisplayProperties(dpl, this.model(), null);
        this.initialize(xdpl);
    }

    protected void setTotalWidth(int w) {
        this.m_totwidth = w;
    }

    protected int getTotalWidth() {
        return this.m_totwidth;
    }
}

