/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.tbl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.DefaultNonNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import to.etc.domui.component.tbl.IKeyedTableModel;
import to.etc.domui.component.tbl.IQueryHandler;
import to.etc.domui.component.tbl.ISortHelper;
import to.etc.domui.component.tbl.ISortableTableModel;
import to.etc.domui.component.tbl.ITableModel;
import to.etc.domui.component.tbl.ITruncateableDataModel;
import to.etc.domui.component.tbl.TableListModelBase;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.util.DomUtil;
import to.etc.domui.util.IShelvedListener;
import to.etc.util.StringTool;
import to.etc.util.WrappedException;
import to.etc.webapp.query.QCriteria;
import to.etc.webapp.query.QDataContext;
import to.etc.webapp.query.QDataContextFactory;
import to.etc.webapp.query.QOrder;

public class SimpleSearchModel<T>
extends TableListModelBase<T>
implements IKeyedTableModel<T>,
ITruncateableDataModel,
ISortableTableModel,
IShelvedListener {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleSearchModel.class);
    @Nullable
    private final QDataContextFactory m_sessionSource;
    @Nullable
    private final NodeBase m_contextSourceNode;
    @Nullable
    private final IQueryHandler<T> m_queryHandler;
    @Nullable
    private final IQuery<T> m_queryFunctor;
    @Nullable
    private QCriteria<T> m_query;
    @Nullable
    private List<T> m_workResult;
    private boolean[] m_workRefreshed;
    private boolean m_truncated;
    @Nullable
    private String m_sort;
    @Nullable
    private String m_sortComparatorKey;
    @Nullable
    private Comparator<T> m_sortComparator;
    private boolean m_desc;
    private boolean m_refreshAfterShelve;
    private int m_maxRowCount;
    @Nullable
    private List<QOrder> m_criteriaSortOrder;

    public SimpleSearchModel(@Nonnull NodeBase contextSourceNode, @Nonnull QCriteria<T> qc) {
        this.m_query = qc;
        this.m_contextSourceNode = contextSourceNode;
        this.m_queryFunctor = null;
        this.m_sessionSource = null;
        this.m_queryHandler = null;
    }

    public SimpleSearchModel(@Nonnull QDataContextFactory ss, @Nonnull QCriteria<T> qc) {
        this.m_query = qc;
        this.m_sessionSource = ss;
        this.m_queryFunctor = null;
        this.m_queryHandler = null;
        this.m_contextSourceNode = null;
    }

    public SimpleSearchModel(@Nonnull IQueryHandler<T> ss, @Nonnull QCriteria<T> qc) {
        this.m_query = qc;
        this.m_queryHandler = ss;
        this.m_queryFunctor = null;
        this.m_contextSourceNode = null;
        this.m_sessionSource = null;
    }

    public SimpleSearchModel(@Nonnull QDataContextFactory f, @Nonnull IQuery<T> q) {
        this.m_sessionSource = f;
        this.m_queryFunctor = q;
        this.m_contextSourceNode = null;
        this.m_query = null;
        this.m_queryHandler = null;
    }

    public SimpleSearchModel(@Nonnull NodeBase contextSource, @Nonnull IQuery<T> q) {
        this.m_contextSourceNode = contextSource;
        this.m_queryFunctor = q;
        this.m_sessionSource = null;
        this.m_query = null;
        this.m_queryHandler = null;
    }

    public QCriteria<T> getQuery() {
        return this.m_query;
    }

    public void setRefreshAfterShelve(boolean refreshAfterShelve) {
        this.m_refreshAfterShelve = refreshAfterShelve;
    }

    public boolean isRefreshAfterShelve() {
        return this.m_refreshAfterShelve;
    }

    public int getMaxRowCount() {
        return this.m_maxRowCount;
    }

    public void setMaxRowCount(int maxRowCount) {
        this.m_maxRowCount = maxRowCount;
    }

    @Nonnull
    private QDataContext getQueryContext() throws Exception {
        if (this.m_sessionSource != null) {
            return this.m_sessionSource.getDataContext();
        }
        if (this.m_contextSourceNode != null) {
            return this.m_contextSourceNode.getSharedContext();
        }
        throw new IllegalStateException("No sessionSource and no contextSourceNode present - I do not know how to allocate a QDataContext");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void execQuery() throws Exception {
        Comparator<T> sortComparator;
        int resultLimit;
        int queryLimit;
        long ts;
        block22: {
            ts = System.nanoTime();
            QDataContext dc = null;
            queryLimit = this.getMaxRowCount() > 0 ? this.getMaxRowCount() : 1000;
            QCriteria<T> query = this.m_query;
            if (null != query && query.getLimit() > 0) {
                queryLimit = query.getLimit();
            }
            resultLimit = ++queryLimit;
            sortComparator = this.m_sortComparator;
            if (null != sortComparator && queryLimit <= 8000) {
                queryLimit = 8001;
            }
            try {
                IQuery<T> queryFunctor = this.m_queryFunctor;
                if (queryFunctor != null) {
                    dc = this.getQueryContext();
                    this.m_workResult = queryFunctor.query(dc, this.m_sort, queryLimit);
                    break block22;
                }
                if (this.m_query != null) {
                    QCriteria<T> qc = this.m_query;
                    int oldLimit = qc.getLimit();
                    qc.limit(queryLimit);
                    this.handleQuerySorting(qc);
                    if (this.m_queryHandler != null) {
                        this.m_workResult = this.m_queryHandler.query(qc);
                    } else {
                        dc = this.getQueryContext();
                        this.m_workResult = dc.query(qc);
                    }
                    qc.limit(oldLimit);
                    break block22;
                }
                throw new IllegalStateException("No query and no query functor- no idea how to create the result..");
            }
            finally {
                try {
                    if (dc != null) {
                        dc.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        if (null != sortComparator) {
            if (this.getWorkResult().size() == queryLimit) {
                System.err.println("Unable to do proper in-memory sorting since query fetch more than " + (queryLimit - 1) + " rows!");
            }
            if (this.m_desc) {
                this.getWorkResult().sort(Collections.reverseOrder(sortComparator));
            } else {
                this.getWorkResult().sort(sortComparator);
            }
            if (this.getWorkResult().size() > resultLimit) {
                this.m_workResult = this.getWorkResult().subList(0, resultLimit + 1);
            }
        }
        if (this.getWorkResult().size() >= resultLimit) {
            this.getWorkResult().remove(this.getWorkResult().size() - 1);
            this.m_truncated = true;
        } else {
            this.m_truncated = false;
        }
        if (LOG.isDebugEnabled()) {
            ts = System.nanoTime() - ts;
            LOG.debug("db: persistence framework query and materialize took " + StringTool.strNanoTime((long)ts));
        }
    }

    protected void handleQuerySorting(QCriteria<T> qc) {
        String sort = this.m_sort;
        if (sort != null) {
            qc.getOrder().clear();
            if (this.m_desc) {
                qc.descending(sort);
            } else {
                qc.ascending(sort);
            }
            return;
        }
    }

    @Nonnull
    public QCriteria<T> getCriteria() {
        QCriteria<T> query = this.m_query;
        if (null == query) {
            throw new IllegalStateException("This model is not using a QCriteria query.");
        }
        this.m_criteriaSortOrder = new ArrayList<QOrder>(query.getOrder());
        query.getOrder().clear();
        return query;
    }

    public void setCriteria(@Nonnull QCriteria<T> query) {
        List<QOrder> oldOrder = this.m_criteriaSortOrder;
        this.m_criteriaSortOrder = null;
        if (query == this.m_query && oldOrder != null && oldOrder.equals(query.getOrder())) {
            return;
        }
        this.m_query = query;
        if (query.getOrder().size() > 0) {
            this.m_sort = null;
            this.setSortComparator(null, null);
        }
        this.clear();
        try {
            this.fireModelChanged();
        }
        catch (Exception x) {
            throw WrappedException.wrap((Exception)x);
        }
    }

    private void setSortComparator(@Nullable Comparator<T> sortComparator, @Nullable String sortComparatorKey) {
        this.m_sortComparator = sortComparator;
        this.m_sortComparatorKey = sortComparatorKey;
    }

    @Override
    public boolean isTruncated() {
        return this.m_truncated;
    }

    protected void initResult() throws Exception {
        if (this.m_workResult == null) {
            this.execQuery();
        }
    }

    @Override
    @Nonnull
    protected List<T> getList() throws Exception {
        this.initResult();
        return this.getWorkResult();
    }

    @Nonnull
    private List<T> getWorkResult() {
        if (null != this.m_workResult) {
            return this.m_workResult;
        }
        throw new IllegalStateException("workResult not initialized");
    }

    @Override
    @Nonnull
    public List<T> getItems(int start, int end) throws Exception {
        this.initResult();
        if (start < 0) {
            start = 0;
        }
        if (end > this.getRows()) {
            end = this.getRows();
        }
        if (end <= start) {
            return Collections.EMPTY_LIST;
        }
        if (this.isRefreshAfterShelve()) {
            if (this.m_workRefreshed == null) {
                this.m_workRefreshed = new boolean[this.getWorkResult().size()];
            }
            QDataContext qs = null;
            for (int i = start; i < end; ++i) {
                if (this.m_workRefreshed[i]) continue;
                if (qs == null) {
                    qs = this.getQueryContext();
                }
                qs.refresh(this.getWorkResult().get(i));
                this.m_workRefreshed[i] = true;
            }
        }
        return this.getWorkResult().subList(start, end);
    }

    @Override
    public T findRowObject(String key) throws Exception {
        throw new IllegalStateException("Not implemented");
    }

    @Override
    public String getRowKey(int row) throws Exception {
        throw new IllegalStateException("Not implemented");
    }

    public void clear() {
        this.m_workResult = null;
        this.m_workRefreshed = null;
    }

    @Override
    public void sortOn(String key, boolean descending) throws Exception {
        if (DomUtil.isEqual((Object)key, (Object)this.m_sort) && descending == this.m_desc) {
            return;
        }
        this.clear();
        this.m_desc = descending;
        this.m_sort = key;
        this.setSortComparator(null, null);
        QCriteria<T> query = this.m_query;
        if (null != query) {
            query.getOrder().clear();
        }
        this.fireModelChanged();
    }

    public void sortOn(Comparator<T> sortComparator, String sortComparatorKey, boolean descending) throws Exception {
        if (DomUtil.isEqual((Object)sortComparatorKey, (Object)this.m_sortComparatorKey) && descending == this.m_desc) {
            return;
        }
        this.clear();
        this.m_desc = descending;
        this.m_sort = null;
        QCriteria<T> query = this.m_query;
        if (null != query) {
            query.getOrder().clear();
        }
        this.setSortComparator(sortComparator, sortComparatorKey);
        this.fireModelChanged();
    }

    @Override
    @Nullable
    public String getSortKey() {
        return this.m_sort;
    }

    @Override
    public boolean isSortDescending() {
        return this.m_desc;
    }

    @Override
    public void onShelve() throws Exception {
        LOG.debug("Shelving the model");
        this.clear();
    }

    @Override
    public void onUnshelve() throws Exception {
    }

    @Override
    public void refresh() {
        this.clear();
    }

    @DefaultNonNull
    public static final class ByComparatorSortHelper<T>
    implements ISortHelper<T> {
        private final String m_columnKey;
        private final Comparator<T> m_comparator;

        public ByComparatorSortHelper(String columnKey, Comparator<T> comparator) {
            this.m_columnKey = columnKey;
            this.m_comparator = comparator;
        }

        @Override
        public <M extends ITableModel<T>> void adjustSort(M model, boolean descending) throws Exception {
            SimpleSearchModel smm = (SimpleSearchModel)model;
            smm.sortOn(this.m_comparator, this.m_columnKey, descending);
        }
    }

    public static final class SortHelper<T>
    implements ISortHelper<T> {
        private final String m_columnName;

        public SortHelper(String columnName) {
            this.m_columnName = columnName;
        }

        @Override
        public <M extends ITableModel<T>> void adjustSort(@Nonnull M model, boolean descending) throws Exception {
            SimpleSearchModel ssm = (SimpleSearchModel)model;
            QCriteria sq = ssm.getCriteria();
            if (descending) {
                sq.descending(this.m_columnName);
            } else {
                sq.ascending(this.m_columnName);
            }
            ssm.setCriteria(sq);
        }
    }

    public static interface IQuery<T> {
        public List<T> query(QDataContext var1, String var2, int var3) throws Exception;
    }
}

