/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.tbl;

import java.util.Comparator;
import java.util.List;
import to.etc.domui.component.meta.ClassMetaModel;
import to.etc.domui.component.meta.MetaManager;
import to.etc.domui.component.tbl.ISortableTableModel;
import to.etc.domui.component.tbl.ITruncateableDataModel;
import to.etc.domui.component.tbl.SimpleListModel;
import to.etc.domui.converter.ConverterRegistry;
import to.etc.util.StringTool;

public class SortableListModel<T>
extends SimpleListModel<T>
implements ISortableTableModel,
ITruncateableDataModel {
    private final Class<T> m_dataClass;
    private String m_sortKey;
    private boolean m_descending;
    private boolean m_truncated;

    public SortableListModel(Class<T> clz, List<T> list) {
        super(list);
        this.m_dataClass = clz;
    }

    public Class<T> getDataClass() {
        return this.m_dataClass;
    }

    @Override
    public void sortOn(String key, boolean descending) throws Exception {
        if (StringTool.isEqual((Object)key, (Object)this.m_sortKey) && this.m_descending == descending) {
            return;
        }
        if (key == null) {
            if (this.getComparator() != null) {
                this.setComparator(null);
                this.fireModelChanged();
            }
        } else {
            ClassMetaModel cmm = MetaManager.findClassMeta(this.getDataClass());
            Comparator<?> comp = ConverterRegistry.getComparator(cmm, key, descending);
            this.setComparator(comp);
            this.fireModelChanged();
        }
        this.m_sortKey = key;
        this.m_descending = descending;
    }

    @Override
    public void setComparator(Comparator<T> comparator) throws Exception {
        this.m_sortKey = null;
        this.m_descending = false;
        super.setComparator(comparator);
    }

    @Override
    public String getSortKey() {
        return this.m_sortKey;
    }

    @Override
    public boolean isSortDescending() {
        return this.m_descending;
    }

    @Override
    public boolean isTruncated() {
        return this.m_truncated;
    }

    public void setTruncated(boolean tr) {
        this.m_truncated = tr;
    }
}

