/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.tbl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.tbl.IModifyableTableModel;
import to.etc.domui.component.tbl.ITableModel;
import to.etc.domui.component.tbl.TableModelBase;

public abstract class TableKeyModelBase<K, T>
extends TableModelBase<T>
implements ITableModel<T>,
IModifyableTableModel<K> {
    @Nonnull
    private final Collection<K> m_sourceCollection;
    @Nonnull
    private final List<K> m_keyList;
    @Nullable
    private Comparator<K> m_comparator;

    @Nonnull
    protected abstract List<T> getItems(List<K> var1) throws Exception;

    public TableKeyModelBase(@Nonnull Collection<K> keycoll) {
        this.m_sourceCollection = keycoll;
        this.m_keyList = keycoll instanceof List ? (List<Object>)keycoll : new ArrayList<K>(keycoll);
    }

    public TableKeyModelBase(@Nonnull Collection<K> keycoll, @Nonnull Comparator<K> comp) {
        this.m_sourceCollection = keycoll;
        this.m_keyList = new ArrayList<K>(keycoll);
        this.m_comparator = comp;
        Collections.sort(this.m_keyList, comp);
    }

    @Override
    @Nonnull
    public List<T> getItems(int start, int end) throws Exception {
        int size = this.getRows();
        if (start < 0) {
            start = 0;
        }
        if (end > size) {
            end = size;
        }
        if (start >= size || end <= 0 || start >= end) {
            return Collections.emptyList();
        }
        List<K> ktodo = this.m_keyList.subList(start, end);
        List<T> res = this.getItems(ktodo);
        return res;
    }

    @Override
    @Nullable
    protected final T getItem(int index) throws Exception {
        try {
            List<T> res = this.getItems(index, index + 1);
            return res.get(0);
        }
        catch (Exception x) {
            return null;
        }
    }

    @Override
    public int getRows() throws Exception {
        return this.m_keyList.size();
    }

    @Override
    public void add(int index, @Nonnull K key) throws Exception {
        if (this.m_comparator != null) {
            throw new IllegalStateException("Cannot add by index on a sorted model: the sorting order determines the insert index");
        }
        this.m_keyList.add(index, key);
        if (this.m_sourceCollection != this.m_keyList) {
            this.m_sourceCollection.add(key);
        }
        this.fireAdded(index);
    }

    @Override
    public void add(@Nonnull K row) throws Exception {
        int index;
        if (this.m_comparator == null) {
            index = this.m_keyList.size();
            this.m_keyList.add(row);
            if (this.m_keyList != this.m_sourceCollection) {
                this.m_sourceCollection.add(row);
            }
        } else {
            index = Collections.binarySearch(this.m_keyList, row, this.m_comparator);
            if (index < 0) {
                index = -(index + 1);
            }
            this.m_keyList.add(index, row);
            if (this.m_sourceCollection != this.m_keyList) {
                if (this.m_sourceCollection instanceof List) {
                    ((List)this.m_sourceCollection).add(index, row);
                } else {
                    this.m_sourceCollection.add(row);
                }
            }
        }
        this.fireAdded(index);
    }

    @Override
    @Nullable
    public K delete(int index) throws Exception {
        T deleted = this.getItem(index);
        K old = this.m_keyList.remove(index);
        if (this.m_sourceCollection != this.m_keyList) {
            this.m_sourceCollection.remove(old);
        }
        this.fireDeleted(index, deleted);
        return old;
    }

    @Override
    public boolean delete(@Nonnull K val) throws Exception {
        int ix = this.m_keyList.indexOf(val);
        if (ix == -1) {
            return false;
        }
        this.delete(ix);
        return true;
    }

    public void modified(int index) throws Exception {
        this.fireModified(index);
    }

    public void modified(K key) throws Exception {
        int ix = this.m_keyList.indexOf(key);
        if (ix != -1) {
            this.fireModified(ix);
        }
    }

    public void move(int to, int from) throws Exception {
        if (this.m_comparator != null) {
            throw new IllegalStateException("Cannot move objects in a sorted model: the sorting order determines the insert index");
        }
        if (to == from) {
            throw new IllegalStateException("'from' and 'to' are the same: " + to);
        }
        if (from < 0 || from >= this.getRows()) {
            throw new IllegalStateException("Invalid 'from' index (out of bounds): " + from);
        }
        if (to < 0 || to >= this.getRows()) {
            throw new IllegalStateException("Invalid 'to' index (out of bounds): " + to);
        }
        K key = this.delete(from);
        if (null == key) {
            return;
        }
        this.add(to, key);
    }
}

