/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.tbl;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;
import to.etc.domui.component.tbl.IModifyableTableModel;
import to.etc.domui.component.tbl.TableModelBase;

public abstract class TableListModelBase<T>
extends TableModelBase<T>
implements IModifyableTableModel<T> {
    private Comparator<T> m_comparator;

    protected abstract List<T> getList() throws Exception;

    @Override
    @Nonnull
    public List<T> getItems(int start, int end) throws Exception {
        int size = this.getRows();
        if (start < 0) {
            start = 0;
        }
        if (end > size) {
            end = size;
        }
        if (start >= size || end <= 0 || start >= end) {
            return Collections.EMPTY_LIST;
        }
        return this.getList().subList(start, end);
    }

    @Override
    public T getItem(int index) throws Exception {
        return this.getList().get(index);
    }

    @Override
    public int getRows() throws Exception {
        return this.getList().size();
    }

    public Comparator<T> getComparator() {
        return this.m_comparator;
    }

    public void setComparator(Comparator<T> comparator) throws Exception {
        if (this.m_comparator == comparator) {
            return;
        }
        this.m_comparator = comparator;
        if (this.m_comparator != null) {
            this.resort();
            this.fireModelChanged();
        }
    }

    private void resort() throws Exception {
        Collections.sort(this.getList(), this.m_comparator);
    }

    @Override
    public void add(int index, @Nonnull T row) throws Exception {
        if (this.m_comparator != null) {
            throw new IllegalStateException("Cannot add by index on a sorted model: the sorting order determines the insert index");
        }
        this.getList().add(index, row);
        this.fireAdded(index);
    }

    @Override
    public void add(@Nonnull T row) throws Exception {
        int index;
        if (this.m_comparator == null) {
            index = this.getList().size();
            this.getList().add(row);
        } else {
            index = Collections.binarySearch(this.getList(), row, this.m_comparator);
            if (index < 0) {
                index = -(index + 1);
            }
            this.getList().add(index, row);
        }
        this.fireAdded(index);
    }

    @Override
    public T delete(int index) throws Exception {
        T old = this.getList().remove(index);
        this.fireDeleted(index, old);
        return old;
    }

    @Override
    public boolean delete(@Nonnull T val) throws Exception {
        int ix = this.getList().indexOf(val);
        if (ix == -1) {
            return false;
        }
        this.delete(ix);
        return true;
    }

    public void modified(int index) throws Exception {
        this.fireModified(index);
    }

    public void modified(@Nonnull T val) throws Exception {
        int ix = this.getList().indexOf(val);
        if (ix != -1) {
            this.fireModified(ix);
        }
    }

    public int indexOf(@Nonnull T val) throws Exception {
        return this.getList().indexOf(val);
    }

    public void move(int to, int from) throws Exception {
        if (this.m_comparator != null) {
            throw new IllegalStateException("Cannot move objects in a sorted model: the sorting order determines the insert index");
        }
        if (to == from) {
            throw new IllegalStateException("'from' and 'to' are the same: " + to);
        }
        if (from < 0 || from >= this.getRows()) {
            throw new IllegalStateException("Invalid 'from' index (out of bounds): " + from);
        }
        if (to < 0 || to >= this.getRows()) {
            throw new IllegalStateException("Invalid 'to' index (out of bounds): " + to);
        }
        T obj = this.delete(from);
        this.add(to, obj);
    }
}

