/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.tbl;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import to.etc.domui.component.tbl.ITableModel;
import to.etc.domui.component.tbl.ITableModelListener;

public abstract class TableModelBase<T>
implements ITableModel<T> {
    private final List<ITableModelListener<T>> m_listeners = new ArrayList<ITableModelListener<T>>();

    protected abstract T getItem(int var1) throws Exception;

    @Override
    public void addChangeListener(@Nonnull ITableModelListener<T> l) {
        this.m_listeners.add(l);
    }

    @Override
    public void removeChangeListener(@Nonnull ITableModelListener<T> l) {
        this.m_listeners.remove(l);
    }

    protected List<ITableModelListener<T>> getListeners() {
        return this.m_listeners;
    }

    public void fireAdded(int index) throws Exception {
        T o = this.getItem(index);
        for (ITableModelListener<T> l : this.getListeners()) {
            l.rowAdded(this, index, o);
        }
    }

    public void fireDeleted(int index, T deleted) throws Exception {
        for (ITableModelListener<T> l : this.getListeners()) {
            l.rowDeleted(this, index, deleted);
        }
    }

    public void fireModified(int index) throws Exception {
        T o = this.getItem(index);
        for (ITableModelListener<T> l : this.getListeners()) {
            l.rowModified(this, index, o);
        }
    }

    public void fireModelChanged() throws Exception {
        for (ITableModelListener<T> l : this.getListeners()) {
            l.modelChanged(this);
        }
    }

    @Override
    public void refresh() {
    }
}

