/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.tbl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import to.etc.domui.component.tbl.IDataTableChangeListener;
import to.etc.domui.component.tbl.ITableModel;
import to.etc.domui.component.tbl.ITableModelListener;
import to.etc.domui.databinding.list.ListChangeAdd;
import to.etc.domui.databinding.list.ListChangeAssign;
import to.etc.domui.databinding.list.ListChangeDelete;
import to.etc.domui.databinding.list.ListChangeModify;
import to.etc.domui.databinding.list2.IListChangeListener;
import to.etc.domui.databinding.list2.IListChangeVisitor;
import to.etc.domui.databinding.list2.ListChangeEvent;
import to.etc.domui.databinding.observables.IObservableList;
import to.etc.domui.databinding.observables.ObservableListModelAdapter;
import to.etc.domui.dom.html.Div;
import to.etc.domui.dom.html.Page;
import to.etc.domui.util.IShelvedListener;
import to.etc.domui.util.JavascriptUtil;

public abstract class TableModelTableBase<T>
extends Div
implements ITableModelListener<T>,
IListChangeListener<T> {
    @Nullable
    private ITableModel<T> m_model;
    @Nonnull
    private List<IDataTableChangeListener> m_listeners = Collections.EMPTY_LIST;
    private boolean m_disableClipboardSelection;

    protected TableModelTableBase(@Nonnull ITableModel<T> model) {
        this.m_model = model;
        model.addChangeListener(this);
    }

    public TableModelTableBase() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(@Nonnull IDataTableChangeListener l) {
        TableModelTableBase tableModelTableBase = this;
        synchronized (tableModelTableBase) {
            if (this.m_listeners.contains(l)) {
                return;
            }
            this.m_listeners = new ArrayList<IDataTableChangeListener>(this.m_listeners);
            this.m_listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(@Nonnull IDataTableChangeListener l) {
        TableModelTableBase tableModelTableBase = this;
        synchronized (tableModelTableBase) {
            this.m_listeners = new ArrayList<IDataTableChangeListener>();
            this.m_listeners.remove(l);
        }
    }

    private synchronized List<IDataTableChangeListener> getListeners() {
        return this.m_listeners;
    }

    protected void fireModelChanged(@Nullable ITableModel<T> old, @Nullable ITableModel<T> nw) {
        for (IDataTableChangeListener l : this.getListeners()) {
            try {
                l.modelChanged(this, old, nw);
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
    }

    protected void firePageChanged() {
        for (IDataTableChangeListener l : this.getListeners()) {
            try {
                l.pageChanged(this);
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
    }

    protected void fireSelectionUIChanged() {
        for (IDataTableChangeListener l : this.getListeners()) {
            try {
                l.selectionUIChanged(this);
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
    }

    @Nonnull
    public ITableModel<T> getModel() {
        if (null != this.m_model) {
            return this.m_model;
        }
        throw new IllegalStateException("The table model has not been set.");
    }

    public void setModel(@Nonnull ITableModel<T> model) {
        if (model == null) {
            throw new IllegalArgumentException("Cannot set a table model to null");
        }
        ITableModel<T> itm = model;
        if (this.m_model == itm) {
            return;
        }
        ITableModel<T> old = this.m_model;
        if (this.m_model != null) {
            this.m_model.removeChangeListener(this);
        }
        this.m_model = itm;
        if (itm != null) {
            itm.addChangeListener(this);
        }
        this.forceRebuild();
        this.resetState();
        this.fireModelChanged(old, model);
    }

    @OverridingMethodsMustInvokeSuper
    protected void resetState() {
    }

    @Nonnull
    protected T getModelItem(int index) throws Exception {
        List<T> res = this.getModel().getItems(index, index + 1);
        if (res.size() == 0) {
            throw new IllegalStateException("Model did not return a row at index=" + index);
        }
        T val = res.get(0);
        if (val == null) {
            throw new IllegalStateException("Model item at index=" + index + " is null");
        }
        return val;
    }

    @Override
    protected void onShelve() throws Exception {
        super.onShelve();
        if (this.m_model instanceof IShelvedListener) {
            ((IShelvedListener)((Object)this.m_model)).onShelve();
        }
    }

    @Override
    protected void onUnshelve() throws Exception {
        super.onUnshelve();
        if (this.m_model instanceof IShelvedListener) {
            ((IShelvedListener)((Object)this.m_model)).onUnshelve();
            this.forceRebuild();
            this.firePageChanged();
        }
    }

    @Override
    protected void onRefresh() throws Exception {
        if (this.m_model != null) {
            this.m_model.refresh();
        }
    }

    public void setList(@Nonnull IObservableList<T> list) {
        ITableModel<T> om = this.m_model;
        if (om instanceof ObservableListModelAdapter) {
            ObservableListModelAdapter oa = (ObservableListModelAdapter)om;
            if (oa.getSource() == list) {
                return;
            }
            oa.getSource().removeChangeListener(this);
        }
        ObservableListModelAdapter<T> ma = new ObservableListModelAdapter<T>(list);
        this.setModel(ma);
        list.addChangeListener(this);
    }

    @Nullable
    public IObservableList<T> getList() {
        ITableModel<T> om = this.getModel();
        if (om instanceof ObservableListModelAdapter) {
            ObservableListModelAdapter oa = (ObservableListModelAdapter)om;
            return oa.getSource();
        }
        return null;
    }

    @Override
    public void onRemoveFromPage(Page p) {
        IObservableList<T> list = this.getList();
        if (null != list) {
            list.removeChangeListener(this);
        }
    }

    public boolean isDisableClipboardSelection() {
        return this.m_disableClipboardSelection;
    }

    public void setDisableClipboardSelection(boolean disableClipboardSelection) {
        if (this.m_disableClipboardSelection == disableClipboardSelection) {
            return;
        }
        this.m_disableClipboardSelection = disableClipboardSelection;
        if (this.isBuilt()) {
            if (disableClipboardSelection) {
                this.appendJavascript(JavascriptUtil.disableSelection(this));
            } else {
                this.appendJavascript(JavascriptUtil.enableSelection(this));
            }
        }
    }

    @Override
    public void handleChange(@Nonnull ListChangeEvent<T> event) throws Exception {
        if (event.getChanges().size() == 1) {
            event.visit(new IListChangeVisitor<T>(){

                @Override
                public void visitAdd(@Nonnull ListChangeAdd<T> l) throws Exception {
                    TableModelTableBase.this.rowAdded(TableModelTableBase.this.getModel(), l.getIndex(), l.getValue());
                }

                @Override
                public void visitDelete(@Nonnull ListChangeDelete<T> l) throws Exception {
                    TableModelTableBase.this.rowDeleted(TableModelTableBase.this.getModel(), l.getIndex(), l.getValue());
                }

                @Override
                public void visitModify(@Nonnull ListChangeModify<T> l) throws Exception {
                    TableModelTableBase.this.rowModified(TableModelTableBase.this.getModel(), l.getIndex(), l.getNewValue());
                }

                @Override
                public void visitAssign(@Nonnull ListChangeAssign<T> assign) throws Exception {
                    TableModelTableBase.this.forceRebuild();
                    TableModelTableBase.this.fireModelChanged(null, TableModelTableBase.this.getModel());
                }
            });
        } else {
            this.forceRebuild();
        }
    }
}

