/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.tree;

import java.util.List;
import to.etc.domui.component.tree.ITreeNode;

public abstract class AbstractTreeNodeBase<T extends ITreeNode<T>>
implements ITreeNode<T> {
    private T m_parent;
    private List<T> m_childList;

    public abstract List<T> loadChildren() throws Exception;

    public AbstractTreeNodeBase(T dad) {
        this.m_parent = dad;
    }

    public void setParent(T parent) {
        this.m_parent = parent;
    }

    public AbstractTreeNodeBase(T dad, List<T> children) {
        this.m_parent = dad;
        this.m_childList = children;
    }

    @Override
    public T getChild(int index) throws Exception {
        if (this.m_childList == null) {
            this.m_childList = this.loadChildren();
        }
        return (T)((ITreeNode)this.m_childList.get(index));
    }

    @Override
    public int getChildCount() throws Exception {
        if (this.m_childList == null) {
            this.m_childList = this.loadChildren();
        }
        return this.m_childList.size();
    }

    @Override
    public boolean hasChildren() throws Exception {
        if (this.m_childList == null) {
            return true;
        }
        return this.m_childList.size() != 0;
    }

    @Override
    public T getParent() throws Exception {
        return this.m_parent;
    }

    protected List<T> getChildList() {
        return this.m_childList;
    }

    protected void setChildList(List<T> childList) {
        this.m_childList = childList;
    }
}

