/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.tree;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.meta.ClassMetaModel;
import to.etc.domui.component.meta.MetaManager;
import to.etc.domui.component.meta.PropertyMetaModel;
import to.etc.domui.component.tbl.ICellClicked;
import to.etc.domui.component.tree.INodePredicate;
import to.etc.domui.component.tree.ITreeModel;
import to.etc.domui.component.tree.ITreeModelChangedListener;
import to.etc.domui.dom.html.ClickInfo;
import to.etc.domui.dom.html.Div;
import to.etc.domui.dom.html.IClicked;
import to.etc.domui.dom.html.IClicked2;
import to.etc.domui.dom.html.Img;
import to.etc.domui.dom.html.TBody;
import to.etc.domui.dom.html.TD;
import to.etc.domui.dom.html.TR;
import to.etc.domui.dom.html.Table;
import to.etc.domui.server.DomApplication;
import to.etc.domui.util.INodeContentRenderer;

public class Tree<T>
extends Div
implements ITreeModelChangedListener<T> {
    private ITreeModel<T> m_model;
    private boolean m_showRoot;
    private Table m_rootTable;
    private boolean m_expandRoot;
    private Map<Object, VisibleNode<T>> m_openMap = new HashMap<Object, VisibleNode<T>>();
    private INodeContentRenderer<?> m_contentRenderer;
    private INodeContentRenderer<T> m_actualContentRenderer;
    private Class<? extends INodeContentRenderer<T>> m_contentRendererClass;
    private PropertyMetaModel<?> m_propertyMetaModel;
    private ICellClicked<?> m_cellClicked;
    private INodePredicate<T> m_nodeSelectablePredicate;

    public Tree() {
        this.setCssClass("ui-tree");
    }

    public Tree(ITreeModel<T> model) {
        this();
        this.setModel(model);
    }

    @Override
    public void createContent() throws Exception {
        T root = this.getModel().getRoot();
        if (this.isShowRoot()) {
            Table t = this.m_rootTable = new Table();
            t.setCellSpacing("0");
            t.setCellPadding("0");
            TBody b = new TBody();
            t.add(b);
            VisibleNode<T> n = this.getVisibleNode(root);
            n.expanded = true;
            this.renderItem(b, n, true);
        } else {
            VisibleNode<T> n = this.getVisibleNode(root);
            n.expanded = true;
            this.m_rootTable = this.renderList(root, n);
        }
        if (this.m_expandRoot) {
            int i = this.getModel().getChildCount(root);
            while (--i >= 0) {
                T v = this.getModel().getChild(root, i);
                this.expandNode(v);
            }
        }
        this.add(this.m_rootTable);
    }

    private VisibleNode<T> getVisibleNode(T base) {
        VisibleNode<T> n = this.m_openMap.get(base);
        if (n == null) {
            n = new VisibleNode<T>(base);
            this.m_openMap.put(base, n);
        }
        return n;
    }

    private Table renderList(T base, VisibleNode<T> baseInfo) throws Exception {
        Table t = new Table();
        t.setCellSpacing("0");
        t.setCellPadding("0");
        TBody b = new TBody();
        t.add(b);
        int len = this.getModel().getChildCount(base);
        if (len == 0) {
            throw new IllegalStateException("Implement 'expanding node having 0 children': base=" + base);
        }
        VisibleNode[] vnar = new VisibleNode[len];
        for (int i = 0; i < len; ++i) {
            VisibleNode<T> chvn;
            T item = this.getModel().getChild(base, i);
            vnar[i] = chvn = this.getVisibleNode(item);
            this.renderItem(b, chvn, i == len - 1);
        }
        baseInfo.childNodes = vnar;
        return t;
    }

    private void renderItem(TBody b, VisibleNode<T> chvn, boolean last) throws Exception {
        final Object item = chvn.data;
        chvn.nodeRow = b.addRow();
        TD td = b.addCell();
        Img img = new Img();
        td.add(img);
        img.setImgBorder(0);
        TD cont = b.addCell();
        cont.setCssClass("ui-tr-val");
        this.renderContent(cont, item);
        if (!this.getModel().hasChildren(item) || chvn.unexpandable) {
            img.setSrc(last ? "THEME/tree-leaf-last.png" : "THEME/tree-leaf.png");
            chvn.unexpandable = true;
            chvn.expanded = false;
        } else {
            img.setCssClass("ui-tr-act");
            boolean expanded = this.isExpanded(item);
            if (!expanded) {
                img.setSrc(last ? "THEME/tree-closed-last.png" : "THEME/tree-closed.png");
                img.setClicked(new IClicked<Img>(){

                    @Override
                    public void clicked(@Nonnull Img bxx) throws Exception {
                        Tree.this.expandNode(item);
                    }
                });
            } else {
                img.setSrc(last ? "THEME/tree-opened-last.png" : "THEME/tree-opened.png");
                b.addRow();
                td = b.addCell();
                if (!last) {
                    td.setBackgroundImage(this.branchurl());
                }
                td = b.addCell();
                Table tc = this.renderList(item, chvn);
                td.add(tc);
                img.setClicked(new IClicked<Img>(){

                    @Override
                    public void clicked(@Nonnull Img bxx) throws Exception {
                        Tree.this.collapseNode(item);
                    }
                });
            }
        }
    }

    public void expandNode(T item) throws Exception {
        this.getModel().expandChildren(item);
        List<T> path = this.getTreePath(item);
        if (path.size() == 0) {
            throw new IllegalStateException("No TREE path found to node=" + item);
        }
        T root = this.getModel().getRoot();
        if (root != path.get(0)) {
            throw new IllegalStateException("Tree path does NOT start with the root node-> model implementation sucks?");
        }
        for (final T o : path) {
            VisibleNode<T> vn = this.getVisibleNode(o);
            vn.expanded = true;
            if (vn.childNodes != null || vn.nodeRow == null) continue;
            TR row = vn.nodeRow;
            TD td = (TD)row.getChild(0);
            Img img = (Img)td.getChild(0);
            int rowix = row.getParent().findChildIndex(row);
            boolean last = row.getParent().getChildCount() == rowix + 1;
            int len = this.getModel().getChildCount(o);
            if (len == 0) {
                img.remove();
                img = new Img(last ? "THEME/tree-leaf-last.png" : "THEME/tree-leaf.png");
                td.add(img);
                vn.expanded = false;
                vn.unexpandable = true;
                img.setClicked(null);
                continue;
            }
            img.remove();
            img = new Img(last ? "THEME/tree-opened-last.png" : "THEME/tree-opened.png");
            td.add(img);
            img.setCssClass("ui-tr-act");
            img.setClicked(new IClicked<Img>(){

                @Override
                public void clicked(@Nonnull Img bxx) throws Exception {
                    Tree.this.collapseNode(o);
                }
            });
            TR nr = new TR();
            row.getParent().add(rowix + 1, nr);
            td = nr.addCell();
            if (!last) {
                td.setBackgroundImage(this.branchurl());
            }
            td = nr.addCell();
            Table tc = this.renderList(o, vn);
            td.add(tc);
            img.setClicked(new IClicked<Img>(){

                @Override
                public void clicked(@Nonnull Img bxx) throws Exception {
                    Tree.this.collapseNode(o);
                }
            });
        }
    }

    public void collapseNode(final T item) throws Exception {
        VisibleNode<T> vn = this.m_openMap.get(item);
        if (vn == null || !vn.expanded) {
            return;
        }
        this.dropCrud(vn);
        this.getModel().collapseChildren(item);
        vn.expanded = false;
        vn.childNodes = null;
        TR row = vn.nodeRow;
        TD td = (TD)row.getChild(0);
        Img img = (Img)td.getChild(0);
        int rowix = row.getParent().findChildIndex(row);
        boolean last = row.getParent().getChildCount() == rowix + 2;
        img.remove();
        img = new Img(last ? "THEME/tree-closed-last.png" : "THEME/tree-closed.png");
        td.add(img);
        img.setCssClass("ui-tr-act");
        img.setClicked(new IClicked<Img>(){

            @Override
            public void clicked(@Nonnull Img bxx) throws Exception {
                Tree.this.expandNode(item);
            }
        });
        row.getParent().getChild(rowix + 1).remove();
    }

    public void collapseAll() throws Exception {
        T item = this.getModel().getRoot();
        for (int i = 0; i < this.getModel().getChildCount(item); ++i) {
            T xx = this.getModel().getChild(item, i);
            this.collapseNode(xx);
        }
    }

    public void toggleNode(T item) throws Exception {
        if (this.isExpanded(item)) {
            this.collapseNode(item);
        } else {
            this.expandNode(item);
        }
    }

    private void dropCrud(VisibleNode<T> vnbase) throws Exception {
        if (vnbase.childNodes == null) {
            return;
        }
        int ix = 0;
        for (VisibleNode vn : vnbase.childNodes) {
            if (vn == null) {
                throw new IllegalStateException("?? Element " + ix + " of parent=" + vnbase.data + " is null???");
            }
            this.m_openMap.remove(vn.data);
            this.dropCrud(vn);
            if (vn.expanded) {
                this.getModel().collapseChildren(vn.data);
            }
            ++ix;
        }
    }

    private String branchurl() {
        return this.getThemedResourceRURL("THEME/tree-branch.png");
    }

    public List<T> getTreePath(T item) throws Exception {
        ArrayList path = new ArrayList();
        this.addParentPath(path, item);
        return path;
    }

    private void addParentPath(List<T> path, T item) throws Exception {
        T parent = this.getModel().getParent(item);
        if (parent == this.getModel().getRoot()) {
            path.add(parent);
        } else if (parent != null) {
            this.addParentPath(path, parent);
        }
        path.add(item);
    }

    private INodeContentRenderer<?> calculateContentRenderer(Object val) {
        if (this.m_contentRenderer != null) {
            return this.m_contentRenderer;
        }
        if (this.m_contentRendererClass != null) {
            return DomApplication.get().createInstance(this.m_contentRendererClass, new Object[0]);
        }
        if (val == null) {
            throw new IllegalStateException("Cannot calculate content renderer for null value");
        }
        ClassMetaModel cmm = MetaManager.findClassMeta(val.getClass());
        return MetaManager.createDefaultComboRenderer(this.m_propertyMetaModel, cmm);
    }

    private void renderContent(final TD cell, final T value) throws Exception {
        if (this.m_actualContentRenderer == null) {
            this.m_actualContentRenderer = this.calculateContentRenderer(value);
        }
        this.m_actualContentRenderer.renderNodeContent(this, cell, value, this);
        if (this.isSelectable(value)) {
            cell.addCssClass("ui-tr-sel");
            if (this.isSelected(value)) {
                cell.addCssClass("ui-tr-selected");
            }
            cell.setClicked(new IClicked2<TD>(){

                @Override
                public void clicked(@Nonnull TD node, @Nonnull ClickInfo clinfo) throws Exception {
                    Tree.this.cellClicked(cell, value, clinfo);
                }
            });
        }
        this.updateSelectable(cell, value);
    }

    private void updateSelectable(@Nonnull TD cell, @Nonnull T value) throws Exception {
        INodePredicate<T> predicate = this.m_nodeSelectablePredicate;
        if (null != predicate) {
            boolean isSelectable = predicate.predicate(value);
            if (isSelectable) {
                cell.addCssClass("ui-tr-selectable");
                cell.removeCssClass("ui-tr-unselectable");
            } else {
                cell.addCssClass("ui-tr-unselectable");
                cell.removeCssClass("ui-tr-selectable");
            }
        }
    }

    protected void cellClicked(@Nonnull TD cell, @Nonnull T value, @Nonnull ClickInfo clinfo) throws Exception {
        if (this.getCellClicked() != null) {
            this.getCellClicked().cellClicked(cell, value);
        }
    }

    public boolean isExpanded(T node) {
        VisibleNode<T> vn = this.m_openMap.get(node);
        if (vn == null) {
            return false;
        }
        return vn.expanded;
    }

    protected boolean isSelectable(@Nonnull T node) throws Exception {
        if (this.getCellClicked() == null) {
            return false;
        }
        if (this.m_nodeSelectablePredicate == null) {
            return true;
        }
        return this.m_nodeSelectablePredicate.predicate(node);
    }

    protected void markAsSelected(T node, boolean selected) throws Exception {
        VisibleNode<T> vn;
        if (null != node) {
            this.expandNode(node);
        }
        if ((vn = this.m_openMap.get(node)) == null) {
            return;
        }
        if (vn.nodeRow == null) {
            return;
        }
        TD cell = (TD)vn.nodeRow.getChild(1);
        if (selected) {
            cell.addCssClass("ui-tr-selected");
        } else {
            cell.removeCssClass("ui-tr-selected");
        }
        cell.removeAllChildren();
        this.renderContent(cell, node);
    }

    @Nullable
    public TR locateRowIfExpanded(T node) {
        VisibleNode<T> vn = this.m_openMap.get(node);
        if (null != vn) {
            return vn.nodeRow;
        }
        return null;
    }

    protected boolean isSelected(@Nonnull T node) {
        return false;
    }

    public void setModel(ITreeModel<T> model) {
        ITreeModel<T> itm = model;
        if (this.m_model == itm) {
            return;
        }
        if (this.m_model != null) {
            this.m_model.removeChangeListener(this);
        }
        this.m_model = itm;
        this.m_openMap.clear();
        if (itm != null) {
            itm.addChangeListener(this);
        }
        this.forceRebuild();
    }

    public void setExpandRoot(boolean x) throws Exception {
        if (this.m_expandRoot == x) {
            return;
        }
        this.m_expandRoot = x;
        if (!x || !this.isBuilt()) {
            return;
        }
        T root = this.getModel().getRoot();
        if (!this.isExpanded(root)) {
            this.expandNode(root);
        }
    }

    public boolean getExpandRoot() {
        return this.m_expandRoot;
    }

    public ITreeModel<T> getModel() {
        return this.m_model;
    }

    public boolean isShowRoot() {
        return this.m_showRoot;
    }

    public void setShowRoot(boolean showRoot) {
        this.m_showRoot = showRoot;
    }

    public INodeContentRenderer<?> getContentRenderer() {
        return this.m_contentRenderer;
    }

    public void setContentRenderer(INodeContentRenderer<?> contentRenderer) {
        this.m_contentRenderer = contentRenderer;
    }

    public Class<? extends INodeContentRenderer<?>> getContentRendererClass() {
        return this.m_contentRendererClass;
    }

    public void setContentRendererClass(Class<? extends INodeContentRenderer<T>> contentRendererClass) {
        this.m_contentRendererClass = contentRendererClass;
    }

    public ICellClicked<?> getCellClicked() {
        return this.m_cellClicked;
    }

    public void setCellClicked(ICellClicked<?> cellClicked) {
        this.m_cellClicked = cellClicked;
    }

    public PropertyMetaModel<?> getPropertyMetaModel() {
        return this.m_propertyMetaModel;
    }

    public void setPropertyMetaModel(PropertyMetaModel<?> propertyMetaModel) {
        this.m_propertyMetaModel = propertyMetaModel;
    }

    public INodePredicate<T> getNodeSelectablePredicate() {
        return this.m_nodeSelectablePredicate;
    }

    public void setNodeSelectablePredicate(INodePredicate<T> nodeSelectablePredicate) {
        this.m_nodeSelectablePredicate = nodeSelectablePredicate;
    }

    @Override
    public void onNodeAdded(T parent, int index, T node) {
        throw new IllegalStateException("Not implemented");
    }

    @Override
    public void onNodeUpdated(T node) {
        throw new IllegalStateException("Not implemented");
    }

    @Override
    public void onNodeRemoved(T oldParent, int oldIndex, T deletedNode) {
        throw new IllegalStateException("Not implemented");
    }

    static class VisibleNode<V> {
        final V data;
        TR nodeRow;
        VisibleNode<V>[] childNodes;
        boolean expanded;
        boolean unexpandable;

        public VisibleNode(V data) {
            this.data = data;
        }
    }
}

