/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.tree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.tree.ITreeModel;
import to.etc.domui.component.tree.ITreeModelChangedListener;
import to.etc.domui.component.tree.ITreeNode;

public class TreeNodeModelBase<T extends ITreeNode<T>>
implements ITreeModel<T> {
    private T m_root;
    private List<ITreeModelChangedListener<T>> m_listeners = Collections.EMPTY_LIST;

    public TreeNodeModelBase(T root) {
        this.m_root = root;
    }

    @Override
    public void addChangeListener(@Nonnull ITreeModelChangedListener<T> l) {
        if (this.m_listeners == Collections.EMPTY_LIST) {
            this.m_listeners = new ArrayList<ITreeModelChangedListener<T>>();
        }
        if (this.m_listeners.contains(l)) {
            return;
        }
        this.m_listeners.add(l);
    }

    @Override
    public void removeChangeListener(@Nonnull ITreeModelChangedListener<T> l) {
        this.m_listeners.remove(l);
    }

    protected List<ITreeModelChangedListener<T>> getListeners() {
        return this.m_listeners;
    }

    @Override
    @Nonnull
    public T getChild(@Nullable T parent, int index) throws Exception {
        if (null == parent) {
            throw new IllegalArgumentException("Parent cannot be null");
        }
        return parent.getChild(index);
    }

    @Override
    public int getChildCount(@Nullable T item) throws Exception {
        if (null == item) {
            throw new IllegalArgumentException("Item cannot be null");
        }
        return item.getChildCount();
    }

    @Override
    @Nullable
    public T getParent(@Nullable T child) throws Exception {
        if (null == child) {
            return null;
        }
        return child.getParent();
    }

    @Override
    @Nullable
    public T getRoot() throws Exception {
        return this.m_root;
    }

    @Override
    public boolean hasChildren(@Nullable T item) throws Exception {
        if (null == item) {
            throw new IllegalArgumentException("Item cannot be null");
        }
        return item.hasChildren();
    }

    @Override
    public void expandChildren(@Nullable T item) throws Exception {
    }

    @Override
    public void collapseChildren(@Nullable T item) throws Exception {
    }
}

