/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.tree;

import to.etc.domui.component.meta.MetaManager;
import to.etc.domui.component.tree.ITreeModel;
import to.etc.domui.component.tree.Tree;
import to.etc.domui.dom.html.ClickInfo;
import to.etc.domui.dom.html.IHasChangeListener;
import to.etc.domui.dom.html.IValueChanged;
import to.etc.domui.dom.html.TD;

public class TreeSelect<T>
extends Tree<T>
implements IHasChangeListener {
    private T m_value;
    private IValueChanged<?> m_onValueChanged;

    public TreeSelect() {
    }

    public TreeSelect(ITreeModel<T> model) {
        super(model);
    }

    public T getValue() {
        return this.m_value;
    }

    public void setValue(T value) throws Exception {
        if (MetaManager.areObjectsEqual(value, this.m_value)) {
            return;
        }
        if (value != null && this.getNodeSelectablePredicate() != null) {
            try {
                if (!this.getNodeSelectablePredicate().predicate(value)) {
                    throw new IllegalStateException("You cannot the value to a node that is marked as NOT SELECTABLE by the nodeSelectablePredicate");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        T oldValue = this.m_value;
        this.m_value = value;
        if (oldValue != null) {
            this.markAsSelected(oldValue, false);
        }
        if (value != null) {
            this.markAsSelected(value, true);
        }
        this.internalOnValueChanged();
    }

    @Override
    public boolean isSelectable(T node) throws Exception {
        if (this.getNodeSelectablePredicate() == null) {
            return true;
        }
        return this.getNodeSelectablePredicate().predicate(node);
    }

    @Override
    protected void cellClicked(TD cell, T value, ClickInfo clinfo) throws Exception {
        this.setValue(value);
        super.cellClicked(cell, value, clinfo);
    }

    @Override
    protected boolean isSelected(T node) {
        return MetaManager.areObjectsEqual(node, this.m_value);
    }

    @Override
    public IValueChanged<?> getOnValueChanged() {
        return this.m_onValueChanged;
    }

    @Override
    public void setOnValueChanged(IValueChanged<?> onValueChanged) {
        this.m_onValueChanged = onValueChanged;
    }
}

