/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.tree;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.DefaultNonNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.meta.MetaManager;
import to.etc.domui.component.tree.INodePredicate;
import to.etc.domui.component.tree.ITreeModel;
import to.etc.domui.component.tree.Tree;
import to.etc.domui.dom.html.ClickInfo;
import to.etc.domui.dom.html.IHasChangeListener;
import to.etc.domui.dom.html.IValueChanged;
import to.etc.domui.dom.html.TD;
import to.etc.domui.util.DomUtil;
import to.etc.domui.util.JavascriptUtil;

@DefaultNonNull
public class TreeSelectMulti<T>
extends Tree<T>
implements IHasChangeListener {
    @Nonnull
    private Set<T> m_value = new HashSet<T>();
    @Nullable
    private IValueChanged<?> m_onValueChanged;

    public TreeSelectMulti() {
    }

    public TreeSelectMulti(ITreeModel<T> model) {
        super(model);
    }

    @Override
    public void createContent() throws Exception {
        super.createContent();
        this.appendCreateJS(JavascriptUtil.disableSelection(this));
    }

    @Nonnull
    public Set<T> getValue() {
        return new HashSet<T>(this.m_value);
    }

    public void setValue(@Nullable Set<T> value) throws Exception {
        this.internalSetValue(value, false);
    }

    private void internalSetValue(@Nullable Set<T> value, boolean callListeners) throws Exception {
        if (null == value) {
            value = DomUtil.nullChecked(Collections.EMPTY_SET);
        }
        if (MetaManager.areObjectsEqual(value, this.m_value)) {
            return;
        }
        HashSet<T> newSet = new HashSet<T>(value);
        INodePredicate predicate = this.getNodeSelectablePredicate();
        if (null != predicate) {
            for (Object item : value) {
                if (predicate.predicate(item)) continue;
                newSet.remove(item);
            }
        }
        HashSet<T> currentSet = new HashSet<T>(this.m_value);
        currentSet.removeAll(newSet);
        for (Object oldItem : currentSet) {
            this.markAsSelected(oldItem, false);
        }
        HashSet addedSet = new HashSet(newSet);
        addedSet.removeAll(this.m_value);
        for (Object newItem : addedSet) {
            this.markAsSelected(newItem, true);
        }
        this.m_value = newSet;
        if (callListeners) {
            this.internalOnValueChanged();
        }
    }

    @Override
    public boolean isSelectable(T node) throws Exception {
        INodePredicate<T> predicate = this.getNodeSelectablePredicate();
        if (predicate == null) {
            return true;
        }
        return predicate.predicate(node);
    }

    @Override
    protected void cellClicked(TD cell, T value, ClickInfo clinfo) throws Exception {
        boolean select;
        boolean append = clinfo.isControl() || clinfo.isShift();
        HashSet<T> set = new HashSet<T>(this.m_value);
        boolean bl = select = !set.contains(value);
        if (!append) {
            set.clear();
        }
        if (select) {
            set.add(value);
        } else {
            set.remove(value);
        }
        this.internalSetValue(set, true);
        super.cellClicked(cell, value, clinfo);
    }

    @Override
    protected boolean isSelected(T node) {
        return this.m_value.contains(this.m_value);
    }

    @Override
    @Nullable
    public IValueChanged<?> getOnValueChanged() {
        return this.m_onValueChanged;
    }

    @Override
    public void setOnValueChanged(@Nullable IValueChanged<?> onValueChanged) {
        this.m_onValueChanged = onValueChanged;
    }
}

