/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.tree;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.buttons.DefaultButton;
import to.etc.domui.component.layout.ButtonBar;
import to.etc.domui.component.layout.FloatingWindow;
import to.etc.domui.component.layout.IWindowClosed;
import to.etc.domui.component.tbl.ICellClicked;
import to.etc.domui.component.tree.ITreeModel;
import to.etc.domui.component.tree.Tree;
import to.etc.domui.dom.css.Overflow;
import to.etc.domui.dom.html.Div;
import to.etc.domui.dom.html.IClickBase;
import to.etc.domui.dom.html.IClicked;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.util.INodeContentRenderer;
import to.etc.domui.util.Msgs;

public class TreeSelectionWindow<T>
extends FloatingWindow
implements ICellClicked<T> {
    private Tree<T> m_tree;
    private T m_selected;
    @Nonnull
    private ITreeModel<T> m_model;
    private NodeBase m_selectedNode;
    private long m_lastClickTS;
    private IClickBase<?> m_clicked;
    private IClickBase<?> m_cancelClicked;
    private INodeContentRenderer<T> m_contentRenderer;

    public TreeSelectionWindow(boolean modal, String txt, @Nonnull ITreeModel<T> model) {
        super(modal, txt);
        this.m_model = model;
        this.setOnClose(new IWindowClosed(){

            @Override
            public void closed(@Nonnull String closeReason) throws Exception {
                TreeSelectionWindow.this.cancel();
            }
        });
    }

    @Override
    public void createContent() throws Exception {
        this.setWidth("400px");
        super.createContent();
        ButtonBar bb = new ButtonBar();
        this.add(bb);
        bb.addButton(Msgs.BUNDLE.getString("ui.tsw.select"), new IClicked<DefaultButton>(){

            @Override
            public void clicked(@Nonnull DefaultButton clickednode) throws Exception {
                TreeSelectionWindow.this.select();
            }
        });
        bb.addButton(Msgs.BUNDLE.getString("ui.tsw.cancel"), new IClicked<DefaultButton>(){

            @Override
            public void clicked(@Nonnull DefaultButton clickednode) throws Exception {
                TreeSelectionWindow.this.cancel();
            }
        });
        Div fixed = new Div();
        this.add(fixed);
        fixed.setHeight("300px");
        fixed.setOverflow(Overflow.AUTO);
        this.m_tree = new Tree();
        fixed.add(this.m_tree);
        this.m_tree.setModel(this.m_model);
        this.m_tree.setContentRenderer(this.m_contentRenderer);
        this.m_tree.setCellClicked(this);
    }

    protected void cancel() throws Exception {
        this.close();
        this.m_selected = null;
        this.m_selectedNode = null;
        if (this.getCancelClicked() != null) {
            ((IClicked)this.getCancelClicked()).clicked(this);
            return;
        }
        IClickBase<?> clicked = this.getClicked();
        if (clicked != null) {
            ((IClicked)clicked).clicked(this);
        }
    }

    protected void select() throws Exception {
        if (this.m_selected == null) {
            return;
        }
        this.close();
        IClickBase<?> clicked = this.getClicked();
        if (clicked != null) {
            ((IClicked)clicked).clicked(this);
        }
    }

    @Override
    public final void cellClicked(@Nonnull NodeBase tr, @Nonnull T rowval) throws Exception {
        long dt;
        long ts = System.currentTimeMillis();
        if (this.m_selected == rowval && (dt = ts - this.m_lastClickTS) < 500L) {
            this.select();
            return;
        }
        if (this.m_selectedNode != null) {
            this.m_selectedNode.removeCssClass("selected");
            this.m_selected = null;
            this.m_selectedNode = null;
        }
        this.m_lastClickTS = ts;
        this.m_selectedNode = tr;
        this.m_selected = rowval;
        tr.addCssClass("selected");
    }

    @Override
    public boolean internalNeedClickHandler() {
        return false;
    }

    public T getSelected() {
        return this.m_selected;
    }

    public void setSelected(T selected) {
        this.m_selected = selected;
    }

    @Override
    public IClickBase<?> getClicked() {
        return this.m_clicked;
    }

    @Override
    public void setClicked(@Nullable IClickBase<?> clicked) {
        this.m_clicked = clicked;
    }

    public IClickBase<?> getCancelClicked() {
        return this.m_cancelClicked;
    }

    public void setCancelClicked(IClickBase<?> cancelClicked) {
        this.m_cancelClicked = cancelClicked;
    }

    public INodeContentRenderer<T> getContentRenderer() {
        return this.m_contentRenderer;
    }

    public void setContentRenderer(INodeContentRenderer<T> contentRenderer) {
        this.m_contentRenderer = contentRenderer;
    }
}

