/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.upload;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import to.etc.domui.component.buttons.DefaultButton;
import to.etc.domui.component.upload.BulkUpload;
import to.etc.domui.component.upload.IUploadAcceptingComponent;
import to.etc.domui.component.upload.UploadPart;
import to.etc.domui.dom.header.HeaderContributor;
import to.etc.domui.dom.html.Div;
import to.etc.domui.dom.html.IClicked;
import to.etc.domui.dom.html.Page;
import to.etc.domui.dom.html.Span;
import to.etc.domui.parts.ComponentPartRenderer;
import to.etc.domui.server.RequestContextImpl;
import to.etc.domui.state.ConversationContext;
import to.etc.domui.state.UIContext;
import to.etc.domui.util.Msgs;
import to.etc.domui.util.upload.UploadItem;

public class BulkUploadButton
extends Div
implements IUploadAcceptingComponent {
    private final List<UploadItem> m_newItemList = new ArrayList<UploadItem>();
    private final List<UploadItem> m_itemList = new ArrayList<UploadItem>();
    @Nullable
    private BulkUpload.IUpload m_onUpload;
    @Nullable
    private IClicked<BulkUploadButton> m_onUploadsStarted;
    @Nullable
    private IClicked<BulkUploadButton> m_onUploadsComplete;
    private DefaultButton m_startButton;

    public BulkUploadButton() {
        this.setCssClass("ui-bupb");
    }

    @Override
    public void createContent() throws Exception {
        this.m_startButton = new DefaultButton(Msgs.BUNDLE.getString("bupl.select.files"));
        Span sp = new Span();
        this.add(sp);
        this.add(this.m_startButton);
        StringBuilder sb = new StringBuilder();
        ComponentPartRenderer.appendComponentURL(sb, UploadPart.class, this, UIContext.getRequestContext());
        sb.append("?uniq=" + System.currentTimeMillis());
        String url = sb.toString();
        this.appendCreateJS("WebUI.bulkUpload('" + this.getActualID() + "','" + sp.getActualID() + "','" + url + "');");
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public void onAddedToPage(Page p) {
        this.getPage().addHeaderContributor(HeaderContributor.loadJavascript("$js/swfupload.js"), 10);
        this.getPage().addHeaderContributor(HeaderContributor.loadJavascript("$js/jquery.swfupload.js"), 10);
        this.getPage().addHeaderContributor(HeaderContributor.loadJavascript("$js/swfupload.queue.js"), 10);
        this.getPage().addHeaderContributor(HeaderContributor.loadJavascript("$js/swfupload.swfobject.js"), 10);
        super.onAddedToPage(p);
    }

    @Nullable
    public BulkUpload.IUpload getOnUpload() {
        return this.m_onUpload;
    }

    public void setOnUpload(BulkUpload.IUpload onUpload) {
        this.m_onUpload = onUpload;
    }

    @Override
    public boolean handleUploadRequest(@Nonnull RequestContextImpl param, @Nonnull ConversationContext conversation) throws Exception {
        UploadItem[] uiar = param.getFileParameter("filedata");
        if (uiar != null) {
            for (UploadItem ui : uiar) {
                conversation.registerTempFile(ui.getFile());
                this.m_newItemList.add(ui);
            }
        }
        return false;
    }

    @Override
    public void componentHandleWebAction(@Nonnull RequestContextImpl ctx, @Nonnull String action) throws Exception {
        if ("uploadDone".equals(action)) {
            this.handleUploadDone();
        } else if ("queueComplete".equals(action)) {
            this.m_startButton.setDisabled(false);
            this.m_startButton.setTitle("");
            IClicked<BulkUploadButton> eh = this.getOnUploadsComplete();
            if (null != eh) {
                eh.clicked(this);
            }
        } else if ("queueStart".equals(action)) {
            this.m_startButton.setDisabled(true);
            this.m_startButton.setTitle(Msgs.BUNDLE.getString("bupl.disabled"));
            IClicked<BulkUploadButton> eh = this.getOnUploadsStarted();
            if (null != eh) {
                eh.clicked(this);
            }
        } else {
            super.componentHandleWebAction(ctx, action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleUploadDone() throws Exception {
        while (this.m_newItemList.size() > 0) {
            UploadItem item = this.m_newItemList.remove(0);
            boolean remove = true;
            BulkUpload.IUpload onUpload = this.getOnUpload();
            if (onUpload == null) continue;
            try {
                remove = onUpload.fileUploaded(item);
            }
            finally {
                if (remove) {
                    item.getFile().delete();
                    continue;
                }
                this.m_itemList.add(item);
            }
        }
    }

    public List<UploadItem> getUploadFileList() {
        return new ArrayList<UploadItem>(this.m_itemList);
    }

    @Nullable
    public IClicked<BulkUploadButton> getOnUploadsStarted() {
        return this.m_onUploadsStarted;
    }

    public void setOnUploadsStarted(@Nullable IClicked<BulkUploadButton> onUploadsStarted) {
        this.m_onUploadsStarted = onUploadsStarted;
    }

    @Nullable
    public IClicked<BulkUploadButton> getOnUploadsComplete() {
        return this.m_onUploadsComplete;
    }

    public void setOnUploadsComplete(@Nullable IClicked<BulkUploadButton> onUploadsComplete) {
        this.m_onUploadsComplete = onUploadsComplete;
    }
}

