/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.upload;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.buttons.DefaultButton;
import to.etc.domui.component.misc.MessageFlare;
import to.etc.domui.component.upload.IUploadAcceptingComponent;
import to.etc.domui.component.upload.UploadPart;
import to.etc.domui.dom.errors.UIMessage;
import to.etc.domui.dom.html.Div;
import to.etc.domui.dom.html.FileInput;
import to.etc.domui.dom.html.Form;
import to.etc.domui.dom.html.IClicked;
import to.etc.domui.dom.html.IControl;
import to.etc.domui.dom.html.IValueChanged;
import to.etc.domui.dom.html.NodeContainer;
import to.etc.domui.dom.html.Page;
import to.etc.domui.dom.html.TBody;
import to.etc.domui.dom.html.TD;
import to.etc.domui.dom.html.Table;
import to.etc.domui.parts.ComponentPartRenderer;
import to.etc.domui.server.RequestContextImpl;
import to.etc.domui.state.ConversationContext;
import to.etc.domui.state.UIContext;
import to.etc.domui.trouble.ValidationException;
import to.etc.domui.util.DomUtil;
import to.etc.domui.util.Msgs;
import to.etc.domui.util.upload.FileUploadException;
import to.etc.domui.util.upload.UploadItem;

public class FileUpload
extends Div
implements IUploadAcceptingComponent,
IControl<UploadItem> {
    private String m_allowedExtensions;
    private int m_maxSize;
    private boolean m_mandatory;
    private int m_maxFiles = 1;
    List<UploadItem> m_files = new ArrayList<UploadItem>();
    private FileInput m_input;
    private IValueChanged<?> m_onValueChanged;
    private boolean m_disabled;
    private boolean m_readOnly;

    public FileUpload() {
    }

    public FileUpload(int maxfiles, String allowedExt) {
        this.m_maxFiles = maxfiles;
        this.m_allowedExtensions = allowedExt;
    }

    @Override
    public void createContent() throws Exception {
        this.renderSelectedFiles();
    }

    private void renderSelectedFiles() {
        Table t = new Table();
        t.addCssClass("ui-fu-selected");
        this.add(t);
        TBody b = new TBody();
        t.add(b);
        if (!this.isFull()) {
            int maxSize;
            b.addRow();
            TD td = b.addCell();
            td.setColspan(2);
            Form f = new Form();
            td.add(f);
            f.setCssClass("ui-szless");
            f.setEnctype("multipart/form-data");
            f.setMethod("POST");
            StringBuilder sb = new StringBuilder();
            ComponentPartRenderer.appendComponentURL(sb, UploadPart.class, this, UIContext.getRequestContext());
            sb.append("?uniq=" + System.currentTimeMillis());
            f.setAction(sb.toString());
            FileInput fi = new FileInput();
            f.add(fi);
            fi.setSpecialAttribute("onkeypress", "WebUI.preventIE11DefaultAction(event)");
            fi.setSpecialAttribute("onchange", "WebUI.fileUploadChange(event)");
            fi.setDisabled(this.isDisabled() || this.isReadOnly());
            if (null != this.m_allowedExtensions) {
                fi.setSpecialAttribute("fuallowed", this.m_allowedExtensions);
            }
            if ((maxSize = this.getMaxSize()) <= 0) {
                maxSize = 0x6400000;
            }
            fi.setSpecialAttribute("fumaxsize", Integer.toString(maxSize));
            this.m_input = fi;
        }
        for (final UploadItem ufi : this.m_files) {
            b.addRow();
            TD td = b.addCell();
            td.setText(ufi.getRemoteFileName() + " (" + ufi.getContentType() + ")");
            td = b.addCell();
            if (this.isDisabled() || this.isReadOnly()) continue;
            td.add(new DefaultButton(Msgs.BUNDLE.getString("upld.delete"), "THEME/btnDelete.png", new IClicked<DefaultButton>(){

                @Override
                public void clicked(@Nonnull DefaultButton bx) throws Exception {
                    FileUpload.this.removeUploadItem(ufi);
                    if (FileUpload.this.m_onValueChanged != null) {
                        FileUpload.this.m_onValueChanged.onValueChanged(FileUpload.this);
                    }
                }
            }));
        }
    }

    FileInput getInput() {
        return this.m_input;
    }

    @Nonnull
    public List<UploadItem> getFiles() {
        return this.m_files;
    }

    @Override
    @Nullable
    public UploadItem getValue() {
        if (this.m_maxFiles != 1) {
            throw new IllegalStateException("Can only be called for max files = 1");
        }
        if (this.m_files.size() == 0) {
            if (this.isMandatory()) {
                this.setMessage(UIMessage.error(Msgs.BUNDLE, "ui.mandatory", new Object[0]));
                throw new ValidationException(Msgs.BUNDLE, "ui.mandatory", new Object[0]);
            }
            this.clearMessage();
            return null;
        }
        this.clearMessage();
        return this.m_files.get(0);
    }

    @Override
    public void setValue(@Nullable UploadItem v) {
        if (null == v) {
            this.clear();
            return;
        }
        if (this.m_files.size() > 1 || this.m_files.get(0) != v) {
            this.clear();
            this.m_files.add(v);
            this.forceRebuild();
        }
    }

    @Override
    @Nullable
    public UploadItem getValueSafe() {
        if (this.m_maxFiles != 1) {
            throw new IllegalStateException("Can only be called for max files = 1");
        }
        if (this.m_files.size() == 0) {
            return null;
        }
        return this.m_files.get(0);
    }

    public boolean isFull() {
        return this.m_files.size() >= this.m_maxFiles;
    }

    public void removeUploadItem(UploadItem ufi) {
        if (this.m_files.remove(ufi)) {
            this.forceRebuild();
        }
    }

    public void removeAllUploads() {
        if (this.m_files.size() == 0) {
            return;
        }
        this.m_files.clear();
        this.forceRebuild();
    }

    public void clear() {
        this.removeAllUploads();
    }

    public String getAllowedExtensions() {
        return this.m_allowedExtensions;
    }

    public void setAllowedExtensions(String allowedExtensions) {
        if (DomUtil.isEqual((Object)allowedExtensions, (Object)this.m_allowedExtensions)) {
            return;
        }
        this.m_allowedExtensions = allowedExtensions;
        this.changed();
    }

    @Override
    public boolean isMandatory() {
        return this.m_mandatory;
    }

    @Override
    public void setMandatory(boolean required) {
        this.m_mandatory = required;
    }

    public int getMaxFiles() {
        return this.m_maxFiles;
    }

    public void setMaxFiles(int maxFiles) {
        this.m_maxFiles = maxFiles;
    }

    @Override
    public IValueChanged<?> getOnValueChanged() {
        return this.m_onValueChanged;
    }

    @Override
    public void setOnValueChanged(IValueChanged<?> onValueChanged) {
        this.m_onValueChanged = onValueChanged;
    }

    @Override
    public boolean isDisabled() {
        return this.m_disabled;
    }

    @Override
    public void setDisabled(boolean disabled) {
        if (this.m_disabled == disabled) {
            return;
        }
        this.m_disabled = disabled;
        this.forceRebuild();
    }

    public int getMaxSize() {
        return this.m_maxSize;
    }

    public void setMaxSize(int maxSize) {
        this.m_maxSize = maxSize;
    }

    @Override
    public boolean handleUploadRequest(@Nonnull RequestContextImpl param, @Nonnull ConversationContext conversation) throws Exception {
        try {
            if (this.isDisabled()) {
                return true;
            }
            UploadItem[] uiar = param.getFileParameter(this.getInput().getActualID());
            if (uiar != null) {
                for (UploadItem ui : uiar) {
                    this.getFiles().add(ui);
                    conversation.registerTempFile(ui.getFile());
                }
            }
        }
        catch (FileUploadException fxu) {
            MessageFlare.display((NodeContainer)this, fxu.getMessage());
            return true;
        }
        this.forceRebuild();
        Page p = this.getPage();
        if (this.m_onValueChanged != null) {
            this.m_onValueChanged.onValueChanged(this);
        }
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return this.m_readOnly;
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        if (this.m_readOnly == readOnly) {
            return;
        }
        this.m_readOnly = readOnly;
        this.forceRebuild();
    }
}

