/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.upload;

import javax.annotation.Nonnull;
import to.etc.domui.component.upload.IUploadAcceptingComponent;
import to.etc.domui.parts.ComponentPartRenderer;
import to.etc.domui.server.ApplicationRequestHandler;
import to.etc.domui.server.DomApplication;
import to.etc.domui.server.RequestContextImpl;
import to.etc.domui.server.parts.IUnbufferedPartFactory;
import to.etc.domui.trouble.ThingyNotFoundException;

public class UploadPart
implements IUnbufferedPartFactory {
    @Override
    public void generate(@Nonnull DomApplication app, @Nonnull String rurl, @Nonnull RequestContextImpl param) throws Exception {
        try {
            ComponentPartRenderer r = new ComponentPartRenderer();
            r.initialize(app, param, rurl);
            if (!(r.getComponent() instanceof IUploadAcceptingComponent)) {
                throw new IllegalStateException("The targeted component " + r.getComponent() + " does not accept uploaded files.");
            }
            IUploadAcceptingComponent fu = (IUploadAcceptingComponent)((Object)r.getComponent());
            boolean render = fu.handleUploadRequest(param, r.getConversation());
            if (render) {
                param.getRequestResponse().setNoCache();
                ApplicationRequestHandler.renderOptimalDelta(param, r.getPage());
            }
        }
        catch (ThingyNotFoundException x) {
            System.err.println("domui: upload target " + rurl + " has gone while the upload commenced");
            param.getRequestResponse().sendError(404, x.getMessage());
        }
        catch (Exception x) {
            x.printStackTrace();
            throw x;
        }
    }
}

