/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component2.combo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.buttons.SmallImgButton;
import to.etc.domui.component.input.AbstractDivControl;
import to.etc.domui.component.input.CriteriaComboDataSet;
import to.etc.domui.component.meta.ClassMetaModel;
import to.etc.domui.component.meta.MetaManager;
import to.etc.domui.component.meta.PropertyMetaModel;
import to.etc.domui.dom.errors.UIMessage;
import to.etc.domui.dom.html.IClicked;
import to.etc.domui.dom.html.IControl;
import to.etc.domui.dom.html.IHasModifiedIndication;
import to.etc.domui.dom.html.IValueChanged;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.dom.html.NodeContainer;
import to.etc.domui.dom.html.Select;
import to.etc.domui.dom.html.SelectOption;
import to.etc.domui.server.DomApplication;
import to.etc.domui.trouble.ValidationException;
import to.etc.domui.util.DomUtil;
import to.etc.domui.util.IComboDataSet;
import to.etc.domui.util.IListMaker;
import to.etc.domui.util.INodeContentRenderer;
import to.etc.domui.util.IValueTransformer;
import to.etc.util.StringTool;
import to.etc.util.WrappedException;
import to.etc.webapp.query.QCriteria;

public class ComboComponentBase2<T, V>
extends AbstractDivControl<V>
implements IControl<V>,
IHasModifiedIndication {
    private String m_emptyText;
    private V m_currentValue;
    @Nonnull
    private final Select m_select = new Select(){

        @Override
        protected boolean internalOnUserInput(int oldindex, int nindex) {
            return ComboComponentBase2.this.internalOnUserInput(oldindex, nindex);
        }
    };
    private SelectOption m_emptyOption;
    private List<T> m_data;
    private INodeContentRenderer<T> m_contentRenderer;
    private INodeContentRenderer<T> m_actualContentRenderer;
    private Class<? extends INodeContentRenderer<T>> m_contentRendererClass;
    private PropertyMetaModel<?> m_propertyMetaModel;
    private IListMaker<T> m_listMaker;
    private Class<? extends IComboDataSet<T>> m_dataSetClass;
    private IComboDataSet<T> m_dataSet;
    private IValueTransformer<V> m_valueTransformer;
    private boolean m_readOnly;
    private List<SmallImgButton> m_buttonList = Collections.EMPTY_LIST;
    @Nullable
    private IValueChanged<?> m_onValueChanged;

    public ComboComponentBase2() {
    }

    public ComboComponentBase2(@Nonnull IListMaker<T> maker) {
        this.m_listMaker = maker;
    }

    public ComboComponentBase2(@Nonnull IComboDataSet<T> dataSet) {
        this.m_dataSet = dataSet;
    }

    public ComboComponentBase2(@Nonnull QCriteria<T> query) {
        this.m_dataSet = new CriteriaComboDataSet<T>(query);
    }

    public ComboComponentBase2(Class<? extends IComboDataSet<T>> dataSetClass) {
        this.m_dataSetClass = dataSetClass;
    }

    public ComboComponentBase2(@Nonnull List<T> in) {
        this.m_data = in;
    }

    public ComboComponentBase2(Class<? extends IComboDataSet<T>> set, INodeContentRenderer<T> r) {
        this.m_dataSetClass = set;
        this.m_contentRenderer = r;
    }

    @Override
    public void createContent() throws Exception {
        if (this.m_readOnly) {
            this.renderReadOnly();
        } else {
            this.renderEditable();
        }
        for (SmallImgButton sib : this.m_buttonList) {
            this.add(sib);
        }
    }

    private void renderReadOnly() throws Exception {
        this.setCssClass("ui-cbb2 ui-cbb2-ro");
        List<T> list = this.getData();
        V raw = this.internalGetCurrentValue();
        int index = this.findListIndexForValue(raw);
        if (index == -1) {
            if (!StringTool.isBlank((String)this.m_emptyText)) {
                this.add(this.m_emptyText);
            }
            return;
        }
        T item = list.get(index);
        this.renderOptionLabel(this, item);
    }

    private void renderEditable() throws Exception {
        this.setCssClass("ui-cbb2 ui-cbb2-rw");
        this.add(this.m_select);
        List<T> list = this.getData();
        V raw = this.internalGetCurrentValue();
        boolean isvalidselection = false;
        int ix = 0;
        ClassMetaModel cmm = null;
        for (T val : list) {
            SelectOption o = new SelectOption();
            this.m_select.add(o);
            this.renderOptionLabel(o, val);
            if (null != raw) {
                boolean eq;
                V res = this.listToValue(val);
                if (cmm == null) {
                    cmm = MetaManager.findClassMeta(raw.getClass());
                }
                if (eq = MetaManager.areObjectsEqual(res, raw, cmm)) {
                    o.setSelected(eq);
                    this.m_select.internalSetSelectedIndex(ix);
                    isvalidselection = true;
                }
            }
            ++ix;
        }
        this.setEmptyOption(null);
        if (!this.isMandatory() || !isvalidselection) {
            SelectOption o = new SelectOption();
            if (this.getEmptyText() != null) {
                o.setText(this.getEmptyText());
            }
            this.m_select.add(0, o);
            this.setEmptyOption(o);
            if (!isvalidselection) {
                o.setSelected(true);
                this.m_select.internalSetSelectedIndex(0);
            } else {
                this.m_select.internalSetSelectedIndex(this.m_select.getSelectedIndex() + 1);
            }
        }
    }

    @Override
    @Nullable
    protected String getFocusID() {
        if (this.m_select.isAttached()) {
            return this.m_select.getActualID();
        }
        return null;
    }

    @Override
    public final V getValue() {
        try {
            this.validateBindValue();
            this.setMessage(null);
            return this.m_currentValue;
        }
        catch (ValidationException vx) {
            this.setMessage(UIMessage.error(vx));
            throw vx;
        }
    }

    public final V getBindValue() {
        this.validateBindValue();
        return this.m_currentValue;
    }

    public final void setBindValue(V value) {
        if (MetaManager.areObjectsEqual(this.m_currentValue, value)) {
            return;
        }
        this.setValue(value);
    }

    private void validateBindValue() {
        if (this.isMandatory() && this.m_currentValue == null) {
            throw new ValidationException("ui.mandatory", new Object[0]);
        }
    }

    @Override
    public final void setValue(@Nullable V v) {
        V currentValue = this.m_currentValue;
        ClassMetaModel cmm = v != null ? MetaManager.findClassMeta(v.getClass()) : null;
        if (MetaManager.areObjectsEqual(v, currentValue, cmm)) {
            return;
        }
        this.m_currentValue = v;
        if (!this.isBuilt()) {
            return;
        }
        if (this.m_readOnly) {
            this.forceRebuild();
            return;
        }
        int ix = this.findListIndexForValue(v);
        if (null == v || ix < 0) {
            if (this.getEmptyOption() == null) {
                SelectOption o = new SelectOption();
                if (this.getEmptyText() != null) {
                    o.setText(this.getEmptyText());
                }
                this.add(0, o);
                this.setEmptyOption(o);
            }
            this.m_select.setSelectedIndex(0);
            return;
        }
        if (this.getEmptyOption() != null) {
            ++ix;
        }
        this.m_select.setSelectedIndex(ix);
    }

    protected final boolean internalOnUserInput(int oldindex, int nindex) {
        Object newval = nindex < 0 ? null : (this.getEmptyOption() != null ? (nindex <= 0 ? null : this.findListValueByIndex(--nindex)) : this.findListValueByIndex(nindex));
        ClassMetaModel cmm = newval == null ? null : MetaManager.findClassMeta(newval.getClass());
        V currentValue = this.m_currentValue;
        if (MetaManager.areObjectsEqual(newval, currentValue, cmm)) {
            return false;
        }
        this.clearMessage();
        this.m_currentValue = newval;
        return true;
    }

    private int findListIndexForValue(V newvalue) {
        if (null == newvalue) {
            return -1;
        }
        try {
            ClassMetaModel cmm = MetaManager.findClassMeta(newvalue.getClass());
            List<T> data = this.getData();
            for (int ix = 0; ix < data.size(); ++ix) {
                V value = this.listToValue(data.get(ix));
                if (!MetaManager.areObjectsEqual(value, newvalue, cmm)) continue;
                return ix;
            }
            return -1;
        }
        catch (Exception x) {
            throw WrappedException.wrap((Exception)x);
        }
    }

    private V findListValueByIndex(int ix) {
        try {
            List<T> data = this.getData();
            if (ix < 0 || ix >= data.size()) {
                return null;
            }
            return this.listToValue(data.get(ix));
        }
        catch (Exception x) {
            throw WrappedException.wrap((Exception)x);
        }
    }

    protected V listToValue(T in) throws Exception {
        if (this.m_valueTransformer == null) {
            return (V)in;
        }
        return this.m_valueTransformer.getValue(in);
    }

    private INodeContentRenderer<T> calculateContentRenderer(Object val) {
        if (this.m_contentRenderer != null) {
            return this.m_contentRenderer;
        }
        if (this.m_contentRendererClass != null) {
            return DomApplication.get().createInstance(this.m_contentRendererClass, new Object[0]);
        }
        if (val == null) {
            throw new IllegalStateException("Cannot calculate content renderer for null value");
        }
        ClassMetaModel cmm = MetaManager.findClassMeta(val.getClass());
        return MetaManager.createDefaultComboRenderer(this.m_propertyMetaModel, cmm);
    }

    protected final void renderOptionLabel(NodeContainer o, T object) throws Exception {
        if (this.m_actualContentRenderer == null) {
            this.m_actualContentRenderer = this.calculateContentRenderer(object);
        }
        this.m_actualContentRenderer.renderNodeContent(this, o, object, this);
    }

    public void setData(List<T> data) {
        if (this.m_data != data) {
            this.forceRebuild();
            this.m_select.forceRebuild();
            this.m_actualContentRenderer = null;
        }
        this.m_data = data;
    }

    public List<T> getData() throws Exception {
        if (this.m_data == null) {
            this.m_data = this.provideData();
        }
        return this.m_data;
    }

    protected List<T> provideData() throws Exception {
        if (this.m_listMaker != null) {
            return DomApplication.get().getCachedList(this.m_listMaker);
        }
        IComboDataSet<T> builder = this.m_dataSet;
        if (builder == null && this.m_dataSetClass != null) {
            builder = DomApplication.get().createInstance(this.m_dataSetClass, new Object[0]);
        }
        if (builder != null) {
            return builder.getComboDataSet(this.getPage().getBody());
        }
        return Collections.EMPTY_LIST;
    }

    public void addExtraButton(String img, String title, final IClicked<NodeBase> click) {
        if (this.m_buttonList == Collections.EMPTY_LIST) {
            this.m_buttonList = new ArrayList<SmallImgButton>();
        }
        SmallImgButton si = new SmallImgButton(img);
        if (click != null) {
            si.setClicked(new IClicked<SmallImgButton>(){

                @Override
                public void clicked(@Nonnull SmallImgButton b) throws Exception {
                    click.clicked(ComboComponentBase2.this);
                }
            });
        }
        if (title != null) {
            si.setTitle(title);
        }
        si.addCssClass("ui-cl2-btn");
        this.m_buttonList.add(si);
        if (this.isBuilt()) {
            this.forceRebuild();
        }
    }

    @Override
    public V getValueSafe() {
        return (V)DomUtil.getValueSafe(this);
    }

    @Override
    public boolean hasError() {
        this.getValueSafe();
        return super.hasError();
    }

    public INodeContentRenderer<T> getContentRenderer() {
        return this.m_contentRenderer;
    }

    public void setContentRenderer(INodeContentRenderer<T> contentRenderer) {
        this.m_contentRenderer = contentRenderer;
    }

    public Class<? extends INodeContentRenderer<T>> getContentRendererClass() {
        return this.m_contentRendererClass;
    }

    public void setContentRendererClass(Class<? extends INodeContentRenderer<T>> contentRendererClass) {
        this.m_contentRendererClass = contentRendererClass;
    }

    public PropertyMetaModel<?> getPropertyMetaModel() {
        return this.m_propertyMetaModel;
    }

    public void setPropertyMetaModel(PropertyMetaModel<?> propertyMetaModel) {
        this.m_propertyMetaModel = propertyMetaModel;
    }

    public IListMaker<T> getListMaker() {
        return this.m_listMaker;
    }

    public void setListMaker(IListMaker<T> listMaker) {
        this.m_listMaker = listMaker;
    }

    public IValueTransformer<V> getValueTransformer() {
        return this.m_valueTransformer;
    }

    public void setValueTransformer(IValueTransformer<V> valueTransformer) {
        this.m_valueTransformer = valueTransformer;
    }

    public String getEmptyText() {
        return this.m_emptyText;
    }

    public void setEmptyText(String emptyText) {
        this.m_emptyText = emptyText;
    }

    protected SelectOption getEmptyOption() {
        return this.m_emptyOption;
    }

    protected void setEmptyOption(SelectOption emptyOption) {
        this.m_emptyOption = emptyOption;
    }

    protected V internalGetCurrentValue() {
        return this.m_currentValue;
    }

    @Override
    public void setMandatory(boolean mandatory) {
        if (this.isMandatory() == mandatory) {
            return;
        }
        this.m_select.setMandatory(mandatory);
        this.forceRebuild();
    }

    @Override
    public IValueChanged<?> getOnValueChanged() {
        return this.m_onValueChanged;
    }

    @Override
    public void setOnValueChanged(IValueChanged<?> onValueChanged) {
        if (this.m_onValueChanged == onValueChanged) {
            return;
        }
        this.m_onValueChanged = onValueChanged;
        if (null == onValueChanged) {
            this.m_select.setOnValueChanged(null);
        } else {
            this.m_select.setOnValueChanged(new IValueChanged<Select>(){

                @Override
                public void onValueChanged(@Nonnull Select component) throws Exception {
                    IValueChanged vc = ComboComponentBase2.this.m_onValueChanged;
                    if (null != vc) {
                        vc.onValueChanged(ComboComponentBase2.this);
                    }
                }
            });
        }
    }

    public void immediate() {
        this.m_select.immediate();
    }

    @Override
    public void setDisabled(boolean d) {
        this.m_select.setDisabled(d);
    }

    @Override
    public boolean isModified() {
        return this.m_select.isModified();
    }

    @Override
    public void setModified(boolean as) {
        this.m_select.setModified(as);
    }

    @Override
    public boolean isReadOnly() {
        return this.m_readOnly;
    }

    @Override
    public void setReadOnly(boolean ro) {
        if (this.m_readOnly == ro) {
            return;
        }
        this.m_readOnly = ro;
        this.forceRebuild();
    }

    @Override
    public boolean isDisabled() {
        return this.m_select.isDisabled();
    }

    @Override
    public boolean isMandatory() {
        return this.m_select.isMandatory();
    }

    @Override
    public void setMaxWidth(String maxWidth) {
        super.setMaxWidth(maxWidth);
        this.m_select.setMaxWidth(maxWidth);
    }
}

