/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component2.controlfactory;

import java.math.BigDecimal;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.input.Text;
import to.etc.domui.component.meta.NumericPresentation;
import to.etc.domui.component.meta.PropertyMetaModel;
import to.etc.domui.component2.controlfactory.IControlCreator;
import to.etc.domui.dom.html.IControl;

public class ControlCreatorMoney
implements IControlCreator {
    @Override
    public <T> int accepts(PropertyMetaModel<T> pmm, Class<? extends IControl<T>> controlClass) {
        if (controlClass != null && !controlClass.isAssignableFrom(Text.class)) {
            return -1;
        }
        Class<T> clz = pmm.getActualType();
        if (clz != Double.class && clz != Double.TYPE && clz != BigDecimal.class) {
            return -1;
        }
        if (!NumericPresentation.isMonetary(pmm.getNumericPresentation())) {
            return -1;
        }
        return 2;
    }

    @Override
    public <T, C extends IControl<T>> C createControl(@Nonnull PropertyMetaModel<T> pmm, @Nullable Class<C> controlClass) {
        Text<Number> txt;
        if (pmm.getActualType() == Double.class || pmm.getActualType() == Double.TYPE) {
            txt = Text.createDoubleMoneyInput(pmm, true);
        } else if (pmm.getActualType() == BigDecimal.class) {
            txt = Text.createBDMoneyInput(pmm, true);
        } else {
            throw new IllegalStateException("Cannot handle type=" + pmm.getActualType() + " in monetary control factory");
        }
        return (C)txt;
    }
}

