/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component2.controlfactory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.meta.PropertyMetaModel;
import to.etc.domui.component2.controlfactory.ControlCreatorBoolean;
import to.etc.domui.component2.controlfactory.ControlCreatorDate;
import to.etc.domui.component2.controlfactory.ControlCreatorEnumAndBool;
import to.etc.domui.component2.controlfactory.ControlCreatorMoney;
import to.etc.domui.component2.controlfactory.ControlCreatorRelationCombo;
import to.etc.domui.component2.controlfactory.ControlCreatorRelationLookup;
import to.etc.domui.component2.controlfactory.ControlCreatorString;
import to.etc.domui.component2.controlfactory.ControlCreatorTextArea;
import to.etc.domui.component2.controlfactory.IControlCreator;
import to.etc.domui.dom.html.IControl;

public class ControlCreatorRegistry {
    @Nonnull
    private List<IControlCreator> m_controlFactoryList = new ArrayList<IControlCreator>();

    public ControlCreatorRegistry() {
        this.register(new ControlCreatorDate());
        this.register(new ControlCreatorEnumAndBool());
        this.register(new ControlCreatorMoney());
        this.register(new ControlCreatorRelationCombo());
        this.register(new ControlCreatorRelationLookup());
        this.register(new ControlCreatorString());
        this.register(new ControlCreatorTextArea());
        this.register(new ControlCreatorBoolean());
    }

    public synchronized void register(@Nonnull IControlCreator cf) {
        ArrayList<IControlCreator> list = new ArrayList<IControlCreator>(this.m_controlFactoryList);
        list.add(cf);
        this.m_controlFactoryList = Collections.unmodifiableList(list);
    }

    @Nonnull
    protected synchronized List<IControlCreator> getControlFactoryList() {
        return this.m_controlFactoryList;
    }

    @Nonnull
    public <T, C extends IControl<T>> C createControl(@Nonnull PropertyMetaModel<T> pmm, @Nullable Class<C> controlClass) {
        IControlCreator bestcc = null;
        int bestScore = 0;
        for (IControlCreator cc : this.getControlFactoryList()) {
            int score = cc.accepts(pmm, controlClass);
            if (score <= bestScore) continue;
            bestcc = cc;
            bestScore = score;
        }
        if (bestcc == null) {
            throw new IllegalStateException("No control factory found for " + pmm + " and class=" + controlClass);
        }
        return bestcc.createControl(pmm, controlClass);
    }
}

